/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SuiteSelectionDialog
extends ElementTreeSelectionDialog {
    public SuiteSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.setAllowMultiple(false);
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    if (element instanceof IContainer) {
                        if (element instanceof IProject && !((IProject)element).isOpen()) {
                            return false;
                        }
                        return this.containsSuites((IContainer)element);
                    }
                    return this.isSuite((IResource)element);
                }
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean containsSuites(IContainer element) {
                try {
                    IResource[] iResourceArray = element.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource resource = iResourceArray[n2];
                        if (resource instanceof IContainer ? this.containsSuites((IContainer)resource) : this.isSuite(resource)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
                return false;
            }

            private boolean isSuite(IResource resource) {
                return "suite".equals(resource.getProjectRelativePath().getFileExtension());
            }
        });
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
    }

    public IFile getSuiteFile() {
        Object result = this.getFirstResult();
        if (result instanceof IFile) {
            return (IFile)result;
        }
        return null;
    }
}

