/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.charting;

import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.charting.views.Chart;
import org.eclipse.ease.modules.charting.views.ChartView;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.ui.PartInitException;

public class ChartingModule
extends AbstractScriptModule {
    public static final String MODULE_NAME = "Charting";
    private Chart fChart = null;
    private static int fFigureIterator = 1;

    @WrapToScript
    public Chart figure(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String figureId) throws Throwable {
        this.fChart = null;
        String secondaryId = figureId == null ? "Figure " + Integer.toString(fFigureIterator++) : figureId;
        ChartView view = (ChartView)UIModule.showView((String)"org.eclipse.ease.modules.charting.views.ChartView", (String)secondaryId, (int)1);
        view.setViewName(secondaryId);
        this.fChart = view.getChart();
        this.fChart.setPlotTitle(secondaryId);
        return this.fChart;
    }

    @WrapToScript
    public Trace series(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String seriesName, @ScriptParameter(defaultValue="") String format) throws Throwable {
        return this.getChart().series(seriesName, format);
    }

    private Chart getChart() throws Throwable {
        if (this.fChart == null) {
            this.figure(null);
        }
        return this.fChart;
    }

    @WrapToScript
    public Trace plotPoint(double x, double y) throws Throwable {
        return this.getChart().plot(x, y);
    }

    @WrapToScript
    public Trace plot(double[] x, double[] y) throws Throwable {
        return this.getChart().plot(x, y);
    }

    @WrapToScript(alias="title")
    public XYGraph setPlotTitle(String chartTitle) throws PartInitException {
        if (this.fChart != null) {
            return this.fChart.setPlotTitle(chartTitle);
        }
        return null;
    }

    @WrapToScript(alias="xlabel")
    public Axis setXLabel(String label) throws PartInitException {
        if (this.fChart != null) {
            return this.fChart.setXLabel(label);
        }
        return null;
    }

    @WrapToScript(alias="ylabel")
    public Axis setYLabel(String label) throws PartInitException {
        if (this.fChart != null) {
            return this.fChart.setYLabel(label);
        }
        return null;
    }

    @WrapToScript(alias="axis")
    public void setAxisRange(double[] xRange, double[] yRange) throws Exception {
        if (this.fChart != null) {
            this.fChart.setAxisRange(xRange, yRange);
        }
    }

    @WrapToScript
    public void showGrid(boolean showGrid) throws PartInitException {
        if (this.fChart != null) {
            this.fChart.showGrid(showGrid);
        }
    }

    @WrapToScript
    public void setAutoScale(boolean performAutoScale) throws PartInitException {
        if (this.fChart != null) {
            this.fChart.setAutoScale(performAutoScale);
        }
    }

    @WrapToScript
    public void clear() throws PartInitException {
        if (this.fChart != null) {
            this.fChart.clear();
        }
    }

    @WrapToScript
    public void exportGraph(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object location, @ScriptParameter(defaultValue="false") boolean overwrite) throws Throwable {
        if (this.fChart != null) {
            Object resolvedLocation = location != null ? ResourceTools.resolveFile((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (boolean)false) : null;
            this.getChart().export(resolvedLocation, overwrite);
        }
    }

    @WrapToScript
    public void removeSeries(String seriesName) throws Throwable {
        this.getChart().removeSeries(seriesName);
    }
}

