/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ease.lang.python.jython.Activator;
import org.python.core.packagecache.SysPackageManager;

public class JythonPackageManager
extends SysPackageManager {
    private final Map<String, Boolean> mLookupCache = new HashMap<String, Boolean>();
    private static final List<String> RESERVED_LIBS = Arrays.asList("strop");

    public JythonPackageManager(File cachedir, Properties registry) {
        super(cachedir, registry);
    }

    public boolean packageExists(String pkg, String name) {
        String qualifiedName;
        StringBuilder buffer = new StringBuilder();
        if (pkg != null && !pkg.isEmpty()) {
            buffer.append(pkg);
        }
        if (name != null && !name.isEmpty()) {
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            buffer.append(name);
        }
        if (this.mLookupCache.containsKey(qualifiedName = buffer.toString())) {
            return this.mLookupCache.get(qualifiedName);
        }
        if (this.isPythonLib(qualifiedName)) {
            this.mLookupCache.put(qualifiedName, false);
            return false;
        }
        if (qualifiedName.endsWith(".__path__") && this.mLookupCache.containsKey(qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 9))) {
            return this.mLookupCache.get(qualifiedName);
        }
        try {
            Class.forName(qualifiedName);
            this.mLookupCache.put(qualifiedName, false);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.mLookupCache.put(qualifiedName, true);
            return true;
        }
    }

    private boolean isPythonLib(String qualifiedName) {
        try {
            if (qualifiedName != null && qualifiedName.contains("extlibraryinitHelper")) {
                return true;
            }
        }
        catch (Exception exception) {}
        if (qualifiedName.startsWith("_") && !qualifiedName.startsWith("org.jython")) {
            return true;
        }
        for (File folder : Activator.getLibraryFolders()) {
            String path = folder.getPath();
            File resolvedFolder = new File(String.valueOf(path) + File.separator + qualifiedName.replaceAll("\\.", "/"));
            File resolvedLib = new File(String.valueOf(path) + File.separator + qualifiedName.replaceAll("\\.", "/") + ".py");
            if (resolvedFolder.exists()) {
                return true;
            }
            if (!resolvedLib.exists()) continue;
            return true;
        }
        return RESERVED_LIBS.contains(qualifiedName);
    }
}

