/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.unittest.definition.provider.TestDefinitionEditPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ease.lang.unittest.ui";
    private static Activator fInstance;
    private BundleContext fContext;
    private TestDefinitionEditPlugin.Implementation fEMFInstance;

    public static Activator getDefault() {
        return fInstance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fEMFInstance = new TestDefinitionEditPlugin.Implementation();
        this.fEMFInstance.start(context);
        this.fContext = context;
        fInstance = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.fEMFInstance.stop(context);
        fInstance = null;
        this.fContext = null;
        super.stop(context);
    }

    public BundleContext getContext() {
        return this.fContext;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static ImageDescriptor getImageDescriptor(String bundleID, String path) {
        assert (bundleID != null) : "No bundle defined";
        assert (path != null) : "No path defined";
        Bundle bundle = Platform.getBundle((String)bundleID);
        int bundleState = bundle.getState();
        if (bundleState != 32 && bundleState != 8 && bundleState != 4) {
            return null;
        }
        URL imagePath = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (imagePath != null) {
            return ImageDescriptor.createFromURL((URL)imagePath);
        }
        return null;
    }

    public static Image getImage(String bundleID, String path, boolean storeToImageRegistry) {
        ImageDescriptor descriptor;
        assert (bundleID != null) : "No bundle defined";
        assert (path != null) : "No path defined";
        Image image = Activator.getDefault().getImageRegistry().get(String.valueOf(bundleID) + path);
        if (image == null && (descriptor = Activator.getImageDescriptor(bundleID, path)) != null) {
            image = descriptor.createImage();
            if (storeToImageRegistry) {
                Activator.getDefault().getImageRegistry().put(String.valueOf(bundleID) + path, image);
            }
        }
        return image;
    }

    protected final File getConfigurationFile(String name) {
        return this.getStateLocation().append(name).toFile();
    }

    public static Image getPluginIconImage(String pluginId, String iconPath) {
        String key = String.valueOf(pluginId) + iconPath;
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(key);
        if (image == null) {
            ImageDescriptor desc = Activator.getImageDescriptor(pluginId, iconPath);
            registry.put(key, desc);
            image = registry.get(key);
        }
        return image;
    }

    public static Image getLocalPluginIconImage(String iconPath) {
        return Activator.getPluginIconImage(PLUGIN_ID, iconPath);
    }

    public static ImageDescriptor getLocalImageDescriptor(String iconPath) {
        return Activator.getImageDescriptor(PLUGIN_ID, iconPath);
    }

    public static InputStream getResource(String path) {
        try {
            URL url = new URL("platform:/plugin/org.eclipse.ease.ui/" + path);
            return url.openConnection().getInputStream();
        }
        catch (IOException e) {
            Logger.error((String)PLUGIN_ID, (String)"Cannot read style sheet for hover presentation", (Throwable)e);
            return null;
        }
    }
}

