/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.charting;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.charting.views.Chart;
import org.eclipse.ease.modules.charting.views.ChartView;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ChartingModule
extends AbstractScriptModule {
    public static final String MODULE_NAME = "Charting";
    private static int fFigureIterator = 1;
    private Chart fChart = null;
    private XYGraph fXYGraph = null;
    private Trace fCurrentPlot = null;
    private final Collection<Annotation> fUserMarkers = new HashSet<Annotation>();

    @WrapToScript
    public Chart figure(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String figureId) throws Throwable {
        this.fChart = null;
        String secondaryId = figureId == null ? "Figure " + Integer.toString(fFigureIterator++) : figureId;
        ChartView view = (ChartView)UIModule.showView((String)"org.eclipse.ease.modules.charting.views.ChartView", (String)secondaryId, (int)1);
        view.setViewName(secondaryId);
        this.fChart = view.getChart();
        this.fXYGraph = this.fChart.setPlotTitle(secondaryId);
        return this.fChart;
    }

    @WrapToScript
    public Chart createChart(Composite parent, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String figureId) {
        String secondaryId = figureId == null ? "Figure " + Integer.toString(fFigureIterator++) : figureId;
        Display.getDefault().syncExec(() -> {
            this.fChart = new Chart(parent, 0);
            this.fXYGraph = this.fChart.setPlotTitle(secondaryId);
        });
        return this.fChart;
    }

    @WrapToScript
    public Trace series(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String seriesName, @ScriptParameter(defaultValue="") String format) throws Throwable {
        return this.getChart().series(seriesName, format);
    }

    private Chart getChart() throws Throwable {
        if (this.fChart == null) {
            this.figure(null);
        }
        return this.fChart;
    }

    @WrapToScript
    public Trace plotPoint(double x, double y) throws Throwable {
        this.fCurrentPlot = this.getChart().plot(x, y);
        return this.fCurrentPlot;
    }

    @WrapToScript
    public Trace plot(double[] x, double[] y) throws Throwable {
        this.fCurrentPlot = this.getChart().plot(x, y);
        return this.fCurrentPlot;
    }

    @WrapToScript(alias="title")
    public XYGraph setPlotTitle(String chartTitle) {
        if (this.fChart != null) {
            return this.fChart.setPlotTitle(chartTitle);
        }
        return null;
    }

    @WrapToScript(alias="xlabel")
    public Axis setXLabel(String label) {
        if (this.fChart != null) {
            return this.fChart.setXLabel(label);
        }
        return null;
    }

    @WrapToScript(alias="ylabel")
    public Axis setYLabel(String label) {
        if (this.fChart != null) {
            return this.fChart.setYLabel(label);
        }
        return null;
    }

    @WrapToScript(alias="axis")
    public void setAxisRange(double[] xRange, double[] yRange) {
        if (this.fChart != null) {
            this.fChart.setAxisRange(xRange, yRange);
        }
    }

    @WrapToScript
    public void showGrid(boolean showGrid) {
        if (this.fChart != null) {
            this.fChart.showGrid(showGrid);
        }
    }

    @WrapToScript
    public void setAutoScale(boolean performAutoScale) {
        if (this.fChart != null) {
            this.fChart.setAutoScale(performAutoScale);
        }
    }

    @WrapToScript
    public void clear() {
        Display.getDefault().syncExec(() -> {
            if (this.fXYGraph != null) {
                for (Annotation marker : this.fUserMarkers) {
                    this.fXYGraph.removeAnnotation(marker);
                }
            }
        });
        if (this.fChart != null) {
            this.fChart.clear();
        }
        this.fCurrentPlot = null;
    }

    @WrapToScript
    public void exportGraph(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object location, @ScriptParameter(defaultValue="false") boolean overwrite) throws Throwable {
        if (this.fChart != null) {
            Object resolvedLocation = location != null ? ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile()) : null;
            this.getChart().export(resolvedLocation, overwrite);
        }
    }

    @WrapToScript
    public void removeSeries(String seriesName) throws Throwable {
        this.getChart().removeSeries(seriesName);
    }

    @WrapToScript
    public Annotation addMarker(String text, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Double xPosition, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Double yPosition) {
        if (this.fCurrentPlot != null) {
            Annotation annotation = new Annotation(text, this.fCurrentPlot);
            annotation.setEnabled(true);
            annotation.setCursorLineStyle(Annotation.CursorLineStyle.NONE);
            Display.getDefault().asyncExec(() -> {
                this.fXYGraph.addAnnotation(annotation);
                Display.getDefault().asyncExec(() -> {
                    if (xPosition != null && yPosition != null) {
                        annotation.setValues(xPosition.doubleValue(), yPosition.doubleValue());
                    }
                });
            });
            this.fUserMarkers.add(annotation);
            return annotation;
        }
        return null;
    }
}

