/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.editor.sections;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.eatop.common.util.IdentifiableUtil;
import org.eclipse.eatop.examples.editor.internal.Activator;
import org.eclipse.eatop.examples.editor.internal.messages.Messages;
import org.eclipse.eatop.examples.editor.internal.widgets.FormWidgetFactory;
import org.eclipse.eatop.examples.editor.internal.widgets.IFormWidgetFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.editors.forms.pages.AbstractFormPage;
import org.eclipse.sphinx.emf.editors.forms.sections.AbstractFieldFormSection;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.platform.ui.fields.IStringField;
import org.eclipse.sphinx.platform.ui.fields.StringField;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class CommentsSection
extends AbstractFieldFormSection {
    private boolean editable;
    private boolean fRefreshingFields = false;
    private boolean fUpdatingModel = false;
    private IStringField fDescField;

    public CommentsSection(AbstractFormPage formPage, Object sectionInput) {
        this(formPage, sectionInput, 0, true);
    }

    public CommentsSection(AbstractFormPage formPage, Object sectionInput, boolean editable) {
        this(formPage, sectionInput, 0, editable);
    }

    public CommentsSection(AbstractFormPage formPage, Object sectionInput, int style, boolean editable) {
        super(formPage, sectionInput, style);
        this.editable = editable;
        this.title = Messages.CommentsSection_title;
        this.description = Messages.CommentsSection_description;
    }

    protected void createSectionClientContent(IManagedForm managedForm, SectionPart sectionPart, Composite sectionClient) {
        Assert.isNotNull((Object)managedForm);
        Assert.isNotNull((Object)sectionPart);
        Assert.isNotNull((Object)sectionClient);
        FormWidgetFactory widgetFactory = new FormWidgetFactory(managedForm.getToolkit());
        Layout layout = sectionClient.getLayout();
        int numColumns = ((TableWrapLayout)layout).numColumns;
        this.createDescField(this.sectionInput, widgetFactory, sectionClient, numColumns);
    }

    private void createDescField(final Object sectionInput, IFormWidgetFactory widgetFactory, Composite sectionClient, int numColumns) {
        this.fDescField = new StringField((IWidgetFactory)widgetFactory, true);
        this.fDescField.setLabelText(Messages.CommentsSection_descField_label);
        this.fDescField.setToolTipText(Messages.CommentsSection_descField_toolTip);
        this.fDescField.setEnabled(true);
        String desc = IdentifiableUtil.getDesc((Object)sectionInput);
        this.fDescField.setText(desc);
        this.fDescField.fillIntoGrid(sectionClient, numColumns);
        this.fDescField.getTextControl().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
            }

            public void focusLost(FocusEvent evt) {
                Text text = (Text)evt.widget;
                if (!CommentsSection.this.isRefreshingFields()) {
                    TransactionalEditingDomain editingDomain;
                    String oldValue;
                    final String newValue = text.getText();
                    if (!CommentsSection.this.isRefreshingFields() && CommentsSection.this.isPropertyValueChanged(newValue, oldValue = IdentifiableUtil.getDesc((Object)sectionInput)) && (editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)sectionInput)) != null) {
                        CommentsSection.this.fUpdatingModel = true;
                        try {
                            WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    IdentifiableUtil.setDesc((Object)sectionInput, (String)newValue);
                                }
                            }, (String)"Set desc");
                        }
                        catch (OperationCanceledException ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                        }
                        catch (ExecutionException ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                        }
                        CommentsSection.this.fUpdatingModel = false;
                    }
                }
            }
        });
    }

    private void refreshDescField(Object sectionInput) {
        if (this.isControlAccessible(this.fDescField.getTextControl())) {
            String desc = IdentifiableUtil.getDesc((Object)sectionInput);
            this.fDescField.setText(desc);
        }
    }

    protected final boolean isRefreshingFields() {
        return this.fRefreshingFields;
    }

    protected final void setRefreshingFields(boolean refreshing) {
        this.fRefreshingFields = refreshing;
    }

    public void refreshSection() {
        this.setRefreshingFields(true);
        this.refreshDescField(this.sectionInput);
        this.setRefreshingFields(false);
    }

    protected final boolean isPropertyValueChanged(Object newValue, Object oldValue) {
        return oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
    }
}

