/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.explorer.properties;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.eatop.common.ui.util.InstanceRefAdder;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.eatop.examples.explorer.properties.ExpandedTransactionalAdvancedPropertySection;
import org.eclipse.eatop.examples.explorer.properties.InstanceRefPropertySourceProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AdvancedInstanceRefPropertySection
extends ExpandedTransactionalAdvancedPropertySection {
    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.cleanExpandbar();
        Object selObject = ((TreeSelection)selection).getFirstElement();
        if (selObject instanceof EObject && ModelSearcher.canCreateInstanceRefChild((EObject)((EObject)selObject))) {
            InstanceRefAdder.AddInstanceRef((EObject)((EObject)selObject));
        }
        if (selObject instanceof EObject && ModelSearcher.hasInstanceRefChild((EObject)((EObject)selObject))) {
            EObject target = (EObject)((TreeSelection)selection).getFirstElement();
            ArrayList children = ModelSearcher.getInstanceRefChildren((EObject)target);
            Collections.reverse(children);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(100, 0);
            for (EObject instanceRef : children) {
                PropertySheetPage page = new PropertySheetPage();
                page.setPropertySourceProvider((IPropertySourceProvider)new InstanceRefPropertySourceProvider(instanceRef));
                Composite form = this.getWidgetFactory().createFlatFormComposite((Composite)this.expandBar);
                page.createControl(form);
                page.getControl().setLayoutData((Object)data);
                ExpandItem item = new ExpandItem(this.expandBar, 0, 0);
                item.setText(String.valueOf(ModelSearcher.elementNameInParent((EObject)instanceRef)) + " [" + ModelSearcher.getInstanceRefPathString((EObject)instanceRef) + "]");
                item.setHeight(page.getControl().computeSize((int)85, (int)70).y);
                item.setControl((Control)form);
                item.setExpanded(true);
                this.pages.add(page);
            }
        }
        for (PropertySheetPage page : this.pages) {
            page.selectionChanged(part, selection);
        }
    }

    private void cleanExpandbar() {
        ExpandItem item;
        if (this.pages != null) {
            for (PropertySheetPage page : this.pages) {
                page.dispose();
                page = null;
            }
            this.pages.clear();
        }
        ExpandItem[] expandItemArray = this.expandBar.getItems();
        int n = expandItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = expandItemArray[n2];
            item.dispose();
            item = null;
            ++n2;
        }
        expandItemArray = this.expandBar.getChildren();
        n = expandItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = expandItemArray[n2];
            item.dispose();
            Object var1_3 = null;
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.pages != null) {
            for (PropertySheetPage page : this.pages) {
                page.dispose();
                Object var1_2 = null;
            }
            this.pages.clear();
            this.pages = null;
        }
        if (this.expandBar != null) {
            this.expandBar.dispose();
            this.expandBar = null;
        }
    }

    public void refresh() {
        for (PropertySheetPage page : this.pages) {
            page.refresh();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

