/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.explorer.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.sphinx.emf.ui.properties.FilteringPropertySource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public abstract class InstanceRefPropertySourceAbstractProvider
implements IPropertySourceProvider {
    protected EObject instanceRef;
    protected IPropertySourceProvider lastPropertySourceProviderDelegate = null;

    public InstanceRefPropertySourceAbstractProvider(EObject instanceRef) {
        this.instanceRef = instanceRef;
    }

    public IPropertySource getPropertySource(Object object) {
        EObject parent;
        if (object instanceof EObject && ModelSearcher.hasInstanceRefChild((EObject)(parent = (EObject)object))) {
            for (EObject instanceRefChild : ModelSearcher.getInstanceRefChildren((EObject)parent)) {
                if (!instanceRefChild.equals(this.instanceRef)) continue;
                return this.getPropertySourceForInstanceRef();
            }
        }
        return null;
    }

    private IPropertySource getPropertySourceForInstanceRef() {
        Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)this.instanceRef);
        if (unwrapped != null) {
            IPropertySource propertySource;
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)unwrapped);
            if (editingDomain != null) {
                this.lastPropertySourceProviderDelegate = this.createModelPropertySourceProvider(editingDomain);
            }
            if (this.lastPropertySourceProviderDelegate != null && (propertySource = this.lastPropertySourceProviderDelegate.getPropertySource((Object)this.instanceRef)) != null) {
                return new FilteringPropertySource(propertySource);
            }
        }
        if (this.instanceRef instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)this.instanceRef;
            return (IPropertySource)adaptable.getAdapter(IPropertySource.class);
        }
        return null;
    }

    protected IPropertySourceProvider createModelPropertySourceProvider(TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        return new TransactionalAdapterFactoryContentProvider(editingDomain, adapterFactory){

            protected IPropertySource createPropertySource(final Object object, final IItemPropertySource itemPropertySource) {
                return this.wrap((IPropertySource)this.run((RunnableWithResult)new RunnableWithResult.Impl<IPropertySource>(){

                    public void run() {
                        this.setResult(new PropertySource(object, itemPropertySource){

                            protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                                return new PropertyDescriptor(this.object, itemPropertyDescriptor){

                                    public CellEditor createPropertyEditor(Composite composite) {
                                        CellEditor editor = InstanceRefPropertySourceAbstractProvider.this.createPropertyEditor(composite, this.object, this.itemPropertyDescriptor, this);
                                        if (editor != null) {
                                            return editor;
                                        }
                                        return super.createPropertyEditor(composite);
                                    }
                                };
                            }
                        });
                    }
                }));
            }
        };
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    protected CellEditor createPropertyEditor(Composite composite, Object object, IItemPropertyDescriptor itemPropertyDescriptor, PropertyDescriptor propertyDescriptor) {
        if (object instanceof EObject) {
            return this.createInstanceRefPropertyEditor(composite, object, itemPropertyDescriptor, propertyDescriptor);
        }
        return null;
    }

    protected abstract CellEditor createInstanceRefPropertyEditor(Composite var1, Object var2, IItemPropertyDescriptor var3, PropertyDescriptor var4);
}

