/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.Comparator;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.ObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheObject {
    public CacheObject previous;
    public CacheObject next;
    public CacheObject chained;
    public int cacheQueue;
    protected int blockCount;
    private int pos;
    private boolean changed;

    public abstract boolean canRemove();

    public static void sort(ObjectArray<CacheObject> objectArray) {
        objectArray.sort(new CacheComparator());
    }

    public void setBlockCount(int n) {
        this.blockCount = n;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setPos(int n) {
        if (SysProperties.CHECK && (this.previous != null || this.next != null || this.chained != null)) {
            Message.throwInternalError("setPos too late");
        }
        this.pos = n;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isPinned() {
        return false;
    }

    public int getMemorySize() {
        return this.blockCount * 32;
    }

    static {
        new CacheComparator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheComparator
    implements Comparator<CacheObject> {
        CacheComparator() {
        }

        @Override
        public int compare(CacheObject cacheObject, CacheObject cacheObject2) {
            int n;
            int n2 = cacheObject.getPos();
            return n2 == (n = cacheObject2.getPos()) ? 0 : (n2 < n ? -1 : 1);
        }
    }
}

