/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.discovery;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.osgi.services.discovery.Activator;
import org.eclipse.ecf.internal.osgi.services.discovery.DiscoveredServiceNotificationImpl;
import org.eclipse.ecf.internal.osgi.services.discovery.LogUtility;
import org.eclipse.ecf.internal.osgi.services.discovery.ServicePropertyUtils;
import org.eclipse.ecf.osgi.services.discovery.IHostDiscoveryListener;
import org.eclipse.ecf.osgi.services.discovery.IProxyDiscoveryListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.discovery.DiscoveredServiceNotification;
import org.osgi.service.discovery.DiscoveredServiceTracker;
import org.osgi.service.discovery.Discovery;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServicePublicationHandler
implements ServiceTrackerCustomizer,
Discovery,
IServiceListener {
    private IDiscoveryAdvertiser advertiser;
    private Map serviceInfos = Collections.synchronizedMap(new HashMap());

    public void serviceDiscovered(IServiceEvent event) {
        IServiceInfo serviceInfo = event.getServiceInfo();
        IServiceID serviceID = serviceInfo.getServiceID();
        this.trace("handleOSGIServiceDiscovered", " serviceInfo=" + serviceInfo);
        if (this.matchServiceID(serviceID)) {
            this.fireProxyDiscoveredUndiscovered(serviceInfo, true);
            this.trace("handleOSGIServiceDiscovered matched", " serviceInfo=" + serviceInfo);
            DiscoveredServiceTracker[] discoveredTrackers = this.findMatchingDiscoveredServiceTrackers(serviceInfo);
            this.notifyDiscoveredServiceTrackers(discoveredTrackers, serviceInfo, true);
        }
    }

    public void serviceUndiscovered(IServiceEvent event) {
        IServiceInfo serviceInfo = event.getServiceInfo();
        IServiceID serviceID = serviceInfo.getServiceID();
        if (this.matchServiceID(serviceID)) {
            this.fireProxyDiscoveredUndiscovered(serviceInfo, false);
            this.trace("handleOSGIServiceUndiscovered", " serviceInfo=" + serviceInfo);
            DiscoveredServiceTracker[] discoveredTrackers = this.findMatchingDiscoveredServiceTrackers(serviceInfo);
            this.notifyDiscoveredServiceTrackers(discoveredTrackers, serviceInfo, false);
        }
    }

    private void notifyDiscoveredServiceTrackers(DiscoveredServiceTracker[] discoveredTrackers, IServiceInfo serviceInfo, boolean available) {
        if (discoveredTrackers != null) {
            int i = 0;
            while (i < discoveredTrackers.length) {
                discoveredTrackers[i].serviceChanged((DiscoveredServiceNotification)new DiscoveredServiceNotificationImpl(available ? 1 : 4, serviceInfo));
                ++i;
            }
        }
    }

    private DiscoveredServiceTracker[] findMatchingDiscoveredServiceTrackers(IServiceInfo serviceInfo) {
        ServiceReference[] sourceTrackers = Activator.getDefault().getDiscoveredServiceTrackerReferences();
        if (sourceTrackers == null) {
            return null;
        }
        ArrayList<Object> matchingTrackers = new ArrayList<Object>();
        int i = 0;
        while (i < sourceTrackers.length) {
            if (this.matchWithDiscoveredServiceInfo(sourceTrackers[i], serviceInfo)) {
                matchingTrackers.add(Activator.getDefault().getContext().getService(sourceTrackers[i]));
            }
            ++i;
        }
        return matchingTrackers.toArray(new DiscoveredServiceTracker[0]);
    }

    private boolean matchWithDiscoveredServiceInfo(ServiceReference serviceReference, IServiceInfo serviceInfo) {
        return true;
    }

    private boolean matchServiceID(IServiceID serviceId) {
        return Arrays.asList(serviceId.getServiceTypeID().getServices()).contains("osgiservices");
    }

    private IServiceInfo addServiceInfo(ServiceReference sr, IServiceInfo si) {
        return this.serviceInfos.put(sr, si);
    }

    private IServiceInfo removeServiceInfo(ServiceReference sr) {
        return (IServiceInfo)this.serviceInfos.remove(sr);
    }

    public Object addingService(ServiceReference reference) {
        this.handleServicePublication(reference);
        return Activator.getDefault().getContext().getService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServicePublication(ServiceReference reference) {
        IDiscoveryAdvertiser advertiser2;
        byte[] remoteServiceIDAsBytes;
        String rsnamespace;
        ID endpointContainerID;
        Collection svcInterfaces = ServicePropertyUtils.getCollectionProperty(reference, "osgi.remote.service.interfaces");
        if (svcInterfaces == null) {
            this.logError("handleServicePublication", "ignoring " + reference + ". ServicePublication.SERVICE_INTERFACE_NAME not set", null);
            return;
        }
        ServiceProperties discoveryServiceProperties = new ServiceProperties();
        discoveryServiceProperties.setPropertyString("osgi.remote.service.interfaces", ServicePropertyUtils.createStringFromCollection(svcInterfaces));
        Map servicePublicationServiceProperties = ServicePropertyUtils.getMapProperty(reference, "osgi.remote.discovery.publication.service.properties");
        if (servicePublicationServiceProperties != null) {
            this.addPropertiesToDiscoveryServiceProperties((IServiceProperties)discoveryServiceProperties, servicePublicationServiceProperties);
        }
        if ((endpointContainerID = (ID)reference.getProperty("ecf.sp.cid")) == null) {
            this.logError("handleServicePublication", "ignoring " + reference + ". RemoteServicePublication.ENDPOINT_CONTAINERID not set", null);
            return;
        }
        discoveryServiceProperties.setPropertyBytes("ecf.sp.cid", endpointContainerID.toExternalForm().getBytes());
        String endpointNamespace = endpointContainerID.getNamespace().getName();
        discoveryServiceProperties.setPropertyString("ecf.sp.cns", endpointNamespace);
        ID targetContainerID = (ID)reference.getProperty("ecf.sp.tid");
        if (targetContainerID != null) {
            discoveryServiceProperties.setPropertyBytes("ecf.sp.tid", targetContainerID.toExternalForm().getBytes());
            String targetNamespace = targetContainerID.getNamespace().getName();
            discoveryServiceProperties.setPropertyString("ecf.sp.tns", targetNamespace);
        }
        if ((rsnamespace = ServicePropertyUtils.getStringProperty(reference, "ecf.rsvc.ns")) != null) {
            discoveryServiceProperties.setPropertyString("ecf.rsvc.ns", rsnamespace);
        }
        if ((remoteServiceIDAsBytes = (byte[])reference.getProperty("ecf.rsvc.id")) != null) {
            discoveryServiceProperties.setPropertyBytes("ecf.rsvc.id", remoteServiceIDAsBytes);
        }
        if ((advertiser2 = this.getAdvertiser()) == null) {
            this.logInfo("handleServicePublication", "ignoring " + reference + ". No IDiscoveryAdvertiser available to handle this publication", null);
            return;
        }
        Namespace advertiserNamespace = advertiser2.getServicesNamespace();
        ServiceInfo svcInfo = null;
        try {
            IServiceTypeID serviceTypeID = this.createServiceTypeID(servicePublicationServiceProperties, advertiserNamespace);
            URI uri = this.createURI(endpointContainerID);
            String serviceName = this.getPropertyWithDefault(servicePublicationServiceProperties, "ecf.sp.svcname", "service " + new String(remoteServiceIDAsBytes));
            svcInfo = new ServiceInfo(uri, serviceName, serviceTypeID, (IServiceProperties)discoveryServiceProperties);
        }
        catch (IDCreateException e) {
            this.logError("handleServicePublication", "Exception creating serviceID", e);
            return;
        }
        catch (URISyntaxException e) {
            this.logError("handleServicePublication", "Exception creating URI", e);
            return;
        }
        this.fireHostPublishUnpublish(reference, (IServiceInfo)svcInfo, true);
        Map map = this.serviceInfos;
        synchronized (map) {
            try {
                this.trace("publishService", "publishing serviceReference=" + reference + ", svcInfo=" + svcInfo);
                advertiser2.registerService((IServiceInfo)svcInfo);
                this.addServiceInfo(reference, (IServiceInfo)svcInfo);
            }
            catch (ECFRuntimeException e) {
                this.logError("publishService", "cannot register service", e);
            }
        }
    }

    private void fireHostPublishUnpublish(final ServiceReference reference, final IServiceInfo serviceInfo, final boolean publish) {
        IHostDiscoveryListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getHostPublicationListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IHostDiscoveryListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        ServicePublicationHandler.this.logError("fireHostPublishUnpublish", "Exception calling host discovery listener", exception);
                    }

                    public void run() throws Exception {
                        if (publish) {
                            l.publish(reference, serviceInfo);
                        } else {
                            l.unpublish(reference, serviceInfo);
                        }
                    }
                });
                ++i;
            }
        }
    }

    private void fireProxyDiscoveredUndiscovered(final IServiceInfo serviceInfo, final boolean discovered) {
        IProxyDiscoveryListener[] listeners;
        Activator activator = Activator.getDefault();
        if (activator != null && (listeners = activator.getProxyDiscoveredListeners()) != null) {
            int i = 0;
            while (i < listeners.length) {
                final IProxyDiscoveryListener l = listeners[i];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        ServicePublicationHandler.this.logError("fireProxyDiscoveredUndiscovered", "Exception calling proxy discovery listener", exception);
                    }

                    public void run() throws Exception {
                        if (discovered) {
                            l.discovered(serviceInfo);
                        } else {
                            l.undiscovered(serviceInfo);
                        }
                    }
                });
                ++i;
            }
        }
    }

    private void logError(String method, String message, Throwable exception) {
        LogUtility.logError(method, message, this.getClass(), exception);
    }

    private void logInfo(String method, String message, Throwable exception) {
        LogUtility.logInfo(method, message, this.getClass(), exception);
    }

    private URI createURI(ID endpointContainerID) throws URISyntaxException {
        boolean done = false;
        URI uri = null;
        String str = endpointContainerID.getName();
        while (!done) {
            try {
                uri = new URI(str);
                if (!uri.isOpaque()) {
                    done = true;
                    continue;
                }
                str = uri.getRawSchemeSpecificPart();
            }
            catch (URISyntaxException uRISyntaxException) {
                done = true;
            }
        }
        String scheme = "osgiservices";
        int port = 32565;
        if (uri != null && (port = uri.getPort()) == -1) {
            port = 32565;
        }
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            host = "localhost";
        }
        return new URI(scheme, null, host, port, null, null, null);
    }

    private void addPropertiesToDiscoveryServiceProperties(IServiceProperties discoveryServiceProperties, Map servicePublicationServiceProperties) {
        Iterator i = servicePublicationServiceProperties.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (!(key instanceof String)) {
                this.trace("addPropertiesToDiscoveryServiceProperties", "skipping non-string key " + key);
                continue;
            }
            String keyStr = (String)key;
            Object val = servicePublicationServiceProperties.get(keyStr);
            if (val instanceof String) {
                discoveryServiceProperties.setPropertyString(keyStr, (String)val);
                continue;
            }
            if (val instanceof byte[]) {
                discoveryServiceProperties.setPropertyBytes(keyStr, (byte[])val);
                continue;
            }
            if (!(val instanceof Serializable)) continue;
            discoveryServiceProperties.setProperty(keyStr, val);
        }
    }

    private synchronized IDiscoveryAdvertiser getAdvertiser() {
        try {
            if (this.advertiser == null) {
                this.advertiser = Activator.getDefault().getAdvertiser();
            }
        }
        catch (InterruptedException e) {
            this.logError("getAdvertiser", "Cannot get IDiscoveryAdvertiser", e);
        }
        return this.advertiser;
    }

    private String getPropertyWithDefault(Map properties, String key, String def) {
        if (properties == null) {
            return def;
        }
        String val = (String)properties.get(key);
        return val == null ? def : val;
    }

    protected IServiceTypeID createServiceTypeID(Map servicePublicationProperties, Namespace aNamespace) throws IDCreateException {
        String namingAuthority = this.getPropertyWithDefault(servicePublicationProperties, "ecf.sp.namingauth", "iana");
        String scope = this.getPropertyWithDefault(servicePublicationProperties, "ecf.sp.scope", IServiceTypeID.DEFAULT_SCOPE[0]);
        String protocol = this.getPropertyWithDefault(servicePublicationProperties, "ecf.sp.protocol", IServiceTypeID.DEFAULT_PROTO[0]);
        return ServiceIDFactory.getDefault().createServiceTypeID(aNamespace, new String[]{"osgiservices"}, new String[]{scope}, new String[]{protocol}, namingAuthority);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.unpublishService(reference);
        this.handleServicePublication(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.unpublishService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpublishService(ServiceReference reference) {
        IServiceInfo svcInfo = null;
        Map map = this.serviceInfos;
        synchronized (map) {
            try {
                svcInfo = this.removeServiceInfo(reference);
                if (svcInfo != null) {
                    this.getAdvertiser().unregisterService(svcInfo);
                }
            }
            catch (ECFRuntimeException e) {
                this.logError("publishService", "Cannot unregister serviceInfo=" + svcInfo, e);
            }
        }
        if (svcInfo != null) {
            this.fireHostPublishUnpublish(reference, svcInfo, false);
        }
    }

    protected void trace(String methodName, String message) {
        Trace.trace((String)"org.eclipse.ecf.osgi.services.discovery", (String)"org.eclipse.ecf.osgi.services.discovery/debug/servicepublication", this.getClass(), (String)methodName, (String)message);
    }

    public void dispose() {
        if (this.advertiser != null) {
            Iterator i = this.serviceInfos.keySet().iterator();
            while (i.hasNext()) {
                ServiceReference sr = (ServiceReference)i.next();
                this.unpublishService(sr);
            }
            this.serviceInfos.clear();
            this.advertiser = null;
        }
    }
}

