/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.osgi.services.discovery.Activator;
import org.eclipse.ecf.internal.osgi.services.discovery.ServicePropertyUtils;
import org.eclipse.ecf.osgi.services.discovery.IRemoteServiceEndpointDescription;

public abstract class RemoteServiceEndpointDescription
implements IRemoteServiceEndpointDescription {
    protected Map serviceProperties;

    public RemoteServiceEndpointDescription(Map properties) {
        this.serviceProperties = properties;
    }

    public String getEndpointID() {
        Object o = this.serviceProperties.get("osgi.remote.endpoint.id");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String getEndpointInterfaceName(String interfaceName) {
        if (interfaceName == null) {
            return null;
        }
        Object o = this.serviceProperties.get("osgi.remote.endpoint.interfaces");
        if (o == null || !(o instanceof String)) {
            return null;
        }
        String intfNames = (String)o;
        Collection c = ServicePropertyUtils.createCollectionFromString(intfNames);
        if (c == null) {
            return null;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String intfName = (String)i.next();
            if (intfName == null || !intfName.startsWith(interfaceName)) continue;
            return intfName.substring(intfName.length() + ":".length()).trim();
        }
        return null;
    }

    public URI getLocation() {
        Object o = this.serviceProperties.get("osgi.remote.endpoint.location");
        if (o == null || !(o instanceof String)) {
            return null;
        }
        String uriExternalForm = (String)o;
        URI uri = null;
        try {
            uri = new URI(uriExternalForm);
        }
        catch (URISyntaxException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.osgi.services.discovery", 4, "Exception getting location URI", (Throwable)e));
        }
        return uri;
    }

    public Map getProperties() {
        return this.serviceProperties;
    }

    public Object getProperty(String key) {
        return this.serviceProperties.get(key);
    }

    public Collection getPropertyKeys() {
        return this.serviceProperties.keySet();
    }

    public Collection getProvidedInterfaces() {
        Object o = this.serviceProperties.get("osgi.remote.service.interfaces");
        if (o == null || !(o instanceof String)) {
            throw new NullPointerException();
        }
        String providedInterfacesStr = (String)o;
        return ServicePropertyUtils.createCollectionFromString(providedInterfacesStr);
    }

    public String getVersion(String interfaceName) {
        Collection c = this.getProvidedInterfaces();
        if (c == null) {
            return null;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            String intfName = (String)i.next();
            if (intfName == null || !intfName.startsWith(interfaceName)) continue;
            return intfName.substring(intfName.length() + "|".length()).trim();
        }
        return null;
    }

    public long getRemoteServiceId() {
        byte[] remoteServiceIdAsBytes = (byte[])this.serviceProperties.get("ecf.rsvc.id");
        if (remoteServiceIdAsBytes == null) {
            return 0L;
        }
        Long remoteServiceId = new Long(new String(remoteServiceIdAsBytes));
        return remoteServiceId;
    }

    public abstract ID getEndpointAsID();

    public abstract ID getConnectTargetID();

    public abstract IServiceID getServiceID();

    public String getRemoteServicesFilter() {
        Object o = this.serviceProperties.get("ecf.client.filter");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public void setProperties(Map props) {
        if (props != null) {
            this.serviceProperties = props;
        }
    }
}

