/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.jms.connectionfactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.ebpm.core.SpagicNode;
import org.eclipse.ebpm.jms.connectionfactory.ConnectionFactory;
import org.eclipse.ebpm.jms.connectionfactory.IConnectionFactoryManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactoryManager
implements IConnectionFactoryManager {
    private EventAdmin ea = null;
    private static Logger logger = LoggerFactory.getLogger(ConnectionFactoryManager.class);
    private ConcurrentHashMap<String, ServiceReference> connectionFactories = new ConcurrentHashMap();
    private ComponentContext componentContext = null;
    private List<String> interestToNotification = new ArrayList<String>();
    private ConcurrentLinkedQueue<Event> waitingEvents = new ConcurrentLinkedQueue();

    protected void activate(ComponentContext componentContext) {
        logger.info(" ConnectionFactoryManager - ACTIVATED");
        this.componentContext = componentContext;
        logger.info("Sending " + this.waitingEvents.size() + " stored events");
        Event storedEvent = null;
        while ((storedEvent = this.waitingEvents.poll()) != null) {
            logger.info("Sending event to topic:" + storedEvent.getTopic());
            this.ea.postEvent(storedEvent);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info(" ConnectionFactoryManager - DEACTIVATED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerForNotification(String id) {
        ConnectionFactoryManager connectionFactoryManager = this;
        synchronized (connectionFactoryManager) {
            this.interestToNotification.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterForNotification(String id) {
        ConnectionFactoryManager connectionFactoryManager = this;
        synchronized (connectionFactoryManager) {
            this.interestToNotification.remove(id);
        }
    }

    public void addConnectionFactory(ServiceReference ConnectionFactoryServiceReference) {
        String cfIdentifier = (String)ConnectionFactoryServiceReference.getProperty("id");
        logger.info(" ConnectionFactory [" + cfIdentifier + "] -- REGISTERED");
        this.connectionFactories.put(cfIdentifier, ConnectionFactoryServiceReference);
        this.notify(cfIdentifier, "_INTERNAL_EVENT_CF_DEPLOYED");
        this.notifyInterested(cfIdentifier, "_INTERNAL_EVENT_CF_DEPLOYED");
    }

    public void removeConnectionFactory(ServiceReference ConnectionFactoryServiceReference) {
        String dsIdentifier = (String)ConnectionFactoryServiceReference.getProperty("id");
        logger.info(" ConnectionFactory [" + dsIdentifier + "] -- UNREGISTERED");
        this.connectionFactories.remove(dsIdentifier);
        this.notify(dsIdentifier, "_INTERNAL_EVENT_CF_UNDEPLOYED");
        this.notifyInterested(dsIdentifier, "_INTERNAL_EVENT_CF_UNDEPLOYED");
    }

    @Override
    public ConnectionFactory getConnectionFactory(String ConnectionFactoryIdentifier) throws Exception {
        ServiceReference sr = this.connectionFactories.get(ConnectionFactoryIdentifier);
        if (sr == null) {
            logger.error("ConnectionFactoryManager -> No ConnectionFactory registered with id [" + ConnectionFactoryIdentifier + "]");
            throw new Exception("ConnectionFactoryManager -> No ConnectionFactory registered with id [" + ConnectionFactoryIdentifier + "]");
        }
        ConnectionFactory cf = (ConnectionFactory)this.componentContext.locateService("connectionfactories", sr);
        return cf;
    }

    public void bind(EventAdmin ea) {
        logger.info("Binded EventAdmin");
        this.ea = ea;
    }

    public void unbind(EventAdmin ea) {
        this.ea = null;
    }

    public void notify(String id, String eventType) {
        logger.info("Notifying connection factory availability: " + id);
        HashMap<String, Object> internalEventProperties = new HashMap<String, Object>();
        internalEventProperties.put("_IS_INTERNAL_EVENT", true);
        internalEventProperties.put("_INTERNAL_EVENT_TYPE", eventType);
        internalEventProperties.put("_INTERNAL_EVENT_REFERRING_ID", id);
        Event ev = new Event("SPAGIC/MESSAGES", internalEventProperties);
        if (this.ea != null) {
            this.ea.postEvent(ev);
        } else {
            logger.info("EventAdmin not available: unable to send message");
            this.waitingEvents.add(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyInterested(String id, String eventType) {
        logger.info("Notifying connection factory availability [" + id + "] to interested parties " + this.interestToNotification);
        ConnectionFactoryManager connectionFactoryManager = this;
        synchronized (connectionFactoryManager) {
            for (String interested : this.interestToNotification) {
                HashMap<String, Object> internalEventProperties = new HashMap<String, Object>();
                internalEventProperties.put("_IS_INTERNAL_EVENT", true);
                internalEventProperties.put("_INTERNAL_EVENT_TYPE", eventType);
                internalEventProperties.put("_INTERNAL_EVENT_REFERRING_ID", id);
                Event ev = new Event(SpagicNode.topicForService((String)interested), internalEventProperties);
                if (this.ea != null) {
                    this.ea.postEvent(ev);
                    continue;
                }
                logger.info("EventAdmin not available: unable to send message");
                this.waitingEvents.add(ev);
            }
        }
    }

    @Override
    public Set<String> getRegisteredConnectionFactoriesIDs() {
        return this.connectionFactories.keySet();
    }
}

