/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.ebpm.soap.api.Interceptor;
import org.eclipse.ebpm.soap.api.InterceptorChain;
import org.eclipse.ebpm.soap.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseInterceptorChain
implements InterceptorChain {
    private static final Logger LOG = LoggerFactory.getLogger(PhaseInterceptorChain.class);
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();

    @Override
    public void add(Iterable<? extends Interceptor> newhandlers) {
        if (newhandlers == null) {
            return;
        }
        for (Interceptor interceptor : newhandlers) {
            this.add(interceptor);
        }
    }

    @Override
    public Iterable<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void add(Interceptor i) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding interceptor " + i.getId());
        }
        this.insertInterceptor(i);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doIntercept(Message message) {
        block8: {
            iterator = this.getState(message);
            if (iterator == null) {
                iterator = this.interceptors.listIterator();
                this.setState(message, iterator);
            }
            try {
                while (iterator.hasNext()) {
                    currentInterceptor = iterator.next();
                    if (PhaseInterceptorChain.LOG.isDebugEnabled()) {
                        PhaseInterceptorChain.LOG.debug("Invoking handleMessage on interceptor " + currentInterceptor.getId());
                    }
                    currentInterceptor.handleMessage(message);
                }
                break block8;
            }
            catch (RuntimeException ex) {
                if (PhaseInterceptorChain.LOG.isInfoEnabled()) {
                    PhaseInterceptorChain.LOG.info("Interceptor has thrown exception, unwinding now", (Throwable)ex);
                }
                message.setContent(Exception.class, ex);
                ** while (iterator.hasPrevious())
            }
lbl-1000:
            // 1 sources

            {
                currentInterceptor = iterator.previous();
                if (PhaseInterceptorChain.LOG.isDebugEnabled()) {
                    PhaseInterceptorChain.LOG.debug("Invoking handleFault on interceptor " + currentInterceptor.getId());
                }
                currentInterceptor.handleFault(message);
                continue;
            }
lbl23:
            // 1 sources

            throw ex;
        }
    }

    protected ListIterator<Interceptor> getState(Message message) {
        Object state = message.get(this.toString());
        return (ListIterator)state;
    }

    protected void setState(Message message, ListIterator<Interceptor> state) {
        message.put(this.toString(), state);
        message.put(InterceptorChain.class, this);
    }

    protected void insertInterceptor(Interceptor interc) {
        if (this.interceptors.size() == 0) {
            this.interceptors.add(interc);
            return;
        }
        int begin = -1;
        int end = this.interceptors.size();
        Set<String> before = interc.getBefore();
        Set<String> after = interc.getAfter();
        int i = 0;
        while (i < this.interceptors.size()) {
            Interceptor cmp = this.interceptors.get(i);
            if (cmp.getId() != null) {
                if (before.contains(cmp.getId()) && i < end) {
                    end = i;
                }
                if (cmp.getBefore().contains(interc.getId()) && i > begin) {
                    begin = i;
                }
                if (after.contains(cmp.getId()) && i > begin) {
                    begin = i;
                }
                if (cmp.getAfter().contains(interc.getId()) && i < end) {
                    end = i;
                }
            }
            ++i;
        }
        if (end < begin + 1) {
            throw new IllegalStateException("Invalid ordering for interceptor " + interc.getId());
        }
        this.interceptors.add(end, interc);
    }
}

