/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.xml;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.stax.DOMStreamReader;
import org.eclipse.ebpm.soap.util.stax.ExtendedXMLStreamReader;
import org.eclipse.ebpm.soap.util.stax.StaxUtil;
import org.w3c.dom.Document;

public class StaxInInterceptor
extends AbstractInterceptor {
    public static final String ENCODING = "Encoding";

    @Override
    public void handleMessage(Message message) {
        try {
            XMLStreamReader reader;
            Document doc = message.getContent(Document.class);
            if (doc != null) {
                reader = new DOMStreamReader(doc.getDocumentElement());
            } else {
                InputStream is = message.getContent(InputStream.class);
                if (is != null) {
                    String encoding = (String)message.get(ENCODING);
                    reader = StaxUtil.createReader(is, encoding);
                    reader = new ExtendedXMLStreamReader(reader);
                } else {
                    return;
                }
            }
            reader.nextTag();
            message.setContent(XMLStreamReader.class, reader);
        }
        catch (XMLStreamException e) {
            if (message.get("sendFaultsToTarget") != null && ((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)e)) + "</ERROR>");
                exchange.setOut(out);
                message.setContent(Exchange.class, exchange);
                return;
            }
            throw new Fault(e);
        }
    }
}

