/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.eclipse.ebpm.soap.api.Fault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomUtil {
    private static DocumentBuilderFactory documentBuilderFactory;
    private static TransformerFactory transformerFactory;

    public static Document createDocument() {
        try {
            return DomUtil.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new Fault(e);
        }
    }

    public static Document parse(InputStream is) {
        try {
            return DomUtil.getDocumentBuilderFactory().newDocumentBuilder().parse(is);
        }
        catch (SAXException e) {
            throw new Fault(e);
        }
        catch (IOException e) {
            throw new Fault(e);
        }
        catch (ParserConfigurationException e) {
            throw new Fault(e);
        }
    }

    public static Document parse(Source source) {
        try {
            Document doc = DomUtil.createDocument();
            DOMResult result = new DOMResult(doc);
            Transformer transformer = DomUtil.getTransformerFactory().newTransformer();
            transformer.transform(source, result);
            return doc;
        }
        catch (TransformerConfigurationException e) {
            throw new Fault(e);
        }
        catch (TransformerException e) {
            throw new Fault(e);
        }
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory == null) {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            documentBuilderFactory = f;
        }
        return documentBuilderFactory;
    }

    public static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    public static Element getFirstChildElement(Node parent) {
        NodeList childs = parent.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child instanceof Element) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    public static String getElementText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                buffer.append(node.getNodeValue());
            }
            ++i;
        }
        return buffer.toString();
    }

    public static Element getNextSiblingElement(Element el) {
        Node n = el.getNextSibling();
        while (n != null) {
            if (n instanceof Element) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public static Element createElement(Node parent, QName name) {
        Element element;
        Document doc;
        Document document = doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        if (name.getPrefix() != null && name.getPrefix().length() > 0) {
            element = doc.createElementNS(name.getNamespaceURI(), String.valueOf(name.getPrefix()) + ":" + name.getLocalPart());
            String attr = DomUtil.recursiveGetAttributeValue(parent, "xmlns:" + name.getPrefix());
            if (attr == null || !attr.equals(name.getNamespaceURI())) {
                element.setAttribute("xmlns:" + name.getPrefix(), name.getNamespaceURI());
            }
        } else if (name.getNamespaceURI() != null && name.getNamespaceURI().length() > 0) {
            element = doc.createElementNS(name.getNamespaceURI(), name.getLocalPart());
            String attr = DomUtil.recursiveGetAttributeValue(parent, "xmlns");
            if (attr == null || !attr.equals(name.getNamespaceURI())) {
                element.setAttribute("xmlns", name.getNamespaceURI());
            }
        } else {
            element = doc.createElementNS(null, name.getLocalPart());
            String attr = DomUtil.recursiveGetAttributeValue(parent, "xmlns");
            if (attr == null || attr.length() > 0) {
                element.setAttribute("xmlns", "");
            }
        }
        parent.appendChild(element);
        return element;
    }

    public static QName createQName(Element element, String qualifiedName) {
        int index = qualifiedName.indexOf(58);
        if (index >= 0) {
            String prefix = qualifiedName.substring(0, index);
            String localName = qualifiedName.substring(index + 1);
            String uri = DomUtil.recursiveGetAttributeValue(element, "xmlns:" + prefix);
            return new QName(uri, localName, prefix);
        }
        String uri = DomUtil.recursiveGetAttributeValue(element, "xmlns");
        if (uri != null) {
            return new QName(uri, qualifiedName);
        }
        return new QName(qualifiedName);
    }

    public static String recursiveGetAttributeValue(Node parent, String attributeName) {
        if (parent instanceof Element) {
            Node parentNode;
            Element element = (Element)parent;
            String answer = element.getAttribute(attributeName);
            if ((answer == null || answer.length() == 0) && (parentNode = element.getParentNode()) instanceof Element) {
                return DomUtil.recursiveGetAttributeValue((Element)parentNode, attributeName);
            }
            return answer;
        }
        return null;
    }

    protected static String getUniquePrefix(Element element) {
        int n = 1;
        String nsPrefix;
        while (DomUtil.recursiveGetAttributeValue(element, "xmlns:" + (nsPrefix = "ns" + n)) != null) {
            ++n;
        }
        return nsPrefix;
    }

    public static QName getQName(Element el) {
        if (el == null) {
            return null;
        }
        if (el.getPrefix() != null) {
            return new QName(el.getNamespaceURI(), el.getLocalName(), el.getPrefix());
        }
        return new QName(el.getNamespaceURI(), el.getLocalName());
    }
}

