/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.ecf.internal.remoteservice.Activator;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RemoteFilterImpl
implements IRemoteFilter {
    Filter filter;

    public RemoteFilterImpl(String createFilter) throws InvalidSyntaxException {
        if (createFilter == null) {
            throw new InvalidSyntaxException("createFilter cannot be null", createFilter);
        }
        this.filter = Activator.getDefault().getContext().createFilter(createFilter);
    }

    public RemoteFilterImpl(Filter filter) {
        this.filter = filter;
    }

    public static String getObjectClassFilterString(String objectClass) {
        if (objectClass == null) {
            return null;
        }
        return "(ecf.robjectClass=" + objectClass + ")";
    }

    public boolean match(IRemoteServiceReference reference) {
        if (reference == null) {
            return false;
        }
        String[] propertyKeys = reference.getPropertyKeys();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        int i = 0;
        while (i < propertyKeys.length) {
            props.put(propertyKeys[i], reference.getProperty(propertyKeys[i]));
            ++i;
        }
        return this.match(props);
    }

    public boolean match(Dictionary dictionary) {
        return this.filter.match(dictionary);
    }

    public boolean matchCase(Dictionary dictionary) {
        return this.filter.matchCase(dictionary);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RemoteFilterImpl)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.filter.toString();
    }

    public boolean match(ServiceReference reference) {
        return this.filter.match(reference);
    }
}

