/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.ecf.internal.ssl.ECFTrustManager;

public class ECFSSLSocketFactory
extends SSLSocketFactory {
    public static final String DEFAULT_SSL_PROTOCOL = "https.protocols";
    private SSLContext sslContext = null;
    private String defaultProtocolNames = System.getProperty("https.protocols");

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        if (this.sslContext == null) {
            try {
                this.sslContext = this.getSSLContext(this.defaultProtocolNames);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.sslContext == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslContext.getSocketFactory();
    }

    public SSLContext getSSLContext(String protocols) {
        SSLContext rtvContext = null;
        if (protocols != null) {
            String[] protocolNames = protocols.split(",");
            int i = 0;
            while (i < protocolNames.length) {
                try {
                    rtvContext = SSLContext.getInstance(protocolNames[i]);
                    rtvContext.init(null, new TrustManager[]{new ECFTrustManager()}, new SecureRandom());
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
        }
        return rtvContext;
    }

    public Socket createSocket() throws IOException {
        return this.getSSLSocketFactory().createSocket();
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.getSSLSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        try {
            return this.getSSLSocketFactory().getDefaultCipherSuites();
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    public String[] getSupportedCipherSuites() {
        try {
            return this.getSSLSocketFactory().getSupportedCipherSuites();
        }
        catch (IOException iOException) {
            return new String[0];
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.getSSLSocketFactory().createSocket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress arg2, int arg3) throws IOException {
        return this.getSSLSocketFactory().createSocket(address, port);
    }

    public Socket createSocket(String host, int port, InetAddress address, int localPort) throws IOException, UnknownHostException {
        return this.getSSLSocketFactory().createSocket(host, port, address, localPort);
    }
}

