/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.ftp.marshaler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.eclipse.ebpm.connectors.ftp.marshaler.FileMarshaler;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;

public class BinaryFileMarshaler
implements FileMarshaler {
    @Override
    public String getMarshalerId() {
        return "BINARY";
    }

    @Override
    public List<String> getOutputNames(Exchange exchange, Message message) {
        Map attachments = message.getAttachments();
        return Arrays.asList(attachments.keySet().toArray(new String[0]));
    }

    @Override
    public void writeMessage(Exchange exchange, Message message, String outputName, OutputStream out, String path) throws IOException {
        DataHandler handler = (DataHandler)message.getAttachment(outputName);
        if (handler == null) {
            throw new IOException("Could not find attachment: " + outputName);
        }
        InputStream is = handler.getInputStream();
        BinaryFileMarshaler.copyInputStream(is, out);
    }

    @Override
    public void readMessage(Exchange exchange, Message message, InputStream in, String path) throws IOException {
        int len;
        File polledFile = new File(path);
        File tempFile = File.createTempFile("spagic-attachment", ".tmp");
        FileOutputStream out = new FileOutputStream(tempFile);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
        DataHandler handler = new DataHandler((DataSource)new FileDataSource(tempFile));
        message.addAttachment(polledFile.getName(), (Object)handler);
        message.setHeader("org.spagic3.file.name", (Object)polledFile.getName());
        message.setHeader("org.spagic3.file.path", (Object)path);
        message.setBody("<FILE>" + polledFile.getName() + "</FILE>");
    }

    protected static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }
}

