/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.releng.p2.to.maven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.scada.releng.p2.to.maven.License;

public class LicenseProvider {
    private final Properties properties;
    private final Map<String, License> licenses = new HashMap<String, License>();

    public LicenseProvider(Properties properties) {
        this.properties = properties;
        this.licenses.put("epl", License.EPL);
    }

    public List<License> getLicenses(IInstallableUnit iu) {
        String id = this.properties.getProperty("license.for." + iu.getId());
        if (id == null || id.isEmpty()) {
            return null;
        }
        String[] ids = id.split(",");
        if (ids.length == 0) {
            return null;
        }
        ArrayList<License> result = new ArrayList<License>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String lid = stringArray[n2];
            License lic = this.licenses.get(lid);
            if (lic != null) {
                result.add(lic);
            } else {
                result.add(this.parseLicense(lid));
            }
            ++n2;
        }
        return result;
    }

    private License parseLicense(String id) {
        String name = this.properties.getProperty("license.info." + id + ".name");
        String url = this.properties.getProperty("license.info." + id + ".url");
        if (name == null || url == null) {
            throw new IllegalStateException("Missing or invalid license information for: " + id);
        }
        if (name.isEmpty() || url.isEmpty()) {
            throw new IllegalStateException("Missing or invalid license information for: " + id);
        }
        return new License(name, url);
    }
}

