/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.example.wizards;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.wizard.AbstractExampleInstallerWizard;
import org.eclipse.emf.common.ui.wizard.ExampleInstallerWizard;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emfforms.internal.example.wizards.ExampleWizardsPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EMFFormsExampleInstallerWizard
extends ExampleInstallerWizard {
    private ExampleInstallerPage projectPage;

    public void addPages() {
        this.projectPage = new ExampleInstallerPage(this, "projectPage", this.getProjectPageTitle(), null);
        this.projectPage.setDescription(this.getProjectPageDescription());
        this.addPage((IWizardPage)this.projectPage);
    }

    public void dispose() {
        this.projectPage = null;
        super.dispose();
    }

    protected String getProjectPageTitle() {
        return ExampleWizardsPlugin.INSTANCE.getString("_UI_ProjectPage_title");
    }

    protected String getProjectPageDescription() {
        return ExampleWizardsPlugin.INSTANCE.getString("_UI_ProjectPage_description");
    }

    protected Diagnostic deleteExistingProjects(IProgressMonitor monitor) {
        return Diagnostic.OK_INSTANCE;
    }

    protected void installExample(IProgressMonitor progressMonitor) throws ExecutionException {
        List projectDescriptors = this.getProjectDescriptors();
        progressMonitor.beginTask(ExampleWizardsPlugin.INSTANCE.getString("_UI_CreatingProjects_message"), 2 * projectDescriptors.size());
        for (AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor : projectDescriptors) {
            if (projectDescriptor.getProject().exists()) continue;
            try {
                this.installProject(projectDescriptor, progressMonitor);
            }
            catch (Exception ex) {
                throw new ExecutionException("The project '" + projectDescriptor.getName() + "' could not be installed.", (Throwable)ex);
            }
        }
        progressMonitor.done();
    }

    public class ExampleInstallerPage
    extends AbstractExampleInstallerWizard.ProjectPage {
        private final EMFFormsExampleInstallerWizard wizard;

        public ExampleInstallerPage(EMFFormsExampleInstallerWizard exampleWizard, String pageName, String title, ImageDescriptor titleImage) {
            super((AbstractExampleInstallerWizard)EMFFormsExampleInstallerWizard.this, pageName, title, titleImage);
            this.wizard = exampleWizard;
        }

        public void createControl(Composite parent) {
            SashForm sashForm = new SashForm(parent, 512);
            sashForm.setLayoutData((Object)new GridData(1808));
            this.projectList = new org.eclipse.swt.widgets.List((Composite)sashForm, 2052);
            this.projectList.setLayoutData((Object)new GridData(1808));
            this.projectList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExampleInstallerPage.this.itemSelected();
                }
            });
            this.projectList.setFocus();
            Composite composite = new Composite((Composite)sashForm, 0);
            GridLayout layout = new GridLayout(2, false);
            int margin = -5;
            int spacing = 3;
            layout.marginTop = -5;
            layout.marginLeft = -5;
            layout.marginRight = -5;
            layout.marginBottom = -5;
            layout.horizontalSpacing = 3;
            layout.verticalSpacing = 3;
            composite.setLayout((Layout)layout);
            this.descriptionText = new Text(composite, 2634);
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.convertHeightInCharsToPixels(2);
            gridData.grabExcessVerticalSpace = true;
            this.descriptionText.setLayoutData((Object)gridData);
            Composite buttonComposite = new Composite(composite, 0);
            buttonComposite.setLayoutData((Object)new GridData(130));
            buttonComposite.setLayout((Layout)new GridLayout());
            GridLayout layout2 = new GridLayout();
            int margin2 = -5;
            int spacing2 = 3;
            layout2.marginTop = -5;
            layout2.marginLeft = -5;
            layout2.marginRight = -5;
            layout2.marginBottom = -5;
            layout2.horizontalSpacing = 3;
            layout2.verticalSpacing = 3;
            buttonComposite.setLayout((Layout)layout2);
            this.refresh();
            sashForm.setWeights(new int[]{70, 30});
            this.setControl((Control)sashForm);
        }

        public void refresh() {
            if (this.wizard.getProjectDescriptors().isEmpty()) {
                this.setErrorMessage(ExampleWizardsPlugin.INSTANCE.getString("_UI_NoProjectError_message"));
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                int selectionIndex = this.projectList.getSelectionIndex();
                if (selectionIndex < 0) {
                    selectionIndex = 0;
                }
                this.projectList.removeAll();
                for (AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor : this.wizard.getProjectDescriptors()) {
                    String name = projectDescriptor.getName();
                    boolean exists = projectDescriptor.getProject().exists();
                    String item = exists ? ExampleWizardsPlugin.INSTANCE.getString("_UI_ExistingProjectName_message", new String[]{name}) : name;
                    this.projectList.add(item);
                    this.projectList.setData(item, (Object)projectDescriptor);
                }
                if (this.getControl() != null) {
                    this.projectList.setSelection(selectionIndex);
                    this.itemSelected();
                }
                this.setPageComplete(true);
            }
        }

        public void setVisible(boolean visible) {
            if (visible && this.projectList.getItemCount() > 0 && this.projectList != null && this.projectList.getSelectionCount() == 0) {
                int index = 0;
                int count = 0;
                for (AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor : this.wizard.getProjectDescriptors()) {
                    if (projectDescriptor.getProject().exists()) {
                        index = count;
                        break;
                    }
                    ++count;
                }
                this.projectList.select(index);
                this.refresh();
            }
            super.setVisible(visible);
        }

        protected AbstractExampleInstallerWizard.ProjectDescriptor getSelectedProjectDescriptor() {
            return this.projectList.getSelectionCount() == 0 ? null : (AbstractExampleInstallerWizard.ProjectDescriptor)this.projectList.getData(this.projectList.getSelection()[0]);
        }

        protected void itemSelected() {
            AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
            if (projectDescriptor != null) {
                String description;
                boolean exists = projectDescriptor.getProject().exists();
                String string = description = projectDescriptor.getDescription() != null ? projectDescriptor.getDescription() : "";
                if (exists) {
                    String existsMessage = ExampleWizardsPlugin.INSTANCE.getString("_UI_ProjectExistsAlready_message");
                    description = description == "" ? existsMessage : ExampleWizardsPlugin.INSTANCE.getString("_UI_ProjectDescriptionAndExists_message", new String[]{description, existsMessage});
                }
                this.descriptionText.setText(description);
            }
        }
    }
}

