/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.wagon;

import com.google.common.io.Closer;
import io.takari.aether.client.AetherClient;
import io.takari.aether.client.AetherClientAuthentication;
import io.takari.aether.client.AetherClientConfig;
import io.takari.aether.client.AetherClientProxy;
import io.takari.aether.client.Response;
import io.takari.aether.client.RetryableSource;
import io.takari.aether.okhttp.OkHttpAetherClient;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.resource.Resource;

@Named(value="http")
public class OkHttpWagon
extends StreamWagon {
    private Map<String, String> httpHeaders;
    private AetherClient client;

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        String url = this.buildUrl(resource.getName());
        try {
            Response response = this.client.get(url);
            int statusCode = response.getStatusCode();
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 404: {
                    throw new ResourceDoesNotExistException("Resource not found: " + url);
                }
                case 401: {
                    throw new AuthorizationException("Unauthorized to access: " + url);
                }
                case 407: {
                    throw new AuthorizationException("Proxy authentication required to access: " + url);
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file: " + url + ". Return code is: " + statusCode);
                }
            }
            inputData.setInputStream(response.getInputStream());
        }
        catch (IOException e) {
            StringBuilder message = new StringBuilder("Error transferring file: ");
            message.append(e.getMessage());
            message.append(" from " + url);
            if (this.getProxyInfo() != null && this.getProxyInfo().getHost() != null) {
                message.append(" with proxyInfo ").append(this.getProxyInfo().toString());
            }
            throw new TransferFailedException(message.toString(), (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new UnsupportedOperationException();
    }

    protected OutputStream getOutputStream(Resource resource) throws TransferFailedException {
        throw new UnsupportedOperationException();
    }

    public void put(File file, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.firePutInitiated(resource, file);
        resource.setContentLength(file.length());
        resource.setLastModified(file.lastModified());
        FileSource source = new FileSource(resource, file);
        this.put(source, file, resource);
    }

    protected void putFromStream(InputStream stream, Resource resource) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        this.put(new InputStreamSource(resource, stream), null, resource);
    }

    private void put(RetryableSource source, File file, Resource resource) throws TransferFailedException {
        this.firePutStarted(resource, file);
        String url = this.buildUrl(resource.getName());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                Response response = this.client.put(url, source);
                if (response != null) {
                    response.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException("Specified source file does not exist: " + source, (Throwable)e);
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
            String msg = "PUT request to: " + resource.getName() + " in " + this.repository.getName() + " failed";
            throw new TransferFailedException(msg, (Throwable)e);
        }
        this.firePutCompleted(resource, file);
    }

    public void closeConnection() throws ConnectionException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                throw new ConnectionException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        AetherClientConfig config = new AetherClientConfig();
        config.setUserAgent("Maven-Wagon/1.0");
        if (this.httpHeaders != null) {
            config.setHeaders(this.httpHeaders);
        }
        if (this.getProxyInfo() != null) {
            AetherClientProxy proxy = new AetherClientProxy();
            proxy.setHost(this.getProxyInfo().getHost());
            proxy.setPort(this.getProxyInfo().getPort());
            if (this.getProxyInfo().getUserName() != null && this.getProxyInfo().getPassword() != null) {
                String username = this.getProxyInfo().getUserName();
                String password = this.getProxyInfo().getPassword();
                proxy.setAuthentication(new AetherClientAuthentication(username, password));
            }
            config.setProxy(proxy);
        }
        if (this.getAuthenticationInfo() != null) {
            String username = this.getAuthenticationInfo().getUserName();
            String password = this.getAuthenticationInfo().getPassword();
            AetherClientAuthentication authentication = new AetherClientAuthentication(username, password);
            config.setAuthentication(authentication);
        }
        config.setConnectionTimeout(10000);
        config.setRequestTimeout(1800000);
        this.client = new OkHttpAetherClient(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        String url = this.buildUrl(resourceName);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Response response = this.client.head(url);
                try {
                    int statusCode = response.getStatusCode();
                    switch (statusCode) {
                        case 200: {
                            return true;
                        }
                        case 403: {
                            throw new AuthorizationException("Access denied to: " + url);
                        }
                        case 404: {
                            return false;
                        }
                        case 401: {
                            throw new AuthorizationException("Unauthorized to access: " + url);
                        }
                        case 407: {
                            throw new AuthorizationException("Proxy authentication required to access: " + url);
                        }
                    }
                    throw new TransferFailedException("Failed to look for file: " + url + ". Return code is: " + statusCode);
                }
                finally {
                    if (response == null) return true;
                    response.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    private String buildUrl(String path) {
        String repoUrl = this.getRepository().getUrl();
        path = path.replace(' ', '+');
        if (repoUrl.charAt(repoUrl.length() - 1) != '/') {
            return String.valueOf(repoUrl) + '/' + path;
        }
        return String.valueOf(repoUrl) + path;
    }

    void setSystemProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.getProperties().remove(key);
        }
    }

    public void setHttpHeaders(Properties httpHeaders) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> header : httpHeaders.entrySet()) {
            if (!(header.getKey() instanceof String) || !(header.getValue() instanceof String)) continue;
            map.put((String)header.getKey(), (String)header.getValue());
        }
        this.httpHeaders = Collections.unmodifiableMap(map);
    }

    class FileSource
    extends RetryableResource {
        private final File file;

        public FileSource(Resource resource, File file) {
            super(resource);
            this.file = file;
        }

        @Override
        public void copyTo(OutputStream os) throws IOException {
            this.copy(new FileInputStream(this.file), os);
        }

        @Override
        public long length() {
            return this.file.length();
        }
    }

    class InputStreamSource
    extends RetryableResource {
        private final InputStream is;

        public InputStreamSource(Resource resource, InputStream is) {
            super(resource);
            this.is = is;
        }

        @Override
        public void copyTo(OutputStream os) throws IOException {
            this.copy(this.is, os);
        }

        @Override
        protected void write(OutputStream os, int n, byte[] buffer) throws IOException {
            super.write(os, n, buffer);
        }

        @Override
        public long length() {
            return -1L;
        }
    }

    abstract class RetryableResource
    implements RetryableSource {
        private final Resource resource;

        protected RetryableResource(Resource resource) {
            this.resource = resource;
        }

        protected void copy(InputStream is, OutputStream os) throws IOException {
            TransferEvent transferEvent = new TransferEvent((Wagon)OkHttpWagon.this, this.resource, 3, 6);
            transferEvent.setTimestamp(System.currentTimeMillis());
            try (Closer closer = Closer.create();){
                closer.register((Closeable)is);
                closer.register((Closeable)os);
                int n = 0;
                byte[] buffer = new byte[4096];
                while (-1 != (n = is.read(buffer))) {
                    this.write(os, n, buffer);
                    OkHttpWagon.this.fireTransferProgress(transferEvent, buffer, n);
                }
            }
        }

        protected void write(OutputStream os, int n, byte[] buffer) throws IOException {
            os.write(buffer, 0, n);
        }
    }
}

