/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.XMLExtensionRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class XMLLanguageServer
extends ProcessStreamConnectionProvider {
    public XMLLanguageServer() {
        ArrayList<? extends String> commands = new ArrayList<String>();
        ArrayList<String> jarPaths = new ArrayList<String>();
        commands.add(this.computeJavaPath());
        commands.addAll(this.getProxySettings());
        String debugPortString = System.getProperty(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".debugPort");
        if (debugPortString != null) {
            commands.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + debugPortString);
        }
        commands.add("-classpath");
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/language-servers/server/org.eclipse.lsp4xml-0.9.1-uber.jar"));
            List<String> extensionJarPaths = this.getExtensionJarPaths();
            String uberJarPath = new File(url.getPath()).getAbsolutePath();
            jarPaths.add(uberJarPath);
            jarPaths.addAll(extensionJarPaths);
            commands.add(String.join((CharSequence)System.getProperty("path.separator"), jarPaths));
            commands.add("org.eclipse.lsp4xml.XMLServerLauncher");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    private Collection<? extends String> getProxySettings() {
        IProxyService service;
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry2 : System.getProperties().entrySet()) {
            String property;
            if (!(entry2.getKey() instanceof String) || !(entry2.getValue() instanceof String) || !(property = (String)entry2.getKey()).toLowerCase().contains("proxy") && !property.toLowerCase().contains("proxies")) continue;
            res.put(property, (String)entry2.getValue());
        }
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceRef = bundleContext.getServiceReference(IProxyService.class);
        if (serviceRef != null && (service = (IProxyService)bundleContext.getService(serviceRef)) != null) {
            IProxyData[] iProxyDataArray = service.getProxyData();
            int n = iProxyDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData data = iProxyDataArray[n2];
                if (data.getHost() != null) {
                    res.put(String.valueOf(data.getType().toLowerCase()) + ".proxyHost", data.getHost());
                    res.put(String.valueOf(data.getType().toLowerCase()) + ".proxyPort", Integer.toString(data.getPort()));
                }
                ++n2;
            }
            String nonProxiedHosts = String.join((CharSequence)"|", service.getNonProxiedHosts());
            if (!nonProxiedHosts.isEmpty()) {
                res.put("http.nonProxyHosts", nonProxiedHosts);
                res.put("https.nonProxyHosts", nonProxiedHosts);
            }
        }
        return res.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + '=' + (String)entry.getValue()).collect(Collectors.toSet());
    }

    private List<String> getExtensionJarPaths() {
        XMLExtensionRegistry extensionJarRegistry = new XMLExtensionRegistry();
        List<String> extensionJarPaths = extensionJarRegistry.getXMLExtensionJars();
        extensionJarPaths.addAll(extensionJarRegistry.getXMLLSClassPathExtensions());
        return extensionJarPaths;
    }

    private String computeJavaPath() {
        String javaPath = "java";
        boolean existsInPath = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator))).map(path -> path.startsWith("\"") && path.endsWith("\"") ? path.substring(1, path.length() - 1) : path).map(string -> Paths.get(string, new String[0])).anyMatch(path -> Files.exists(path.resolve("java"), new LinkOption[0]));
        if (!existsInPath) {
            File f = new File(System.getProperty("java.home"), "bin/java" + (Platform.getOS().equals("win32") ? ".exe" : ""));
            javaPath = f.getAbsolutePath();
        }
        return javaPath;
    }

    public String toString() {
        return "XML Language Server: " + super.toString();
    }
}

