/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.entityresolver.LocalEntityResolver;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class HelpIndexBuilder {
    private static final String POINT_TOC = "org.eclipse.help.toc";
    private static final String EL_TOC = "toc";
    private static final String EL_INDEX = "index";
    private File manifest;
    private String indexPath;
    private File destination;
    private ArrayList<TocFile> tocFiles = new ArrayList();
    private ArrayList<LocaleDir> localeDirs = new ArrayList();
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder parser;
    private static Locale[] legalLocales = Locale.getAvailableLocales();
    private static HashSet<String> legalLanguages = null;
    private static HashSet<String> legalCountries = null;

    public File getManifest() {
        return this.manifest;
    }

    public void setManifest(File manifest) {
        File project;
        File parent;
        if (manifest.getName().equalsIgnoreCase("MANIFEST.MF") && (parent = manifest.getParentFile()).getName().equalsIgnoreCase("META-INF") && !(manifest = new File(project = parent.getParentFile(), "plugin.xml")).exists()) {
            manifest = null;
        }
        this.manifest = manifest;
    }

    public File getDestination() {
        return this.destination;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        this.reset();
        if (this.manifest == null || this.destination == null) {
            return;
        }
        Document doc = this.readXMLFile(this.manifest);
        if (doc == null) {
            return;
        }
        PluginIdentifier pid = this.getPluginID(this.manifest.getParentFile(), doc);
        PluginIdentifier fid = null;
        if (!this.manifest.getParentFile().equals(this.destination)) {
            File fragmentFile = new File(this.destination, "fragment.xml");
            Document fdoc = null;
            if (fragmentFile.exists()) {
                fdoc = this.readXMLFile(fragmentFile);
            }
            fid = this.getPluginID(this.destination, fdoc);
            fdoc = null;
        }
        Element[] extensions = this.getTocExtensions(doc);
        int i = 0;
        while (i < extensions.length) {
            this.processExtension(extensions[i]);
            ++i;
        }
        if (this.indexPath == null) {
            this.throwCoreException(HelpBaseResources.HelpIndexBuilder_noDestinationPath, null);
        }
        doc = null;
        this.computeLocaleDirs(fid != null);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)HelpBaseResources.HelpIndexBuilder_buildingIndex, (int)this.localeDirs.size());
        MultiStatus multiStatus = null;
        for (LocaleDir localeDir : this.localeDirs) {
            MultiStatus localeStatus = this.processLocaleDir(pid, fid, localeDir, subMonitor.split(1));
            if (localeStatus == null) continue;
            if (multiStatus == null) {
                multiStatus = localeStatus;
                continue;
            }
            multiStatus.addAll((IStatus)localeStatus);
        }
        subMonitor.done();
        if (multiStatus != null) {
            throw new CoreException(multiStatus);
        }
    }

    private void processExtension(Element extensionNode) {
        NodeList children = extensionNode.getElementsByTagName(EL_TOC);
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String file = this.getAttribute(node, "file");
            String primary = this.getAttribute(node, "primary");
            String extradir = this.getAttribute(node, "extradir");
            this.addTocFile(file, primary, extradir);
            ++i;
        }
        children = extensionNode.getElementsByTagName(EL_INDEX);
        if (children.getLength() == 1) {
            Node node = children.item(0);
            this.indexPath = this.getAttribute(node, "path");
        }
    }

    private void addTocFile(String file, String primary, String extradir) {
        boolean isPrimary = primary != null && primary.equalsIgnoreCase("true");
        this.tocFiles.add(new TocFile(file, isPrimary, extradir));
    }

    private void computeLocaleDirs(boolean fragment) throws CoreException {
        if (!fragment) {
            LocaleDir dir = new LocaleDir(null, "/");
            dir.addDirectory(this.destination);
            this.localeDirs.add(dir);
        }
        File ws = new File(this.destination, "ws");
        this.computeSystem(ws, Platform.knownWSValues());
        File os = new File(this.destination, "os");
        this.computeSystem(os, Platform.knownOSValues());
        File nl = new File(this.destination, "nl");
        if (!nl.exists() || !nl.isDirectory()) {
            return;
        }
        File[] languages = this.listFiles(nl);
        HashSet<String> locales = new HashSet<String>();
        File[] fileArray = languages;
        int n = languages.length;
        int n2 = 0;
        while (n2 < n) {
            File language = fileArray[n2];
            if (language.isDirectory() && this.isValidLanguage(language.getName())) {
                File[] countries;
                File[] fileArray2 = countries = this.listFiles(language);
                int n3 = countries.length;
                int n4 = 0;
                while (n4 < n3) {
                    String locale;
                    File country = fileArray2[n4];
                    boolean hasCountry = false;
                    if (country.isDirectory() && this.isValidCountry(country.getName())) {
                        hasCountry = true;
                    }
                    if (this.isValidLocale(locale = hasCountry ? String.valueOf(language.getName()) + "_" + country.getName() : language.getName()) && !locales.contains(locale)) {
                        String relativePath = hasCountry ? "/nl/" + language.getName() + "/" + country.getName() : "/nl/" + language.getName();
                        LocaleDir dir = new LocaleDir(locale, relativePath);
                        if (hasCountry) {
                            dir.addDirectory(country);
                        }
                        dir.addDirectory(language);
                        dir.addDirectory(this.destination);
                        this.localeDirs.add(dir);
                        locales.add(locale);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void computeSystem(File systemRoot, String[] values) throws CoreException {
        if (systemRoot.exists() && systemRoot.isDirectory()) {
            File[] files;
            File[] fileArray = files = this.listFiles(systemRoot);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File sdir = fileArray[n2];
                if (sdir.isDirectory()) {
                    String sname = sdir.getName();
                    String[] stringArray = values;
                    int n3 = values.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String value = stringArray[n4];
                        if (value.equals(sname)) {
                            String relativePath = "/" + systemRoot.getName() + "/" + sname;
                            LocaleDir dir = new LocaleDir(sname, relativePath);
                            dir.addDirectory(sdir);
                            dir.addDirectory(this.destination);
                            this.localeDirs.add(dir);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private boolean isValidLocale(String locale) {
        Locale[] localeArray = legalLocales;
        int n = legalLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale legalLocale = localeArray[n2];
            if (legalLocale.toString().equals(locale)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isValidLanguage(String language) {
        if (legalLanguages == null) {
            legalLanguages = new HashSet();
            String[] choices = Locale.getISOLanguages();
            Collections.addAll(legalLanguages, choices);
        }
        return legalLanguages.contains(language);
    }

    private boolean isValidCountry(String country) {
        if (legalCountries == null) {
            legalCountries = new HashSet();
            String[] choices = Locale.getISOCountries();
            Collections.addAll(legalCountries, choices);
        }
        return legalCountries.contains(country);
    }

    private MultiStatus processLocaleDir(PluginIdentifier id, PluginIdentifier fid, LocaleDir localeDir, SubMonitor monitor) throws CoreException {
        File directory = localeDir.dirs.get(0);
        File indexDirectory = new File(directory, this.indexPath);
        this.prepareDirectory(indexDirectory);
        Collection<String> docs = this.collectDocs(localeDir);
        MultiStatus status = null;
        if (docs.size() > 0) {
            String locale = localeDir.locale != null ? localeDir.locale : Platform.getNL();
            SearchIndex index = new SearchIndex(indexDirectory, locale, new AnalyzerDescriptor(locale), null, localeDir.relativePath);
            IndexerPluginVersionInfo docPlugins = new IndexerPluginVersionInfo(id, fid, indexDirectory);
            index.setDocPlugins(docPlugins);
            status = this.createIndex(id.id, fid != null, localeDir, index, docs, monitor);
            index.deleteLockFile();
        }
        return status;
    }

    private Collection<String> collectDocs(LocaleDir localeDir) throws CoreException {
        HashSet<String> docs = new HashSet<String>();
        for (TocFile tocFile : this.tocFiles) {
            this.collectDocs(docs, this.getTocFile(localeDir, tocFile.href));
            String cfr_ignored_0 = tocFile.extraDir;
        }
        return docs;
    }

    private File getTocFile(LocaleDir localeDir, String href) {
        File file = localeDir.findFile(href);
        if (file != null) {
            return file;
        }
        File pdir = this.manifest.getParentFile();
        return new File(pdir, href);
    }

    private void collectDocs(Set<String> docs, File tocFile) throws CoreException {
        if (!tocFile.exists()) {
            return;
        }
        Document doc = this.readXMLFile(tocFile);
        this.add(doc.getDocumentElement(), docs);
    }

    private void add(Element topic, Set<String> hrefs) {
        String href = this.getAttribute(topic, "href");
        if (topic.getTagName().equals(EL_TOC)) {
            href = this.getAttribute(topic, "topic");
        }
        if (!(href == null || href.isEmpty() || href.startsWith("http://") || href.startsWith("https://") || (href = SearchIndex.getIndexableHref(href)) == null)) {
            hrefs.add(href);
        }
        NodeList subtopics = topic.getElementsByTagName("topic");
        int i = 0;
        while (i < subtopics.getLength()) {
            Element subtopic = (Element)subtopics.item(i);
            href = this.getAttribute(subtopic, "href");
            if (!(href == null || href.isEmpty() || href.startsWith("http://") || href.startsWith("https://") || (href = SearchIndex.getIndexableHref(href)) == null)) {
                hrefs.add(href);
            }
            ++i;
        }
    }

    private MultiStatus createIndex(String pluginId, boolean fragment, LocaleDir localeDir, SearchIndex index, Collection<String> addedDocs, SubMonitor monitor) throws CoreException {
        String taskName = NLS.bind((String)HelpBaseResources.HelpIndexBuilder_indexFor, (Object)localeDir.dirs.get(0).getName());
        monitor.beginTask(String.valueOf(taskName) + HelpBaseResources.UpdatingIndex, addedDocs.size());
        if (!index.beginAddBatch(true)) {
            this.throwCoreException(HelpBaseResources.HelpIndexBuilder_error, null);
        }
        this.checkCancelled((IProgressMonitor)monitor);
        MultiStatus multiStatus = null;
        for (String href : addedDocs) {
            URL url = localeDir.findURL(href);
            if (url != null) {
                IStatus status = index.addDocument(this.getName(pluginId, href), url);
                if (status.getCode() != 0) {
                    if (multiStatus == null) {
                        multiStatus = this.createMultiStatus();
                    }
                    multiStatus.add(status);
                }
            } else {
                String locale = localeDir.locale != null ? localeDir.locale : Platform.getNL();
                String message = NLS.bind((String)HelpBaseResources.HelpIndexBuilder_cannotFindDoc, (Object)locale, (Object)href);
                Status status = new Status(2, pluginId, 0, message, null);
                if (multiStatus == null) {
                    multiStatus = this.createMultiStatus();
                }
                multiStatus.add((IStatus)status);
            }
            this.checkCancelled((IProgressMonitor)monitor);
            monitor.worked(1);
        }
        monitor.subTask(String.valueOf(taskName) + HelpBaseResources.Writing_index);
        if (!index.endAddBatch(true, true)) {
            Status status = new Status(4, "org.eclipse.help.base", 0, HelpBaseResources.HelpIndexBuilder_errorWriting, null);
            if (multiStatus == null) {
                multiStatus = this.createMultiStatus();
            }
            multiStatus.add((IStatus)status);
        }
        return multiStatus;
    }

    private MultiStatus createMultiStatus() {
        return new MultiStatus("org.eclipse.help.base", 0, HelpBaseResources.HelpIndexBuilder_incompleteIndex, null);
    }

    private void checkCancelled(IProgressMonitor pm) throws OperationCanceledException {
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private String getName(String pluginId, String href) {
        int i = href.indexOf(63);
        if (i != -1) {
            href = href.substring(0, i);
        }
        return "/" + pluginId + "/" + href;
    }

    private void prepareDirectory(File indexDirectory) throws CoreException {
        if (indexDirectory.exists()) {
            File[] files;
            File[] fileArray = files = this.listFiles(indexDirectory);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                boolean result = file.delete();
                if (!result) {
                    this.throwCoreException(HelpBaseResources.HelpIndexBuilder_cannotScrub, null);
                }
                ++n2;
            }
        } else {
            boolean result = indexDirectory.mkdirs();
            if (!result) {
                this.throwCoreException(HelpBaseResources.HelpIndexBuilder_cannotCreateDest, null);
            }
        }
    }

    private void reset() {
        this.localeDirs.clear();
        this.tocFiles.clear();
        this.indexPath = null;
    }

    private PluginIdentifier getPluginID(File dir, Document doc) throws CoreException {
        File OSGiFile;
        String id = null;
        String version = null;
        if (doc != null) {
            Element root = doc.getDocumentElement();
            id = this.getAttribute(root, "id");
            version = this.getAttribute(root, "version");
            if (id != null && version != null) {
                return new PluginIdentifier(id, version);
            }
        }
        if ((OSGiFile = new File(dir, "META-INF/MANIFEST.MF")).exists()) {
            ManifestElement[] elements;
            String value;
            block11: {
                Properties headers;
                block10: {
                    Manifest OSGiManifest = new Manifest(new FileInputStream(OSGiFile));
                    headers = this.manifestToProperties(OSGiManifest.getMainAttributes());
                    value = headers.get("Bundle-SymbolicName").toString();
                    if (value != null) break block10;
                    return null;
                }
                elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                if (elements.length > 0) {
                    id = elements[0].getValue();
                }
                if ((value = headers.get("Bundle-Version").toString()) != null) break block11;
                return null;
            }
            try {
                elements = ManifestElement.parseHeader((String)"Bundle-Version", (String)value);
                if (elements.length > 0) {
                    version = elements[0].getValue();
                }
                if (id != null && version != null) {
                    return new PluginIdentifier(id, version);
                }
            }
            catch (Exception e1) {
                this.throwCoreException(HelpBaseResources.HelpIndexBuilder_errorExtractingId, e1);
            }
        }
        return null;
    }

    private String getAttribute(Node node, String name) {
        Node att;
        NamedNodeMap atts = node.getAttributes();
        if (atts != null && (att = atts.getNamedItem(name)) != null) {
            return att.getNodeValue();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document readXMLFile(File file) throws CoreException {
        Document d = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream stream = new FileInputStream(file);
                try {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
                        InputSource inputSource = new InputSource(reader);
                        inputSource.setSystemId(this.manifest.toString());
                        if (this.parser == null) {
                            this.parser = documentBuilderFactory.newDocumentBuilder();
                        }
                        this.parser.setEntityResolver((EntityResolver)new LocalEntityResolver());
                        d = this.parser.parse(inputSource);
                    }
                    if (stream == null) return d;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    ((InputStream)stream).close();
                    throw throwable;
                }
                ((InputStream)stream).close();
                return d;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String message = NLS.bind((String)HelpBaseResources.HelpIndexBuilder_errorParsing, (Object)file.getName());
            this.throwCoreException(message, e);
        }
        return d;
    }

    private Element[] getTocExtensions(Document doc) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList children = doc.getElementsByTagName("extension");
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String point = this.getAttribute(child, "point");
            if (point.equals(POINT_TOC)) {
                list.add(child);
            }
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    private Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    private void throwCoreException(String message, Throwable t) throws CoreException {
        Status status = new Status(4, "org.eclipse.help.base", 0, message, t);
        throw new CoreException((IStatus)status);
    }

    private File[] listFiles(File file) throws CoreException {
        File[] fileList = file.listFiles();
        if (fileList == null) {
            this.throwCoreException("Content from directory '" + file.getAbsolutePath() + "' can not be listed.", null);
        }
        return fileList;
    }

    class IndexerPluginVersionInfo
    extends PluginVersionInfo {
        private static final long serialVersionUID = 1L;

        public IndexerPluginVersionInfo(PluginIdentifier id, PluginIdentifier fid, File dir) {
            super("indexed_contributions", null, dir, false);
            this.createInfo(id, fid);
        }

        @Override
        protected void createTable(Collection<String> docBundleIds) {
        }

        protected void createInfo(PluginIdentifier id, PluginIdentifier fid) {
            StringBuilder buffer = new StringBuilder();
            this.appendBundleInformation(buffer, id.id, id.version.toString());
            if (fid != null) {
                this.appendBundleInformation(buffer, fid.id, fid.version.toString());
            }
            this.put(id.id, buffer.toString());
        }
    }

    class LocaleDir {
        String locale;
        String relativePath;
        ArrayList<File> dirs = new ArrayList();

        public LocaleDir(String locale, String relativePath) {
            this.locale = locale;
            this.relativePath = relativePath;
        }

        public File findFile(String file) {
            for (File dir : this.dirs) {
                File absoluteFile = new File(dir, file);
                if (!absoluteFile.exists()) continue;
                return absoluteFile;
            }
            return null;
        }

        public URL findURL(String href) {
            File file = this.findFile(href);
            if (file != null) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        public void addDirectory(File directory) {
            this.dirs.add(directory);
        }
    }

    class PluginIdentifier {
        String id;
        Version version;

        public PluginIdentifier(String id, String version) {
            this.id = id;
            this.version = new Version(version);
        }
    }

    class TocFile {
        String href;
        boolean primary;
        String extraDir;

        public TocFile(String href, boolean primary, String extraDir) {
            this.href = href;
            this.primary = primary;
            this.extraDir = extraDir;
        }
    }
}

