/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.AbstractPlotRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

class SWTPlotRenderer
extends AbstractPlotRenderer<SWTCommitList.SWTLane, Color> {
    private static final RGB OUTER_HEAD = new RGB(0, 128, 0);
    private static final RGB INNER_HEAD = new RGB(188, 220, 188);
    private static final RGB OUTER_TAG = new RGB(121, 120, 13);
    private static final RGB INNER_TAG = new RGB(249, 255, 199);
    private static final RGB OUTER_ANNOTATED = new RGB(104, 78, 0);
    private static final RGB INNER_ANNOTATED = new RGB(255, 239, 192);
    private static final RGB OUTER_REMOTE = new RGB(80, 80, 80);
    private static final RGB INNER_REMOTE = new RGB(225, 225, 225);
    private static final RGB OUTER_OTHER = new RGB(30, 30, 30);
    private static final RGB INNER_OTHER = new RGB(250, 250, 250);
    private static final int MAX_LABEL_LENGTH = 18;
    private static final String ELLIPSIS = "\u2026";
    private final Color sys_black;
    private final Color sys_gray;
    private final Color sys_white;
    private final Color commitDotFill;
    private final Color commitDotOutline;
    private final Map<String, Point> labelCoordinates = new HashMap<String, Point>();
    private final Set<String> ellipsisTags = new HashSet<String>();
    private int textHeight;
    private final ResourceManager resources;
    GC g;
    int cellX;
    int cellY;
    Color cellFG;
    Color cellBG;
    private Ref headRef;
    private int tagCount = 0;

    SWTPlotRenderer(Display d, ResourceManager resources) {
        this.resources = resources;
        this.sys_black = d.getSystemColor(2);
        this.sys_gray = d.getSystemColor(15);
        this.sys_white = d.getSystemColor(1);
        this.commitDotFill = resources.createColor(new RGB(220, 220, 220));
        this.commitDotOutline = resources.createColor(new RGB(110, 110, 110));
    }

    void paint(Event event) {
        this.g = event.gc;
        this.cellX = event.x;
        this.cellY = event.y;
        this.cellFG = this.g.getForeground();
        this.cellBG = this.g.getBackground();
        if (this.textHeight == 0) {
            this.textHeight = this.g.stringExtent((String)"/").y;
        }
        TableItem ti = (TableItem)event.item;
        SWTCommit commit = (SWTCommit)((Object)ti.getData());
        try {
            commit.parseBody();
            this.headRef = commit.getHead();
        }
        catch (IOException e) {
            Activator.error("Error parsing body", e);
            return;
        }
        this.paintCommit(commit, event.height);
    }

    protected void drawLine(Color color, int x1, int y1, int x2, int y2, int width) {
        this.g.setForeground(color);
        this.g.setLineWidth(width);
        this.g.drawLine(this.cellX + x1, this.cellY + y1, this.cellX + x2, this.cellY + y2);
    }

    protected void drawDot(Color outline, Color fill, int x, int y, int w, int h) {
        int dotX = this.cellX + x + 2;
        int dotY = this.cellY + y + 1;
        int dotW = w - 2;
        int dotH = h - 2;
        this.g.setBackground(fill);
        this.g.fillOval(dotX, dotY, dotW, dotH);
        this.g.setForeground(outline);
        this.g.setLineWidth(2);
        this.g.drawOval(dotX, dotY, dotW, dotH);
    }

    protected void drawCommitDot(int x, int y, int w, int h) {
        this.drawDot(this.commitDotOutline, this.commitDotFill, x, y, w, h);
    }

    protected void drawBoundaryDot(int x, int y, int w, int h) {
        this.drawDot(this.sys_gray, this.sys_white, x, y, w, h);
    }

    protected void drawText(String msg, int x, int y) {
        String text = msg.replace('\t', ' ');
        Point textsz = this.g.textExtent(text);
        int texty = (y - textsz.y) / 2;
        this.g.setForeground(this.cellFG);
        this.g.setBackground(this.cellBG);
        this.g.drawString(text, this.cellX + x, this.cellY + texty, true);
        this.tagCount = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int drawLabel(int x, int y, Ref ref) {
        String txt;
        RGB labelInner;
        RGB labelOuter;
        String name = ref.getName();
        boolean tag = false;
        boolean branch = false;
        if (name.startsWith("refs/heads/")) {
            branch = true;
            labelOuter = OUTER_HEAD;
            labelInner = INNER_HEAD;
            txt = name.substring("refs/heads/".length());
        } else if (name.startsWith("refs/remotes/")) {
            branch = true;
            labelOuter = OUTER_REMOTE;
            labelInner = INNER_REMOTE;
            txt = name.substring("refs/remotes/".length());
        } else if (name.startsWith("refs/tags/")) {
            ++this.tagCount;
            tag = true;
            if (ref.getPeeledObjectId() != null) {
                labelOuter = OUTER_ANNOTATED;
                labelInner = INNER_ANNOTATED;
            } else {
                labelOuter = OUTER_TAG;
                labelInner = INNER_TAG;
            }
            int maxNumberOfTags = 1;
            if (this.tagCount == maxNumberOfTags) {
                txt = name.substring("refs/tags/".length());
            } else {
                if (this.tagCount != maxNumberOfTags + 1) return 0;
                txt = ELLIPSIS;
                this.ellipsisTags.add(name);
            }
        } else {
            labelOuter = OUTER_OTHER;
            labelInner = INNER_OTHER;
            txt = name.startsWith("refs/") ? name.substring("refs/".length()) : name;
        }
        int maxLength = tag ? Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxTagLength") : (branch ? Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxBranchLength") : 18);
        if (txt.length() > maxLength) {
            int textLength = maxLength - 3;
            txt = Activator.getDefault().getPreferenceStore().getBoolean("HistoryView_CutAtStart") ? ELLIPSIS + txt.substring(txt.length() - textLength) : String.valueOf(txt.substring(0, textLength)) + ELLIPSIS;
        }
        Font oldFont = this.g.getFont();
        boolean isHead = this.isHead(name);
        if (isHead) {
            this.g.setFont(CommitGraphTable.highlightFont());
        }
        Point textsz = this.g.stringExtent(txt);
        int arc = textsz.y / 2;
        int texty = (y * 2 - textsz.y) / 2;
        int outerWidth = textsz.x + 7;
        this.g.setLineWidth(1);
        this.g.setBackground(this.sys_white);
        this.g.fillRoundRectangle(this.cellX + x + 1, this.cellY + texty, textsz.x + 6, textsz.y + 1, arc, arc);
        this.g.setBackground(this.resources.createColor(labelInner));
        this.g.fillRoundRectangle(this.cellX + x + 2, this.cellY + texty + 1, textsz.x + 4, textsz.y - 2, arc - 1, arc - 1);
        this.g.setForeground(this.resources.createColor(labelOuter));
        this.g.drawRoundRectangle(this.cellX + x, this.cellY + texty - 1, outerWidth, textsz.y + 1, arc, arc);
        this.g.setForeground(this.sys_black);
        this.g.drawString(txt, this.cellX + x + 4, this.cellY + texty, true);
        if (isHead) {
            this.g.setFont(oldFont);
        }
        this.labelCoordinates.put(name, new Point(x, x + outerWidth));
        return 10 + textsz.x;
    }

    private boolean isHead(String name) {
        String headRefName;
        boolean isHead = false;
        if (this.headRef != null && name.equals(headRefName = this.headRef.getLeaf().getName())) {
            isHead = true;
        }
        return isHead;
    }

    protected Color laneColor(SWTCommitList.SWTLane myLane) {
        return myLane != null ? myLane.color : this.sys_black;
    }

    Point getRefHSpan(Ref ref) {
        return this.labelCoordinates.get(ref.getName());
    }

    boolean isShownAsEllipsis(Ref ref) {
        return this.ellipsisTags.contains(ref.getName());
    }
}

