/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposalComparator;
import org.eclipse.lsp4e.operations.completion.LSIncompleteCompletionProposal;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSContentAssistProcessor
implements IContentAssistProcessor {
    private static final long TRIGGERS_TIMEOUT = 50L;
    private static final long CONTEXT_INFORMATION_TIMEOUT = 1000L;
    private IDocument currentDocument;
    private String errorMessage;
    private CompletableFuture<List<@NonNull LanguageServer>> completionLanguageServersFuture;
    private final Object completionTriggerCharsSemaphore = new Object();
    private char[] completionTriggerChars = new char[0];
    private CompletableFuture<List<@NonNull LanguageServer>> contextInformationLanguageServersFuture;
    private final Object contextTriggerCharsSemaphore = new Object();
    private char[] contextTriggerChars = new char[0];
    private Comparator<LSCompletionProposal> proposalConparoator = new LSCompletionProposalComparator();

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        CompletionParams param;
        IDocument document = viewer.getDocument();
        this.initiateLanguageServers(document);
        try {
            param = LSPEclipseUtils.toCompletionParams(LSPEclipseUtils.toUri(document), offset, document);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return new ICompletionProposal[]{this.createErrorProposal(offset, (Exception)((Object)e))};
        }
        List<ICompletionProposal> proposals = Collections.synchronizedList(new ArrayList());
        try {
            ((CompletableFuture)this.completionLanguageServersFuture.thenComposeAsync(languageServers -> CompletableFuture.allOf((CompletableFuture[])languageServers.stream().map(languageServer -> languageServer.getTextDocumentService().completion(param).thenAcceptAsync(completion -> {
                boolean bl = proposals.addAll(LSContentAssistProcessor.toProposals(document, offset, (Either<List<CompletionItem>, CompletionList>)completion, languageServer));
            })).toArray(CompletableFuture[]::new)))).get();
        }
        catch (ExecutionException e) {
            LanguageServerPlugin.logError(e);
            return new ICompletionProposal[]{this.createErrorProposal(offset, e)};
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return new ICompletionProposal[]{this.createErrorProposal(offset, e)};
        }
        ICompletionProposal[] completeProposals = new LSCompletionProposal[proposals.size()];
        int i = 0;
        for (ICompletionProposal proposal : proposals) {
            if (proposal instanceof LSCompletionProposal) {
                completeProposals[i] = (LSCompletionProposal)proposal;
                ++i;
                continue;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        Arrays.sort(completeProposals, this.proposalConparoator);
        return completeProposals;
    }

    private CompletionProposal createErrorProposal(int offset, Exception ex) {
        return new CompletionProposal("", offset, 0, 0, null, Messages.completionError, null, ex.getMessage());
    }

    private void initiateLanguageServers(@NonNull IDocument document) {
        if (this.currentDocument != document) {
            this.currentDocument = document;
            if (this.completionLanguageServersFuture != null) {
                try {
                    this.completionLanguageServersFuture.cancel(true);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
            if (this.contextInformationLanguageServersFuture != null) {
                try {
                    this.contextInformationLanguageServersFuture.cancel(true);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
            }
            this.completionTriggerChars = new char[0];
            this.contextTriggerChars = new char[0];
            this.completionLanguageServersFuture = LanguageServiceAccessor.getLanguageServers(document, capabilities -> {
                CompletionOptions provider = capabilities.getCompletionProvider();
                if (provider != null) {
                    Object object = this.completionTriggerCharsSemaphore;
                    synchronized (object) {
                        this.completionTriggerChars = LSContentAssistProcessor.mergeTriggers(this.completionTriggerChars, provider.getTriggerCharacters());
                    }
                    return true;
                }
                return false;
            });
            this.contextInformationLanguageServersFuture = LanguageServiceAccessor.getLanguageServers(document, capabilities -> {
                SignatureHelpOptions provider = capabilities.getSignatureHelpProvider();
                if (provider != null) {
                    Object object = this.contextTriggerCharsSemaphore;
                    synchronized (object) {
                        this.contextTriggerChars = LSContentAssistProcessor.mergeTriggers(this.contextTriggerChars, provider.getTriggerCharacters());
                    }
                    return true;
                }
                return false;
            });
        }
    }

    private static List<ICompletionProposal> toProposals(IDocument document, int offset, Either<List<CompletionItem>, CompletionList> completionList, LanguageServer languageServer) {
        if (completionList == null) {
            return Collections.emptyList();
        }
        List items = Collections.emptyList();
        boolean isIncomplete = false;
        if (completionList.isLeft()) {
            items = (List)completionList.getLeft();
        } else if (completionList.isRight()) {
            isIncomplete = ((CompletionList)completionList.getRight()).isIncomplete();
            items = ((CompletionList)completionList.getRight()).getItems();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (CompletionItem item : items) {
            LSIncompleteCompletionProposal proposal;
            if (item == null) continue;
            if (isIncomplete) {
                proposal = new LSIncompleteCompletionProposal(document, offset, item, languageServer);
                proposals.add(proposal);
                continue;
            }
            proposal = new LSCompletionProposal(document, offset, item, languageServer);
            if (!((LSCompletionProposal)proposal).validate(document, offset, null)) continue;
            proposals.add(proposal);
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        SignatureHelpParams param;
        this.initiateLanguageServers(viewer.getDocument());
        try {
            param = LSPEclipseUtils.toSignatureHelpParams(offset, viewer.getDocument());
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return new IContextInformation[0];
        }
        List contextInformations = Collections.synchronizedList(new ArrayList());
        try {
            ((CompletableFuture)this.contextInformationLanguageServersFuture.thenComposeAsync(languageServers -> CompletableFuture.allOf((CompletableFuture[])languageServers.stream().map(languageServer -> languageServer.getTextDocumentService().signatureHelp(param)).map(signatureHelpFuture -> signatureHelpFuture.thenAcceptAsync(signatureHelp -> signatureHelp.getSignatures().stream().map(LSContentAssistProcessor::toContextInformation).forEach(contextInformations::add))).toArray(CompletableFuture[]::new)))).get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
            return new IContextInformation[0];
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return new IContextInformation[0];
        }
        return contextInformations.toArray(new IContextInformation[0]);
    }

    private static IContextInformation toContextInformation(SignatureInformation information) {
        StringBuilder signature = new StringBuilder(information.getLabel());
        String docString = LSPEclipseUtils.getDocString((Either<String, MarkupContent>)information.getDocumentation());
        if (docString != null && !docString.isEmpty()) {
            signature.append('\n').append(docString);
        }
        ContextInformation contextInformation = new ContextInformation(information.getLabel(), signature.toString());
        return contextInformation;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        ITextEditor textEditor = LSPEclipseUtils.getActiveTextEditor();
        if (textEditor != null) {
            this.initiateLanguageServers(LSPEclipseUtils.getDocument(textEditor));
            try {
                this.completionLanguageServersFuture.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException | OperationCanceledException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
        }
        return this.completionTriggerChars;
    }

    private static char[] mergeTriggers(char[] initialArray, Collection<String> additionalTriggers) {
        if (initialArray == null) {
            initialArray = new char[]{};
        }
        if (additionalTriggers == null) {
            additionalTriggers = Collections.emptySet();
        }
        HashSet<Character> triggers = new HashSet<Character>();
        char[] cArray = initialArray;
        int n = initialArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            triggers.add(Character.valueOf(c));
            ++n2;
        }
        additionalTriggers.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).map(triggerChar -> Character.valueOf(triggerChar.charAt(0))).forEach(triggers::add);
        char[] res = new char[triggers.size()];
        int i = 0;
        for (Character c : triggers) {
            res[i] = c.charValue();
            ++i;
        }
        return res;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        ITextEditor textEditor = LSPEclipseUtils.getActiveTextEditor();
        if (textEditor != null) {
            this.initiateLanguageServers(LSPEclipseUtils.getDocument(textEditor));
            try {
                this.contextInformationLanguageServersFuture.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException | TimeoutException | OperationCanceledException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
        }
        return this.contextTriggerChars;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }
}

