/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractValidationSettingsPage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;

public class XMLValidatorPreferencePage
extends AbstractValidationSettingsPage {
    private static final String SETTINGS_SECTION_NAME = "XMLValidationSeverities";
    boolean fOriginalUseXIncludeButtonSelected;
    boolean fOriginalUseHonourAllButtonSelected;
    boolean fOriginalUseResolveExternalEntities;
    boolean fOriginalUseExtendedMarkupValidation;
    private Combo fIndicateNoGrammar = null;
    private Combo fIndicateReferencedFileError = null;
    private Combo fIndicateNoDocumentElement = null;
    private Button fHonourAllSchemaLocations = null;
    private Button fResolveExternalEntities = null;
    private Button fUseXinclude = null;
    private Button fExtendedMarkupValidation;
    private Combo fMissingStartTag;
    private Combo fMissingEndTag;
    private Combo fMissingTagName;
    private Combo fEmptyElementTag;
    private Combo fEndTagWithAttributes;
    private Combo fInvalidWhitespaceBeforeTagname;
    private Combo fMissingClosingBracket;
    private Combo fMissingClosingQuote;
    private Combo fMissingQuotes;
    private Combo fInvalidNamespaceInPI;
    private Combo fInvalidWhitespaceAtStart;
    private Group fMarkupValidationGroup;
    private ControlEnableState fMarkupState;
    private static final int[] XML_SEVERITIES = new int[]{2, 1, -1};
    private static final String[] MARKUP_SEVERITIES = new String[]{XMLUIMessages.Severity_error, XMLUIMessages.Severity_warning, XMLUIMessages.Severity_ignore};

    protected void createContentsForValidatingGroup(Composite validatingGroup) {
        if (this.fIndicateNoGrammar == null) {
            this.fIndicateNoGrammar = this.addComboBox(validatingGroup, XMLUIMessages.Indicate_no_grammar_specified, "indicateNoGrammar", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fIndicateReferencedFileError == null) {
            this.fIndicateReferencedFileError = this.addComboBox(validatingGroup, XMLUIMessages.Indicate_referenced_file_error, "indicateReferencedFileContainsErrors", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fIndicateNoDocumentElement == null) {
            this.fIndicateNoDocumentElement = this.addComboBox(validatingGroup, XMLUIMessages.Indicate_no_document_element, "indiciateNoDocumentElement", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fUseXinclude == null) {
            this.fUseXinclude = this.createCheckBox(validatingGroup, XMLUIMessages.Use_XInclude);
            ((GridData)this.fUseXinclude.getLayoutData()).horizontalSpan = 2;
        }
        if (this.fHonourAllSchemaLocations == null) {
            this.fHonourAllSchemaLocations = this.createCheckBox(validatingGroup, XMLUIMessages.Honour_all_schema_locations);
            ((GridData)this.fHonourAllSchemaLocations.getLayoutData()).horizontalSpan = 2;
        }
        if (this.getProject() == null && this.fResolveExternalEntities == null) {
            this.fResolveExternalEntities = this.createCheckBox(validatingGroup, XMLUIMessages.Resolve_external_entities);
            ((GridData)this.fResolveExternalEntities.getLayoutData()).horizontalSpan = 2;
        }
        IScopeContext[] contexts = this.createPreferenceScopes();
        this.fOriginalUseXIncludeButtonSelected = this.getBooleanPreference("xinclude", false, contexts);
        if (this.fUseXinclude != null) {
            this.fUseXinclude.setSelection(this.fOriginalUseXIncludeButtonSelected);
        }
        this.fOriginalUseHonourAllButtonSelected = this.getBooleanPreference("honourAllSchemaLocations", true, contexts);
        if (this.fHonourAllSchemaLocations != null) {
            this.fHonourAllSchemaLocations.setSelection(this.fOriginalUseHonourAllButtonSelected);
        }
        if (this.fResolveExternalEntities != null) {
            this.fOriginalUseResolveExternalEntities = InstanceScope.INSTANCE.getNode(this.getPreferenceNodeQualifier()).getBoolean("resolveExternalEntities", false);
            this.fResolveExternalEntities.setSelection(this.fOriginalUseResolveExternalEntities);
        }
    }

    private boolean getBooleanPreference(String key, boolean defaultValue, IScopeContext[] contexts) {
        return Platform.getPreferencesService().getBoolean(this.getPreferenceNodeQualifier(), key, defaultValue, contexts);
    }

    private void handleMarkupSeveritySelection(boolean selection) {
        if (selection) {
            if (this.fMarkupState != null) {
                this.fMarkupState.restore();
                this.fMarkupState = null;
            }
        } else if (this.fMarkupState == null) {
            this.fMarkupState = ControlEnableState.disable((Control)this.fMarkupValidationGroup);
        }
    }

    protected void createContentsForMarkupValidationGroup(Composite parent) {
        IScopeContext[] contexts = this.createPreferenceScopes();
        this.fOriginalUseExtendedMarkupValidation = this.getBooleanPreference("markupValidation", false, contexts);
        this.fExtendedMarkupValidation = this.createCheckBox(parent, XMLUIMessages.MarkupValidation_files);
        ((GridData)this.fExtendedMarkupValidation.getLayoutData()).horizontalSpan = 2;
        this.fExtendedMarkupValidation.setSelection(this.fOriginalUseExtendedMarkupValidation);
        this.fExtendedMarkupValidation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLValidatorPreferencePage.this.handleMarkupSeveritySelection(XMLValidatorPreferencePage.this.fExtendedMarkupValidation.getSelection());
            }
        });
        this.fMarkupValidationGroup = this.createGroup(parent, 3);
        ((GridLayout)this.fMarkupValidationGroup.getLayout()).makeColumnsEqualWidth = false;
        this.fMarkupValidationGroup.setText(XMLUIMessages.MarkupValidation_files_label);
        GridLayout layout = new GridLayout(3, false);
        this.fMarkupValidationGroup.setLayout((Layout)layout);
        if (this.fMissingStartTag == null) {
            this.fMissingStartTag = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_start_tag, "missingStartTag", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fMissingEndTag == null) {
            this.fMissingEndTag = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_end_tag, "missingEndTag", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fMissingTagName == null) {
            this.fMissingTagName = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Tag_name_missing, "missingTagName", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fMissingQuotes == null) {
            this.fMissingQuotes = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_quotes, "missingQuotes", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fMissingClosingBracket == null) {
            this.fMissingClosingBracket = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_closing_bracket, "missingClosingBracket", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fMissingClosingQuote == null) {
            this.fMissingClosingQuote = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Missing_closing_quote, "missingClosingQuote", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fEmptyElementTag == null) {
            this.fEmptyElementTag = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Empty_element_tag, "attributeHasNoValue", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fEndTagWithAttributes == null) {
            this.fEndTagWithAttributes = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.End_tag_with_attributes, "endTagWithAttributes", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fInvalidWhitespaceBeforeTagname == null) {
            this.fInvalidWhitespaceBeforeTagname = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Invalid_whitespace_before_tagname, "whitespaceBeforeTagName", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fInvalidNamespaceInPI == null) {
            this.fInvalidNamespaceInPI = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Namespace_in_pi_target, "namespaceInPITarget", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        if (this.fInvalidWhitespaceAtStart == null) {
            this.fInvalidWhitespaceAtStart = this.addComboBox((Composite)this.fMarkupValidationGroup, XMLUIMessages.Whitespace_at_start, "whitespaceAtStart", XML_SEVERITIES, MARKUP_SEVERITIES, 0);
        }
        this.handleMarkupSeveritySelection(this.fOriginalUseExtendedMarkupValidation);
    }

    protected void performDefaultsForValidatingGroup() {
        IEclipsePreferences modelPreferences = DefaultScope.INSTANCE.getNode(this.getPreferenceNodeQualifier());
        boolean useXIncludeButtonSelected = modelPreferences.getBoolean("xinclude", false);
        if (this.fUseXinclude != null) {
            this.fUseXinclude.setSelection(useXIncludeButtonSelected);
        }
        boolean useHonourAllButtonSelected = modelPreferences.getBoolean("honourAllSchemaLocations", true);
        if (this.fHonourAllSchemaLocations != null) {
            this.fHonourAllSchemaLocations.setSelection(useHonourAllButtonSelected);
        }
        if (this.fResolveExternalEntities != null) {
            this.fResolveExternalEntities.setSelection(DefaultScope.INSTANCE.getNode(this.getPreferenceNodeQualifier()).getBoolean("resolveExternalEntities", false));
        }
    }

    protected void performDefaultsForMarkupValidationGroup() {
        IEclipsePreferences modelPreferences = new DefaultScope().getNode(this.getPreferenceNodeQualifier());
        boolean useExtendedMarkupValidation = modelPreferences.getBoolean("markupValidation", false);
        if (this.fExtendedMarkupValidation != null) {
            if (this.fExtendedMarkupValidation.getSelection() != useExtendedMarkupValidation) {
                this.handleMarkupSeveritySelection(useExtendedMarkupValidation);
            }
            this.fExtendedMarkupValidation.setSelection(useExtendedMarkupValidation);
        }
    }

    protected void storeValuesForValidatingGroup(IScopeContext[] contexts) {
        if (this.fUseXinclude != null) {
            boolean useXIncludeButtonSelected = this.fUseXinclude.getSelection();
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("xinclude", useXIncludeButtonSelected);
        }
        if (this.fHonourAllSchemaLocations != null) {
            boolean honourAllButtonSelected = this.fHonourAllSchemaLocations.getSelection();
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("honourAllSchemaLocations", honourAllButtonSelected);
        }
        if (this.getProject() == null && this.fResolveExternalEntities != null) {
            InstanceScope.INSTANCE.getNode(this.getPreferenceNodeQualifier()).putBoolean("resolveExternalEntities", this.fResolveExternalEntities.getSelection());
        }
    }

    protected void storeValuesForMarkupValidationGroup(IScopeContext[] contexts) {
        if (this.fExtendedMarkupValidation != null) {
            boolean extendedMarkupValidation = this.fExtendedMarkupValidation.getSelection();
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putBoolean("markupValidation", extendedMarkupValidation);
        }
    }

    protected void performDefaults() {
        this.resetSeverities();
        this.performDefaultsForValidatingGroup();
        this.performDefaultsForMarkupValidationGroup();
        super.performDefaults();
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void doSavePreferenceStore() {
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    protected void storeValues() {
        super.storeValues();
        IScopeContext[] contexts = this.createPreferenceScopes();
        this.storeValuesForValidatingGroup(contexts);
        this.storeValuesForMarkupValidationGroup(contexts);
    }

    protected Control createCommonContents(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        page.setLayout((Layout)layout);
        Group validatingGroup = this.createGroup(page, 3);
        validatingGroup.setText(XMLUIMessages.Validating_files);
        this.createContentsForValidatingGroup((Composite)validatingGroup);
        this.createContentsForMarkupValidationGroup(page);
        return page;
    }

    protected String getPreferenceNodeQualifier() {
        return XMLCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    protected String getPreferencePageID() {
        return "org.eclipse.wst.sse.ui.preferences.xml.validation";
    }

    protected String getProjectSettingsKey() {
        return "use-project-settings";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.wst.xml.ui.propertyPage.project.validation";
    }

    public void init(IWorkbench workbench) {
    }

    private Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    private Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public void dispose() {
        this.storeSectionExpansionStates(this.getDialogSettings().addNewSection(SETTINGS_SECTION_NAME));
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        return XMLUIPlugin.getDefault().getDialogSettings();
    }

    protected boolean shouldRevalidateOnSettingsChange() {
        return this.fOriginalUseExtendedMarkupValidation != this.fExtendedMarkupValidation.getSelection() || this.fOriginalUseXIncludeButtonSelected != this.fUseXinclude.getSelection() || this.fOriginalUseHonourAllButtonSelected != this.fHonourAllSchemaLocations.getSelection() || this.fResolveExternalEntities != null && this.fOriginalUseResolveExternalEntities != this.fResolveExternalEntities.getSelection() || super.shouldRevalidateOnSettingsChange();
    }
}

