/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.css;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientCanvas;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class GradientCanvasElement
extends CompositeElement {
    private final GradientCanvasData gradientCanvasData;

    public GradientCanvasElement(GradientCanvas gradientCanvas, CSSEngine engine) {
        super((Composite)gradientCanvas, engine);
        this.gradientCanvasData = GradientCanvasAccess.read(gradientCanvas);
    }

    protected GradientCanvas getComposite() {
        return (GradientCanvas)super.getComposite();
    }

    protected GradientCanvas getControl() {
        return (GradientCanvas)super.getControl();
    }

    public void reset() {
        GradientCanvas canvas = this.getControl();
        GradientCanvasAccess.restore(canvas, this.gradientCanvasData);
        super.reset();
    }

    private static class GradientCanvasAccess {
        private static final String[] COLOR_KEYS = new String[]{"baseBg", GradientCanvas.H_BOTTOM_KEYLINE1, GradientCanvas.H_BOTTOM_KEYLINE2};
        private static final String FIELD_NAME_VERTICAL = "vertical";
        private static final String FIELD_NAME_PERCENTS = "percents";
        private static final String FIELD_NAME_GRADIENT_COLORS = "gradientColors";
        private static final String FIELD_NAME_GRADIENT_INFO = "gradientInfo";
        private static final boolean ENABLED;
        private static final Field FIELD_GRADIENT_INFO;
        private static final Field FIELD_GRADIENT_COLORS;
        private static final Field FIELD_PERCENTS;
        private static final Field FIELD_VERTICAL;

        static {
            Field f_gradientInfo = null;
            Field f_gradientColors = null;
            Field f_percents = null;
            Field f_vertical = null;
            boolean enabled = false;
            try {
                f_gradientInfo = GradientCanvas.class.getDeclaredField(FIELD_NAME_GRADIENT_INFO);
                f_gradientInfo.setAccessible(true);
                Class<?> c_gradientInfo = f_gradientInfo.getType();
                f_gradientColors = c_gradientInfo.getDeclaredField(FIELD_NAME_GRADIENT_COLORS);
                f_gradientColors.setAccessible(true);
                f_percents = c_gradientInfo.getDeclaredField(FIELD_NAME_PERCENTS);
                f_percents.setAccessible(true);
                f_vertical = c_gradientInfo.getDeclaredField(FIELD_NAME_VERTICAL);
                f_vertical.setAccessible(true);
                enabled = true;
            }
            catch (Exception ex) {
                Bundle bundle = FrameworkUtil.getBundle(GradientCanvasElement.class);
                Platform.getLog((Bundle)bundle).log((IStatus)new Status(1, bundle.getSymbolicName(), "Dynamic theming for GradientCanvas is limited", (Throwable)ex));
            }
            if (enabled) {
                FIELD_GRADIENT_INFO = f_gradientInfo;
                FIELD_GRADIENT_COLORS = f_gradientColors;
                FIELD_PERCENTS = f_percents;
                FIELD_VERTICAL = f_vertical;
            } else {
                FIELD_GRADIENT_INFO = null;
                FIELD_GRADIENT_COLORS = null;
                FIELD_PERCENTS = null;
                FIELD_VERTICAL = null;
            }
            ENABLED = enabled;
        }

        private GradientCanvasAccess() {
        }

        static GradientCanvasData read(GradientCanvas gradientCanvas) {
            if (!ENABLED) {
                return null;
            }
            GradientCanvasData data = new GradientCanvasData();
            try {
                Object gradientInfo = FIELD_GRADIENT_INFO.get(gradientCanvas);
                if (gradientInfo != null) {
                    data.gradientColors = (Color[])GradientCanvasAccess.FIELD_GRADIENT_COLORS.get(gradientInfo);
                    data.gradientPercent = (int[])GradientCanvasAccess.FIELD_PERCENTS.get(gradientInfo);
                    data.vertical = !Boolean.FALSE.equals(GradientCanvasAccess.FIELD_VERTICAL.get(gradientInfo));
                }
            }
            catch (Exception ex) {
                return null;
            }
            data.colors = new HashMap();
            String[] stringArray = COLOR_KEYS;
            int n = COLOR_KEYS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (gradientCanvas.hasColor(key)) {
                    data.colors.put(key, gradientCanvas.getColor(key));
                }
                ++n2;
            }
            return data;
        }

        static void restore(GradientCanvas canvas, GradientCanvasData data) {
            if (data == null) {
                return;
            }
            String[] stringArray = COLOR_KEYS;
            int n = COLOR_KEYS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                canvas.putColor(key, (Color)data.colors.get(key));
                ++n2;
            }
            if (data.gradientColors == null) {
                canvas.setBackgroundGradient(null, null, true);
            } else {
                canvas.setBackgroundGradient(data.gradientColors, data.gradientPercent, data.vertical);
            }
        }
    }

    private static class GradientCanvasData {
        private Color[] gradientColors;
        private int[] gradientPercent;
        private boolean vertical;
        private Map<String, Color> colors;

        private GradientCanvasData() {
        }
    }
}

