/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
const yamlParser07_1 = require("../parser/yamlParser07");
const jsonDocumentSymbols_1 = require("vscode-json-languageservice/lib/umd/services/jsonDocumentSymbols");
class YAMLDocumentSymbols {
    constructor(schemaService) {
        this.jsonDocumentSymbols = new jsonDocumentSymbols_1.JSONDocumentSymbols(schemaService);
    }
    findDocumentSymbols(document) {
        const doc = yamlParser07_1.parse(document.getText());
        if (!doc || doc['documents'].length === 0) {
            return null;
        }
        let results = [];
        for (const yamlDoc of doc['documents']) {
            if (yamlDoc.root) {
                results = results.concat(this.jsonDocumentSymbols.findDocumentSymbols(document, yamlDoc));
            }
        }
        return results;
    }
    findHierarchicalDocumentSymbols(document) {
        const doc = yamlParser07_1.parse(document.getText());
        if (!doc || doc['documents'].length === 0) {
            return null;
        }
        let results = [];
        for (const yamlDoc of doc['documents']) {
            if (yamlDoc.root) {
                results = results.concat(this.jsonDocumentSymbols.findDocumentSymbols2(document, yamlDoc));
            }
        }
        return results;
    }
}
exports.YAMLDocumentSymbols = YAMLDocumentSymbols;
//# sourceMappingURL=documentSymbols.js.map