/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.generalization;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.generalization.GeneralizeTypedElement;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="generalizeReference", label="Generalize Reference", description="In the metamodel, either the type or the multiplicity of a reference is generalized. In the model, nothing is changed.")
public class GeneralizeReference
extends GeneralizeTypedElement {
    @EdaptParameter(main=true, description="The reference to be generalized")
    public EReference reference;
    @EdaptParameter(description="The new type of the reference")
    public EClass type;

    protected EStructuralFeature getTypedElement() {
        return this.reference;
    }

    @EdaptConstraint(restricts="type", description="The type must be the same or more general")
    public boolean checkType(EClass type) {
        EClass referenceType = this.reference.getEReferenceType();
        return type.isSuperTypeOf(referenceType);
    }

    public void initialize(Metamodel metamodel) {
        super.initialize(metamodel);
        this.type = this.reference.getEReferenceType();
    }

    public void execute(Metamodel metamodel, Model model) {
        if (this.reference.getEType() != this.type) {
            this.reference.setEType((EClassifier)this.type);
            if (this.reference.getEOpposite() != null) {
                this.type.getEStructuralFeatures().add((Object)this.reference.getEOpposite());
            }
        }
        super.execute(metamodel, model);
    }
}

