/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.generators;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.edt.compiler.internal.util.Encoder;
import org.eclipse.edt.gen.deployment.util.CommonUtilities;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.Parameter;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;

public class DeploymentDescUtil {
    private static final String indent1 = "    ";
    private static final String indent2 = "        ";
    private static final String indent3 = "            ";
    private static final String indent4 = "                ";

    public static String convertToBindXML(DeploymentDesc desc, IProject targetProject) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<egldd>\n");
        buf.append(indent1);
        buf.append("<bindings>\n");
        for (Binding binding : desc.getBindings()) {
            buf.append(DeploymentDescUtil.toBindXML(binding, targetProject));
        }
        buf.append(indent1);
        buf.append("</bindings>\n");
        buf.append(indent1);
        buf.append("<includes>\n");
        for (String include : desc.getIncludes()) {
            buf.append(DeploymentDescUtil.toIncludeXML(include));
        }
        buf.append(indent1);
        buf.append("</includes>\n");
        buf.append("</egldd>\n");
        return buf.toString();
    }

    public static String toBindXML(Binding binding, IProject targetProject) {
        binding = DeploymentDescUtil.tweakBinding(binding, targetProject);
        StringBuilder builder = new StringBuilder(indent2);
        builder.append("<binding name=\"");
        if (binding.getName() != null) {
            builder.append(binding.getName());
        }
        builder.append("\"");
        if (binding.getType() != null) {
            builder.append(" type=\"").append(binding.getType());
            builder.append("\"");
        }
        if (binding.getUri() != null) {
            builder.append(" uri=\"").append(binding.getUri());
            builder.append("\"");
        }
        builder.append(" useURI=\"").append(String.valueOf(binding.isUseURI()));
        builder.append("\">\n");
        Collection parms = binding.getParameters();
        if (parms.size() > 0) {
            builder.append(indent3);
            builder.append("<parameters>\n");
            for (Parameter parameter : parms) {
                builder.append(DeploymentDescUtil.toBindXML(parameter));
            }
            builder.append(indent3);
            builder.append("</parameters>\n");
        }
        builder.append(indent2);
        builder.append("</binding>\n");
        return builder.toString();
    }

    public static String toBindXML(Parameter parameter) {
        StringBuilder builder = new StringBuilder(indent4);
        builder.append("<parameter name=\"");
        if (parameter.getName() != null) {
            builder.append(parameter.getName());
        }
        builder.append("\"");
        if (parameter.getType() != null) {
            builder.append(" type=\"");
            builder.append(parameter.getType());
            builder.append("\"");
        }
        if (parameter.getValue() != null) {
            builder.append(" value=\"").append(parameter.getValue());
            builder.append("\"");
        }
        builder.append("/>\n");
        return builder.toString();
    }

    public static String toIncludeXML(String include) {
        StringBuilder builder = new StringBuilder(indent2);
        builder.append("<include location=\"");
        builder.append(String.valueOf(CommonUtilities.toIncludeDDName((String)include)) + "\"");
        builder.append("/>\n");
        return builder.toString();
    }

    private static Binding tweakBinding(Binding binding, IProject targetProject) {
        if (binding instanceof SQLDatabaseBinding) {
            IConnectionProfile profile;
            SQLDatabaseBinding sqlBinding = (SQLDatabaseBinding)binding;
            String uri = sqlBinding.getUri();
            if (sqlBinding.isDeployAsJndi()) {
                if (!sqlBinding.isUseURI() || uri != null && uri.startsWith("workspace://")) {
                    String jndiName = sqlBinding.getJndiName();
                    if (jndiName == null || (jndiName = jndiName.trim()).length() == 0) {
                        jndiName = "jdbc/" + sqlBinding.getName();
                    }
                    SQLDatabaseBinding newBinding = new SQLDatabaseBinding((Binding)sqlBinding);
                    newBinding.setParameters(new HashMap());
                    newBinding.setUseURI(true);
                    newBinding.setUri("jndi://" + jndiName);
                    if (sqlBinding.isApplicationAuthentication()) {
                        String user = null;
                        String password = null;
                        if (!sqlBinding.isUseURI()) {
                            user = sqlBinding.getSqlID();
                            password = sqlBinding.getSqlPassword();
                        } else {
                            IConnectionProfile profile2 = ProfileManager.getInstance().getProfileByName(uri.substring(12));
                            if (profile2 != null) {
                                user = EGLSQLUtility.getSQLUserId((IConnectionProfile)profile2);
                                password = Encoder.encode((String)EGLSQLUtility.getSQLPassword((IConnectionProfile)profile2));
                            }
                        }
                        if (user != null && (user = user.trim()).length() > 0) {
                            newBinding.addParameter(new Parameter("sqlID", user));
                        }
                        if (password != null && (password = password.trim()).length() > 0) {
                            newBinding.addParameter(new Parameter("sqlPassword", password));
                        }
                    }
                    return newBinding;
                }
            } else if (sqlBinding.isUseURI() && uri != null && uri.trim().startsWith("workspace://") && (profile = ProfileManager.getInstance().getProfileByName(uri.substring(12))) != null) {
                SQLDatabaseBinding newBinding = new SQLDatabaseBinding((Binding)sqlBinding);
                newBinding.setParameters(new HashMap());
                newBinding.setUseURI(false);
                newBinding.addParameter(new Parameter("dbms", String.valueOf(EGLSQLUtility.getSQLVendorProperty((IConnectionProfile)profile)) + " " + EGLSQLUtility.getSQLProductVersion((IConnectionProfile)profile)));
                newBinding.addParameter(new Parameter("sqlJDBCDriverClass", EGLSQLUtility.getSQLJDBCDriverClassPreference((IConnectionProfile)profile)));
                newBinding.addParameter(new Parameter("jarList", EGLSQLUtility.getLoadingPath((IConnectionProfile)profile)));
                newBinding.addParameter(new Parameter("sqlID", EGLSQLUtility.getSQLUserId((IConnectionProfile)profile)));
                String password = EGLSQLUtility.getSQLPassword((IConnectionProfile)profile);
                newBinding.addParameter(new Parameter("sqlPassword", Encoder.encode((String)password)));
                newBinding.addParameter(new Parameter("sqlDB", EGLSQLUtility.getSQLConnectionURLPreference((IConnectionProfile)profile)));
                newBinding.addParameter(new Parameter("sqlSchema", EGLSQLUtility.getDefaultSchema((IConnectionProfile)profile)));
                return newBinding;
            }
        }
        return binding;
    }
}

