/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.BinaryElementParser;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.BufferManager;
import org.eclipse.edt.ide.core.internal.model.ClassFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.EGLModelStatus;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragment;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.IRFileStructureRequestor;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageDeclaration;
import org.eclipse.edt.ide.core.internal.model.PackageFragment;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.SourceMapper;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBuffer;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IProblemRequestor;
import org.eclipse.edt.ide.core.model.ISourceRange;

public class ClassFile
extends Openable
implements IClassFile,
IDocument {
    protected BinaryPart binaryPart = null;
    protected String name;
    protected IProject project;
    public static boolean SHARED_WC_VERBOSE = false;
    private boolean sourceFileSearchRequired = true;

    protected ClassFile(IEGLElement parent, String nameWithoutExtension) {
        super(7, parent, nameWithoutExtension);
        this.name = nameWithoutExtension;
    }

    @Override
    protected void buildStructure(OpenableElementInfo info, IProgressMonitor monitor) throws EGLModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        EGLModelManager.getEGLModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        for (IEGLElement key : newElements.keySet()) {
            Object value = newElements.get(key);
            EGLModelManager.getEGLModelManager().putInfo(key, value);
        }
        EGLModelManager.getEGLModelManager().putInfo(this, info);
    }

    @Override
    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws EGLModelException {
        EGLModelManager.getEGLModelManager().putInfo(this, info);
        ClassFileElementInfo unitInfo = (ClassFileElementInfo)info;
        IRFileStructureRequestor requestor = new IRFileStructureRequestor(this, unitInfo, newElements);
        BinaryElementParser parser = new BinaryElementParser(requestor, this.project);
        parser.parseDocument(this, true);
        return unitInfo.isStructureKnown();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '(';
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    @Override
    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            this.project = root.getParent().getEGLProject().getProject();
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile((IPath)new Path(this.getElementName()));
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return null;
    }

    @Override
    public IPart[] getAllParts() throws EGLModelException {
        return this.getParts();
    }

    @Override
    public byte[] getBytes() throws EGLModelException {
        EGLElement pkg = (EGLElement)this.getParent();
        if (pkg instanceof EglarPackageFragment) {
            EglarPackageFragmentRoot root = (EglarPackageFragmentRoot)pkg.getParent();
            ZipFile zip = null;
            try {
                zip = root.getJar();
                String entryName = CharOperation.concatWith((String[])((PackageFragment)pkg).names, (String)this.getElementName(), (char)'/');
                ZipEntry ze = zip.getEntry(entryName);
                if (ze != null) {
                    byte[] byArray = org.eclipse.edt.ide.core.internal.model.util.Util.getZipEntryByteContent(ze, zip);
                    return byArray;
                }
                try {
                    throw new EGLModelException(new EGLModelStatus(969, this));
                }
                catch (IOException ioe) {
                    throw new EGLModelException(ioe, 985);
                }
                catch (CoreException e) {
                    if (e instanceof EGLModelException) {
                        throw (EGLModelException)e;
                    }
                    throw new EGLModelException(e);
                }
            }
            finally {
                EGLModelManager.getEGLModelManager().closeZipFile(zip);
            }
        }
        IFile file = (IFile)this.getResource();
        return Util.getResourceContentsAsByteArray(file);
    }

    @Override
    public IEGLElement getElementAt(int position) throws EGLModelException {
        return null;
    }

    @Override
    public IPackageDeclaration getPackageDeclaration(String name) {
        return new PackageDeclaration(this, name);
    }

    @Override
    public IPackageDeclaration[] getPackageDeclarations() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(12);
        IPackageDeclaration[] array = new IPackageDeclaration[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getPackageName() {
        IPackageFragment packageFragment = (IPackageFragment)this.getAncestor(4);
        String[] packageName = packageFragment.isDefaultPackage() ? new String[]{} : packageFragment.getElementName().split("\\.");
        return packageName;
    }

    @Override
    public IPart getPart(String name) {
        this.binaryPart = new BinaryPart(this, name);
        return this.binaryPart;
    }

    @Override
    public IPart[] getParts() throws EGLModelException {
        ArrayList list = this.getChildrenOfType(8);
        IPart[] array = new IPart[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public String getElementName() {
        return String.valueOf(this.name) + ".eglxml";
    }

    @Override
    public boolean isClass() throws EGLModelException {
        return true;
    }

    @Override
    public String getSource() throws EGLModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    @Override
    public ISourceRange getSourceRange() throws EGLModelException {
        return ((EGLFileElementInfo)this.getElementInfo()).getSourceRange();
    }

    @Override
    public void copy(IEGLElement container, IEGLElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws EGLModelException {
        throw new EGLModelException(new EGLModelStatus(976, this));
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws EGLModelException {
        throw new EGLModelException(new EGLModelStatus(976, this));
    }

    @Override
    public void move(IEGLElement container, IEGLElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws EGLModelException {
        throw new EGLModelException(new EGLModelStatus(976, this));
    }

    @Override
    public void rename(String name, boolean replace, IProgressMonitor monitor) throws EGLModelException {
        throw new EGLModelException(new EGLModelStatus(976, this));
    }

    @Override
    public void commit(boolean force, IProgressMonitor monitor) throws EGLModelException {
        throw new EGLModelException(new EGLModelStatus(976, this));
    }

    @Override
    public void destroy() {
    }

    @Override
    public IEGLElement[] findElements(IEGLElement element) {
        return null;
    }

    @Override
    public IPart findPrimaryPart() {
        return null;
    }

    @Override
    public IEGLElement findSharedWorkingCopy(IBufferFactory bufferFactory) {
        return null;
    }

    @Override
    public IEGLElement getOriginal(IEGLElement workingCopyElement) {
        return null;
    }

    @Override
    public IEGLElement getOriginalElement() {
        return null;
    }

    @Override
    public IEGLElement getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor problemRequestor) throws EGLModelException {
        return null;
    }

    @Override
    public IEGLElement getWorkingCopy() throws EGLModelException {
        return null;
    }

    @Override
    public IEGLElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor problemRequestor) throws EGLModelException {
        return null;
    }

    @Override
    public boolean isBasedOn(IResource resource) {
        return false;
    }

    @Override
    public boolean isWorkingCopy() {
        return false;
    }

    @Override
    public IMarker[] reconcile() throws EGLModelException {
        return null;
    }

    @Override
    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws EGLModelException {
    }

    @Override
    public void restore() throws EGLModelException {
    }

    @Override
    public byte[] getByteContent() throws IOException {
        try {
            return this.getBytes();
        }
        catch (EGLModelException eGLModelException) {
            return null;
        }
    }

    @Override
    public char[] getCharContent() throws IOException {
        return null;
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getStringContent() throws IOException {
        return null;
    }

    @Override
    public String getType() {
        return "eglxml";
    }

    @Override
    public IPart getPart() {
        try {
            IPart[] parts = this.getAllParts();
            if (parts.length > 0) {
                return parts[0];
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getTypeName() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.getFileName().toString();
    }

    public char[] getFileName() {
        return this.getElementName().toCharArray();
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new ClassFileElementInfo();
    }

    @Override
    public IClassFile getClassFile() {
        return this;
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) {
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer == null) {
            ClassFileElementInfo classFileInfo;
            SourceMapper mapper = this.getSourceMapper();
            ClassFileElementInfo classFileElementInfo = classFileInfo = info instanceof ClassFileElementInfo ? (ClassFileElementInfo)info : null;
            if (mapper != null) {
                buffer = this.mapSource(mapper, classFileInfo, this.getClassFile());
            }
        }
        return buffer;
    }

    private IBuffer mapSource(SourceMapper mapper, ClassFileElementInfo info, IClassFile bufferOwner) {
        char[] contents = mapper.findSource(this.getPart(), info.getEglFileName(), info.getCaseSensitivePackageName());
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = bufManager.createBuffer(bufferOwner);
        if (buffer == null) {
            return null;
        }
        bufManager.addBuffer(buffer);
        if (contents != null) {
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
        } else if (buffer.getCharacters() == null) {
            String result = EGLModelResources.eglarNoSourceAttachmentContent;
            buffer.setContents(result.toCharArray());
        }
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    public SourceMapper getSourceMapper() {
        IPath projPath;
        if (this.sourceFileSearchRequired && ResourcesPlugin.getWorkspace().getRoot().findMember(this.getPath()) != null && org.eclipse.edt.ide.core.internal.model.util.Util.isBinaryProject(new File((projPath = this.getEGLProject().getProject().getLocation()).toString()))) {
            String[] eglSourceFolders;
            String[] stringArray = eglSourceFolders = org.eclipse.edt.ide.core.internal.model.util.Util.getEGLSourceFolders(new File(this.getEGLProject().getProject().getLocation().toString()));
            int n = eglSourceFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String eglSourceFolder = stringArray[n2];
                IResource sourceFolder = this.getEGLProject().getProject().findMember(eglSourceFolder);
                if (sourceFolder != null && sourceFolder.exists() && sourceFolder.getType() == 2) {
                    try {
                        String pkgPath = this.getPackageDeclarations()[0].getElementName();
                        pkgPath = pkgPath.replace(".", File.separator);
                        IResource fullPkgFolder = ((IFolder)sourceFolder).findMember(pkgPath);
                        if (fullPkgFolder != null && fullPkgFolder.exists() && fullPkgFolder.getType() == 2) {
                            ClassFileElementInfo elementInfo = (ClassFileElementInfo)this.getElementInfo();
                            String srcName = elementInfo.getEglFileName();
                            IResource sourceFile = ((IFolder)fullPkgFolder).findMember(srcName);
                            if (sourceFile == null) {
                                Path path = new Path(srcName);
                                srcName = path.lastSegment();
                                sourceFile = ((IFolder)fullPkgFolder).findMember(srcName);
                            }
                            if (sourceFile != null && sourceFile.exists() && sourceFile.getType() == 1) {
                                return new SourceMapper(sourceFile.getFullPath(), null, this.getEGLProject().getOptions(true));
                            }
                        }
                    }
                    catch (EGLModelException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(this.getPath()) == null) {
            String eglarPath = this.getPath().toString();
            IEGLProject eglProj = this.getEGLProject();
            boolean isInBinaryProj = false;
            try {
                IEGLPathEntry[] pathEntries;
                IEGLPathEntry[] iEGLPathEntryArray = pathEntries = eglProj.getResolvedEGLPath(true);
                int sourceFolder = pathEntries.length;
                int n = 0;
                while (n < sourceFolder) {
                    IEGLPathEntry entry = iEGLPathEntryArray[n];
                    if (entry.isBinaryProject() && entry.getPath().equals((Object)this.getPath())) {
                        isInBinaryProj = true;
                        break;
                    }
                    ++n;
                }
            }
            catch (EGLModelException e1) {
                e1.printStackTrace();
            }
            if (isInBinaryProj && Util.isEGLARFileName(eglarPath)) {
                int index = eglarPath.lastIndexOf("/");
                if (index == -1) {
                    index = eglarPath.lastIndexOf(File.separator);
                }
                if (index != -1) {
                    String[] eglSourceFolders;
                    String projRootPath = eglarPath.substring(0, index);
                    String[] stringArray = eglSourceFolders = org.eclipse.edt.ide.core.internal.model.util.Util.getEGLSourceFolders(new File(projRootPath));
                    int n = eglSourceFolders.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String eglSourceFolder = stringArray[n3];
                        String sourcePath = String.valueOf(projRootPath) + File.separator + eglSourceFolder;
                        try {
                            String pkgPath = this.getPackageDeclarations()[0].getElementName();
                            index = pkgPath.indexOf(".");
                            while (index != -1) {
                                sourcePath = String.valueOf(sourcePath) + File.separator + pkgPath.substring(0, index);
                                pkgPath = pkgPath.substring(index + 1);
                                index = pkgPath.indexOf(".");
                            }
                            sourcePath = String.valueOf(sourcePath) + File.separator + pkgPath;
                            String srcName = ((ClassFileElementInfo)this.getElementInfo()).getEglFileName();
                            if (pkgPath.trim().length() > 0) {
                                sourcePath = String.valueOf(sourcePath) + File.separator;
                            }
                            sourcePath = String.valueOf(sourcePath) + srcName;
                            return new SourceMapper((IPath)new Path(sourcePath), null, this.getEGLProject().getOptions(true));
                        }
                        catch (EGLModelException e) {
                            e.printStackTrace();
                            ++n3;
                        }
                    }
                }
            }
        }
        return super.getSourceMapper();
    }

    public IFile getFileInSourceFolder() {
        String[] eglSourceFolders;
        String[] stringArray = eglSourceFolders = org.eclipse.edt.ide.core.internal.model.util.Util.getEGLSourceFolders(new File(this.getEGLProject().getProject().getLocation().toString()));
        int n = eglSourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String eglSourceFolder = stringArray[n2];
            IResource sourceFolder = this.getEGLProject().getProject().findMember(eglSourceFolder);
            if (sourceFolder != null && sourceFolder.exists() && sourceFolder.getType() == 2) {
                String pkgPath = "";
                IResource fullPkgFolder = null;
                try {
                    ClassFileElementInfo elementInfo = (ClassFileElementInfo)this.getElementInfo();
                    String[] pkgs = elementInfo.getCaseSensitivePackageName();
                    if (pkgs != null && pkgs.length > 0) {
                        int i = 0;
                        while (i < pkgs.length - 1) {
                            pkgPath = String.valueOf(pkgPath) + pkgs[i];
                            pkgPath = String.valueOf(pkgPath) + File.separator;
                            ++i;
                        }
                        pkgPath = String.valueOf(pkgPath) + pkgs[pkgs.length - 1];
                        fullPkgFolder = ((IFolder)sourceFolder).findMember(pkgPath);
                    } else {
                        fullPkgFolder = sourceFolder;
                    }
                    if (fullPkgFolder != null && fullPkgFolder.exists() && fullPkgFolder.getType() == 2) {
                        IResource sourceFile;
                        String srcName = elementInfo.getEglFileName();
                        int index = srcName.lastIndexOf("/");
                        if (index != -1) {
                            srcName = srcName.substring(index);
                        }
                        if ((sourceFile = ((IFolder)fullPkgFolder).findMember(srcName)) != null && sourceFile.exists() && sourceFile.getType() == 1) {
                            return (IFile)sourceFile;
                        }
                    }
                }
                catch (EGLModelException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    public void setSourceFileSearchRequired(boolean sourceFileSearchRequired) {
        this.sourceFileSearchRequired = sourceFileSearchRequired;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        if (!(this.getParent() instanceof EglarPackageFragment)) return super.exists();
        try {
            IClassFile[] classes;
            IClassFile[] iClassFileArray = classes = ((EglarPackageFragment)this.getParent()).getClassFiles();
            int n = classes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClassFile next = iClassFileArray[n2];
                if (next == this) {
                    return true;
                }
                ++n2;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return false;
    }
}

