/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.CopyPackageFragmentRootOperation;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class MovePackageFragmentRootOperation
extends CopyPackageFragmentRootOperation {
    protected void renameEntryInClasspath(IPath rootPath, IEGLProject project) throws EGLModelException {
        IEGLPathEntry[] classpath = project.getRawEGLPath();
        IEGLPathEntry[] newClasspath = null;
        int cpLength = classpath.length;
        int newCPIndex = -1;
        int i = 0;
        while (i < cpLength) {
            IEGLPathEntry entry = classpath[i];
            IPath entryPath = entry.getPath();
            if (rootPath.equals((Object)entryPath)) {
                if (newClasspath == null) {
                    newClasspath = new IEGLPathEntry[cpLength];
                    System.arraycopy(classpath, 0, newClasspath, 0, i);
                    newCPIndex = i;
                }
                newClasspath[newCPIndex++] = this.copy(entry);
            } else if (this.destination.equals((Object)entryPath)) {
                if (newClasspath == null) {
                    newClasspath = new IEGLPathEntry[cpLength];
                    System.arraycopy(classpath, 0, newClasspath, 0, i);
                    newCPIndex = i;
                }
            } else if (newClasspath != null) {
                newClasspath[newCPIndex++] = entry;
            }
            ++i;
        }
        if (newClasspath != null) {
            if (newCPIndex < newClasspath.length) {
                IEGLPathEntry[] iEGLPathEntryArray = newClasspath;
                newClasspath = new IEGLPathEntry[newCPIndex];
                System.arraycopy(iEGLPathEntryArray, 0, newClasspath, 0, newCPIndex);
            }
            project.setRawEGLPath(newClasspath, this.fMonitor);
        }
    }

    public MovePackageFragmentRootOperation(IPackageFragmentRoot root, IPath destination, int updateResourceFlags, int updateModelFlags, IEGLPathEntry sibling) {
        super(root, destination, updateResourceFlags, updateModelFlags, sibling);
    }

    @Override
    protected void executeOperation() throws EGLModelException {
        boolean updateDestination;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        IEGLPathEntry rootEntry = root.getRawEGLPathEntry();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.moveResource(root, rootEntry, workspaceRoot);
        }
        IEGLProject originatingProject = root.getEGLProject();
        if ((this.updateModelFlags & 4) != 0) {
            this.updateReferringProjectClasspaths(rootEntry.getPath(), originatingProject);
        }
        boolean isRename = this.destination.segment(0).equals(originatingProject.getElementName());
        boolean updateOriginating = (this.updateModelFlags & 2) != 0;
        boolean bl = updateDestination = (this.updateModelFlags & 8) != 0;
        if (updateOriginating) {
            if (isRename && updateDestination) {
                this.renameEntryInClasspath(rootEntry.getPath(), originatingProject);
            } else {
                this.removeEntryFromClasspath(rootEntry.getPath(), originatingProject);
            }
        }
        if (!(!updateDestination || isRename && updateOriginating)) {
            this.addEntryToEGLPath(rootEntry, workspaceRoot);
        }
    }

    protected void moveResource(IPackageFragmentRoot root, IEGLPathEntry rootEntry, final IWorkspaceRoot workspaceRoot) throws EGLModelException {
        char[][] exclusionPatterns = ((EGLPathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (rootEntry.getEntryKind() != 3 || exclusionPatterns == null) {
            try {
                IResource destRes;
                if ((this.updateModelFlags & 0x10) != 0 && (destRes = workspaceRoot.findMember(this.destination)) != null) {
                    destRes.delete(this.updateResourceFlags, this.fMonitor);
                }
                rootResource.move(this.destination, this.updateResourceFlags, this.fMonitor);
            }
            catch (CoreException e) {
                throw new EGLModelException(e);
            }
        }
        final int sourceSegmentCount = rootEntry.getPath().segmentCount();
        final IFolder destFolder = workspaceRoot.getFolder(this.destination);
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource destRes;
                if (proxy.getType() == 2) {
                    IResource destRes2;
                    IPath path = proxy.requestFullPath();
                    if (MovePackageFragmentRootOperation.this.prefixesOneOf(path, nestedFolders)) {
                        if (MovePackageFragmentRootOperation.this.equalsOneOf(path, nestedFolders)) {
                            return false;
                        }
                        IFolder folder = destFolder.getFolder(path.removeFirstSegments(sourceSegmentCount));
                        if ((MovePackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && folder.exists()) {
                            return true;
                        }
                        folder.create(MovePackageFragmentRootOperation.this.updateResourceFlags, true, MovePackageFragmentRootOperation.this.fMonitor);
                        return true;
                    }
                    IPath destPath = MovePackageFragmentRootOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                    if ((MovePackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (destRes2 = workspaceRoot.findMember(destPath)) != null) {
                        destRes2.delete(MovePackageFragmentRootOperation.this.updateResourceFlags, MovePackageFragmentRootOperation.this.fMonitor);
                    }
                    proxy.requestResource().move(destPath, MovePackageFragmentRootOperation.this.updateResourceFlags, MovePackageFragmentRootOperation.this.fMonitor);
                    return false;
                }
                IPath path = proxy.requestFullPath();
                IPath destPath = MovePackageFragmentRootOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                if ((MovePackageFragmentRootOperation.this.updateModelFlags & 0x10) != 0 && (destRes = workspaceRoot.findMember(destPath)) != null) {
                    destRes.delete(MovePackageFragmentRootOperation.this.updateResourceFlags, MovePackageFragmentRootOperation.this.fMonitor);
                }
                proxy.requestResource().move(destPath, MovePackageFragmentRootOperation.this.updateResourceFlags, MovePackageFragmentRootOperation.this.fMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
        this.setAttribute("hasModifiedResource", "true");
    }

    protected void updateReferringProjectClasspaths(IPath rootPath, IEGLProject projectOfRoot) throws EGLModelException {
        IEGLModel model = this.getEGLModel();
        IEGLProject[] projects = model.getEGLProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IEGLProject project = projects[i];
            if (!project.equals(projectOfRoot)) {
                this.renameEntryInClasspath(rootPath, project);
            }
            ++i;
        }
    }

    protected void removeEntryFromClasspath(IPath rootPath, IEGLProject project) throws EGLModelException {
        IEGLPathEntry[] classpath = project.getRawEGLPath();
        IEGLPathEntry[] newClasspath = null;
        int cpLength = classpath.length;
        int newCPIndex = -1;
        int i = 0;
        while (i < cpLength) {
            IEGLPathEntry entry = classpath[i];
            if (rootPath.equals((Object)entry.getPath())) {
                if (newClasspath == null) {
                    newClasspath = new IEGLPathEntry[cpLength];
                    System.arraycopy(classpath, 0, newClasspath, 0, i);
                    newCPIndex = i;
                }
            } else if (newClasspath != null) {
                newClasspath[newCPIndex++] = entry;
            }
            ++i;
        }
        if (newClasspath != null) {
            if (newCPIndex < newClasspath.length) {
                IEGLPathEntry[] iEGLPathEntryArray = newClasspath;
                newClasspath = new IEGLPathEntry[newCPIndex];
                System.arraycopy(iEGLPathEntryArray, 0, newClasspath, 0, newCPIndex);
            }
            project.setRawEGLPath(newClasspath, this.fMonitor);
        }
    }
}

