/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.index.impl;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.index.impl.PropertyDocument;
import org.eclipse.edt.ide.core.internal.model.util.Util;
import org.eclipse.edt.ide.core.model.EGLCore;

public class IFileDocument
extends PropertyDocument {
    protected IFile file;
    protected char[] charContents;
    protected byte[] byteContents;

    public IFileDocument(IFile file) {
        this(file, (char[])null);
    }

    public IFileDocument(IFile file, byte[] byteContents) {
        this.file = file;
        this.byteContents = byteContents;
    }

    public IFileDocument(IFile file, char[] charContents) {
        this.file = file;
        this.charContents = charContents;
    }

    @Override
    public byte[] getByteContent() throws IOException {
        if (this.byteContents != null) {
            return this.byteContents;
        }
        IPath location = this.file.getLocation();
        if (location == null) {
            return new byte[0];
        }
        this.byteContents = Util.getFileByteContent(location.toFile());
        return this.byteContents;
    }

    @Override
    public char[] getCharContent() throws IOException {
        if (this.charContents != null) {
            return this.charContents;
        }
        IPath location = this.file.getLocation();
        if (location == null) {
            return CharOperation.NO_CHAR;
        }
        this.charContents = Util.getFileCharContent(location.toFile(), this.getEncoding());
        return this.charContents;
    }

    @Override
    public String getEncoding() {
        String encoding;
        try {
            encoding = this.file.getCharset();
        }
        catch (CoreException coreException) {
            encoding = EGLCore.create(this.file.getProject()).getOption(EGLCore.CORE_ENCODING, true);
        }
        return encoding;
    }

    @Override
    public String getName() {
        return this.file.getFullPath().toString();
    }

    @Override
    public String getStringContent() throws IOException {
        return new String(this.getCharContent());
    }

    @Override
    public String getType() {
        String extension = this.file.getFileExtension();
        if (extension == null) {
            return "";
        }
        return extension;
    }
}

