/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.CaseStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IfStatement;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.TryStatement;
import org.eclipse.edt.compiler.core.ast.WhileStatement;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.errors.EGLPartialParser;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.ParseStackEntry;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.core.internal.model.WorkingCopy;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocument;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.IReferenceCompletion;
import org.eclipse.edt.ide.ui.internal.editor.util.EGLModelUtility;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public abstract class EGLAbstractReferenceCompletion
implements IReferenceCompletion {
    private static EGLPartialParser parser = new EGLPartialParser();
    protected ArrayList validStates = new ArrayList();
    protected IEditorPart editor;

    protected EGLAbstractReferenceCompletion() {
        this.precompileContexts();
    }

    protected abstract void precompileContexts();

    protected void addContext(String prefix) {
        TokenStream stream = new TokenStream(prefix);
        ParseStack stack = parser.parse(stream);
        stack.performAllReductions(99);
        if (!this.validStates.contains(stack.getCurrentState())) {
            this.validStates.add(new Integer(stack.getCurrentState()));
        }
    }

    protected void addContext(int stateCode) {
        this.validStates.add(new Integer(stateCode));
    }

    protected abstract List returnCompletionProposals(ParseStack var1, String var2, ITextViewer var3, int var4);

    @Override
    public List computeCompletionProposals(ParseStack parseStack, String prefix, ITextViewer viewer, int documentOffset, IEditorPart editor) {
        this.editor = editor;
        IFileEditorInput cfr_ignored_0 = (IFileEditorInput)editor.getEditorInput();
        int parseState = parseStack.getCurrentState();
        for (Integer integer : this.validStates) {
            if (parseState != integer) continue;
            return this.returnCompletionProposals(parseStack, prefix, viewer, documentOffset);
        }
        return new ArrayList();
    }

    public boolean isState(ParseStack parseStack) {
        int parseState = parseStack.getCurrentState();
        for (Integer integer : this.validStates) {
            if (parseState != integer) continue;
            return true;
        }
        return false;
    }

    protected boolean isState(ParseStack parseStack, int stateToLookFor) {
        int i = parseStack.getStack().size() - 1;
        while (i >= 0) {
            ParseStackEntry entry = (ParseStackEntry)parseStack.getStack().get(i);
            if (entry.state == stateToLookFor) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected int getState(String prefix) {
        TokenStream stream = new TokenStream(prefix);
        ParseStack stack = new EGLPartialParser().parse(stream);
        stack.performAllReductions(99);
        return stack.getCurrentState();
    }

    protected boolean inBlock(ITextViewer viewer, int documentOffset) {
        Node node = ((IEGLDocument)viewer.getDocument()).getNewModelNodeAtOffset(documentOffset);
        while (node != null) {
            if (node instanceof Statement) {
                return ((Statement)node).canIncludeOtherStatements();
            }
            node = node.getParent();
        }
        return false;
    }

    protected boolean canIncludeVariableDefinitionStatement(ITextViewer viewer, int documentOffset) {
        Node node = ((IEGLDocument)viewer.getDocument()).getNewModelNodeAtOffset(documentOffset);
        while (node != null) {
            if (node instanceof Statement) {
                return ((Statement)node).canIncludeOtherStatements() && (node instanceof IfStatement || node instanceof WhileStatement || node instanceof TryStatement || node instanceof ForStatement || node instanceof CaseStatement);
            }
            node = node.getParent();
        }
        return false;
    }

    public Node getPart(ITextViewer viewer, int documentOffset) {
        IEGLDocument document = (IEGLDocument)viewer.getDocument();
        return EGLModelUtility.getPartNode(document, documentOffset);
    }

    protected Node getNestedPart(ITextViewer viewer, int documentOffset) {
        IEGLDocument document = (IEGLDocument)viewer.getDocument();
        return EGLModelUtility.getNestedPartNode(document, documentOffset);
    }

    public List getFunctionNames(ITextViewer viewer, int documentOffset) {
        final ArrayList functionNames = new ArrayList();
        Node eglPart = this.getPart(viewer, documentOffset);
        eglPart.accept((IASTVisitor)new AbstractASTPartVisitor(){

            public void visitPart(Part part) {
                Iterator iter = part.getContents().iterator();
                while (iter.hasNext()) {
                    ((Node)iter.next()).accept((IASTVisitor)new DefaultASTVisitor(){

                        public void endVisit(NestedFunction nestedFunction) {
                            functionNames.add(nestedFunction.getName().getCanonicalName());
                        }
                    });
                }
            }
        });
        return functionNames;
    }

    public List createProposal(ITextViewer viewer, String proposalString, String prefix, String additionalInfo, int documentOffset) {
        return this.createProposal(viewer, proposalString, prefix, additionalInfo, documentOffset, proposalString.length(), 0);
    }

    public List createProposal(ITextViewer viewer, String proposalString, String prefix, String additionalInfo, int documentOffset, int cursorPosition) {
        return this.createProposal(viewer, proposalString, prefix, additionalInfo, documentOffset, cursorPosition, proposalString.length());
    }

    public List createProposal(ITextViewer viewer, String proposalString, String prefix, String additionalInfo, int documentOffset, int cursorPosition, int postSelectionLength) {
        return this.createProposal(viewer, proposalString, proposalString, prefix, additionalInfo, documentOffset, cursorPosition, postSelectionLength);
    }

    public List createProposal(ITextViewer viewer, String displayString, String proposalString, String prefix, String additionalInfo, int documentOffset, int cursorPosition, int postSelectionLength) {
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        if (this.compatiblePrefix(displayString, prefix)) {
            proposals.add(new EGLCompletionProposal(viewer, displayString, proposalString, additionalInfo, documentOffset - prefix.length(), prefix.length(), cursorPosition, 50, postSelectionLength, ""));
        }
        return proposals;
    }

    private boolean compatiblePrefix(String displayString, String prefix) {
        if (displayString.toUpperCase().startsWith(prefix.toUpperCase())) {
            return true;
        }
        return displayString.startsWith("\"") && (displayString = displayString.substring(1, displayString.length() - 1)).toUpperCase().startsWith(prefix.toUpperCase());
    }

    protected String getNodeText(ParseStack parseStack, int contextDeleted) {
        ParseStack tempStack = parseStack.copy();
        ParseNode[] parseNodes = tempStack.deleteContext(contextDeleted);
        return parseNodes[0].getText().trim();
    }

    protected String getNodeText2(ParseStack parseStack, int contextDeleted) {
        ParseStack tempStack = parseStack.copy();
        ParseNode[] parseNodes = tempStack.deleteContext(contextDeleted);
        int i = parseNodes.length;
        while (i > 0) {
            ParseNode node = parseNodes[i - 1];
            if (node.getText() != null && node.getText().length() > 0) {
                return node.getText().trim();
            }
            --i;
        }
        return "";
    }

    protected void getBoundASTNode(ITextViewer viewer, int documentOffset, IBoundNodeProcessor boundNodeProcessor) {
        this.getBoundASTNode(viewer, documentOffset, new String[]{""}, new CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                return true;
            }
        }, boundNodeProcessor);
    }

    protected void getBoundASTPart(ITextViewer viewer, int documentOffset, String[] completionsToTry, CompletedNodeVerifier completedNodeVerifier, IBoundNodeProcessor boundNodeProcessor) {
        this.getBoundASTNode(viewer, documentOffset, completionsToTry, new BoundPartWorkingCopyCompileRequestor(viewer, documentOffset, completedNodeVerifier, boundNodeProcessor));
    }

    protected void getBoundASTNode(ITextViewer viewer, int documentOffset, String[] completionsToTry, CompletedNodeVerifier completedNodeVerifier, IBoundNodeProcessor boundNodeProcessor) {
        this.getBoundASTNode(viewer, documentOffset, completionsToTry, new BoundNodeWorkingCopyCompileRequestor(viewer, documentOffset, completedNodeVerifier, boundNodeProcessor));
    }

    private void getBoundASTNode(ITextViewer viewer, int documentOffset, String[] completionsToTry, IWorkingCopyCompileNodeRequestor requestor) {
        IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
        IPath path = file.getFullPath();
        IWorkingCopy[] sharedWorkingCopies = EGLCore.getSharedWorkingCopies((IBufferFactory)EGLUI.getBufferFactory());
        int myIndexInSharedWorkingCopies = -1;
        IWorkingCopy myOriginalWorkingCopy = null;
        int i = 0;
        while (i < completionsToTry.length) {
            String textToInsertAtOffset = completionsToTry[i];
            IEGLFile tempFile = (IEGLFile)EGLCore.create((IFile)file);
            int j = 0;
            while (j < sharedWorkingCopies.length && myOriginalWorkingCopy == null) {
                if (sharedWorkingCopies[j].getOriginalElement().getResource().equals((Object)file)) {
                    myIndexInSharedWorkingCopies = j;
                    myOriginalWorkingCopy = sharedWorkingCopies[j];
                }
                ++j;
            }
            try {
                WorkingCopy workingCopy = (WorkingCopy)tempFile.getWorkingCopy();
                char[] workingCopyText = ((WorkingCopy)myOriginalWorkingCopy).getBuffer().getCharacters();
                char[] newText = new char[workingCopyText.length + textToInsertAtOffset.length()];
                System.arraycopy(workingCopyText, 0, newText, 0, documentOffset);
                System.arraycopy(textToInsertAtOffset.toCharArray(), 0, newText, documentOffset, textToInsertAtOffset.length());
                System.arraycopy(workingCopyText, documentOffset, newText, documentOffset + textToInsertAtOffset.length(), workingCopyText.length - documentOffset);
                workingCopy.getBuffer().setContents(newText);
                sharedWorkingCopies[myIndexInSharedWorkingCopies] = workingCopy;
                WorkingCopyCompiler.getInstance().compileAllParts(file.getProject(), this.getPackageName(path), file, sharedWorkingCopies, (IWorkingCopyCompileRequestor)requestor);
                sharedWorkingCopies[myIndexInSharedWorkingCopies] = myOriginalWorkingCopy;
                workingCopy.destroy();
            }
            catch (EGLModelException e) {
                throw new RuntimeException(e);
            }
            if (requestor.foundDesiredNode()) break;
            ++i;
        }
    }

    protected void getBoundASTNodeForOffsetInStatement(ITextViewer viewer, int documentOffset, IBoundNodeProcessor boundNodeProcessor) {
        this.getBoundASTNode(viewer, documentOffset, new String[]{";", "", ";end end"}, new CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                return astNode != null;
            }
        }, boundNodeProcessor);
    }

    private String getPackageName(IPath path) {
        String packageName = "";
        if (path.segmentCount() > 3) {
            boolean first = true;
            int i = 2;
            while (i < path.segmentCount() - 1) {
                if (first) {
                    first = false;
                } else {
                    packageName = String.valueOf(packageName) + ".";
                }
                packageName = String.valueOf(packageName) + path.segment(i);
                ++i;
            }
        }
        return packageName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this);
        buf.append("validStates= ");
        for (Integer state : this.validStates) {
            buf.append(state);
            buf.append(",");
        }
        return buf.toString();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }

    protected int getSearchConstantsForDeclarableParts() {
        return 31272;
    }

    protected int getSearchConstantsForPartsWithStaticMembers() {
        return 24864;
    }

    public class BoundNodeWorkingCopyCompileRequestor
    implements IWorkingCopyCompileNodeRequestor {
        ITextViewer viewer;
        int documentOffset;
        private IBoundNodeProcessor boundNodeProcessor;
        private CompletedNodeVerifier completedNodeVerifier;
        private boolean isDone;

        protected BoundNodeWorkingCopyCompileRequestor(ITextViewer viewer, int documentOffset, CompletedNodeVerifier completedNodeVerifier, IBoundNodeProcessor boundNodeProcessor) {
            this.viewer = viewer;
            this.documentOffset = documentOffset;
            this.boundNodeProcessor = boundNodeProcessor;
            this.completedNodeVerifier = completedNodeVerifier;
        }

        public void acceptResult(WorkingCopyCompilationResult result) {
            Node nodeAtOffset;
            IEGLDocument document = (IEGLDocument)this.viewer.getDocument();
            Node boundPart = result.getBoundPart();
            if (!(boundPart instanceof File) && (nodeAtOffset = document.getNewModelNodeAtOffset(this.documentOffset, boundPart)) != null && this.completedNodeVerifier.nodeIsValid(nodeAtOffset)) {
                this.isDone = true;
                this.boundNodeProcessor.processBoundNode(nodeAtOffset);
            }
        }

        @Override
        public boolean foundDesiredNode() {
            return this.isDone;
        }
    }

    public class BoundPartWorkingCopyCompileRequestor
    implements IWorkingCopyCompileNodeRequestor {
        ITextViewer viewer;
        int documentOffset;
        private IBoundNodeProcessor boundNodeProcessor;
        private CompletedNodeVerifier completedNodeVerifier;
        private boolean isDone;

        protected BoundPartWorkingCopyCompileRequestor(ITextViewer viewer, int documentOffset, CompletedNodeVerifier completedNodeVerifier, IBoundNodeProcessor boundNodeProcessor) {
            this.viewer = viewer;
            this.documentOffset = documentOffset;
            this.boundNodeProcessor = boundNodeProcessor;
            this.completedNodeVerifier = completedNodeVerifier;
        }

        public void acceptResult(WorkingCopyCompilationResult result) {
            IEGLDocument document = (IEGLDocument)this.viewer.getDocument();
            Part nodeAtOffset = ((EGLDocument)document).getNewModelPartAtOffset(this.documentOffset, result.getBoundPart());
            if (nodeAtOffset != null && this.completedNodeVerifier.nodeIsValid((Node)nodeAtOffset)) {
                this.isDone = true;
                this.boundNodeProcessor.processBoundNode((Node)nodeAtOffset);
            }
        }

        @Override
        public boolean foundDesiredNode() {
            return this.isDone;
        }
    }

    protected static interface CompletedNodeVerifier {
        public boolean nodeIsValid(Node var1);
    }

    protected static interface IBoundNodeProcessor {
        public void processBoundNode(Node var1);
    }

    protected static interface IWorkingCopyCompileNodeRequestor
    extends IWorkingCopyCompileRequestor {
        public boolean foundDesiredNode();
    }
}

