/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;

public class RefactoringScopeFactory {
    private static void addReferencingProjects(IEGLProject focus, Set projects) throws EGLModelException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IEGLPathEntry entry;
            IEGLProject candidate = EGLCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferencing(IEGLProject focus, Set projects) throws CoreException {
        IProject[] referencingProjects = focus.getProject().getReferencingProjects();
        int i = 0;
        while (i < referencingProjects.length) {
            IEGLPathEntry entry;
            IEGLProject candidate = EGLCore.create((IProject)referencingProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(candidate, focus)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                }
            }
            ++i;
        }
    }

    private static void addRelatedReferenced(IEGLProject focus, Set projects) throws CoreException {
        IProject[] referencedProjects = focus.getProject().getReferencedProjects();
        int i = 0;
        while (i < referencedProjects.length) {
            IEGLPathEntry entry;
            IEGLProject candidate = EGLCore.create((IProject)referencedProjects[i]);
            if (candidate != null && !projects.contains(candidate) && candidate.exists() && (entry = RefactoringScopeFactory.getReferencingClassPathEntry(focus, candidate)) != null) {
                projects.add(candidate);
                if (entry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferenced(candidate, projects);
                    RefactoringScopeFactory.addRelatedReferencing(candidate, projects);
                }
            }
            ++i;
        }
    }

    public static IEGLSearchScope create(IEGLElement eglElement) throws EGLModelException {
        return RefactoringScopeFactory.create(eglElement, true);
    }

    public static IEGLSearchScope create(IEGLElement eglElement, boolean considerVisibility) throws EGLModelException {
        return RefactoringScopeFactory.create(eglElement.getEGLProject());
    }

    private static IEGLSearchScope create(IEGLProject javaProject) throws EGLModelException {
        return SearchEngine.createEGLSearchScope((IEGLElement[])RefactoringScopeFactory.getAllScopeElements(javaProject), (boolean)false);
    }

    public static IEGLSearchScope createReferencedScope(IEGLElement[] eglElements) {
        HashSet<IEGLProject> projects = new HashSet<IEGLProject>();
        int i = 0;
        while (i < eglElements.length) {
            projects.add(eglElements[i].getEGLProject());
            ++i;
        }
        IEGLProject[] prj = projects.toArray(new IEGLProject[projects.size()]);
        return SearchEngine.createEGLSearchScope((IEGLElement[])prj, (boolean)true);
    }

    public static IEGLSearchScope createReferencedScope(IEGLElement[] eglElements, boolean includeReferencedFunctions) {
        HashSet<IEGLProject> projects = new HashSet<IEGLProject>();
        int i = 0;
        while (i < eglElements.length) {
            projects.add(eglElements[i].getEGLProject());
            ++i;
        }
        IEGLProject[] prj = projects.toArray(new IEGLProject[projects.size()]);
        return SearchEngine.createEGLSearchScope((IEGLElement[])prj, (boolean)includeReferencedFunctions);
    }

    public static IEGLSearchScope createRelatedProjectsScope(IEGLProject project, boolean includeReferencedFunctions) throws CoreException {
        IEGLProject[] projects = RefactoringScopeFactory.getRelatedProjects(project);
        return SearchEngine.createEGLSearchScope((IEGLElement[])projects, (boolean)includeReferencedFunctions);
    }

    private static IEGLElement[] getAllScopeElements(IEGLProject project) throws EGLModelException {
        Collection sourceRoots = RefactoringScopeFactory.getAllSourceRootsInProjects(RefactoringScopeFactory.getReferencingProjects(project));
        return sourceRoots.toArray(new IPackageFragmentRoot[sourceRoots.size()]);
    }

    private static Collection getAllSourceRootsInProjects(Collection projects) throws EGLModelException {
        ArrayList result = new ArrayList();
        Iterator it = projects.iterator();
        while (it.hasNext()) {
            result.addAll(RefactoringScopeFactory.getSourceRoots((IEGLProject)it.next()));
        }
        return result;
    }

    private static IEGLPathEntry getReferencingClassPathEntry(IEGLProject referencingProject, IEGLProject referencedProject) throws EGLModelException {
        IEGLPathEntry result = null;
        IPath path = referencedProject.getProject().getFullPath();
        IEGLPathEntry[] classpath = referencingProject.getResolvedEGLPath(true);
        int i = 0;
        while (i < classpath.length) {
            IEGLPathEntry entry = classpath[i];
            if (entry.getEntryKind() == 2 && path.equals((Object)entry.getPath())) {
                if (entry.isExported()) {
                    return entry;
                }
                result = entry;
            }
            ++i;
        }
        return result;
    }

    private static IEGLProject[] getRelatedProjects(IEGLProject focus) throws CoreException {
        HashSet<IEGLProject> projects = new HashSet<IEGLProject>();
        RefactoringScopeFactory.addRelatedReferencing(focus, projects);
        RefactoringScopeFactory.addRelatedReferenced(focus, projects);
        projects.add(focus);
        return projects.toArray(new IEGLProject[projects.size()]);
    }

    private static Collection getReferencingProjects(IEGLProject focus) throws EGLModelException {
        HashSet<IEGLProject> projects = new HashSet<IEGLProject>();
        RefactoringScopeFactory.addReferencingProjects(focus, projects);
        projects.add(focus);
        return projects;
    }

    private static List getSourceRoots(IEGLProject javaProject) throws EGLModelException {
        ArrayList<IPackageFragmentRoot> elements = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!root.isArchive()) {
                elements.add(root);
            }
            ++i;
        }
        return elements;
    }

    private RefactoringScopeFactory() {
    }
}

