/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.StandardEGLElementContentProvider;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.IReorgDestinationValidator;

public final class DestinationContentProvider
extends StandardEGLElementContentProvider {
    private IReorgDestinationValidator fValidator;

    public DestinationContentProvider(IReorgDestinationValidator validator) {
        super(true, true);
        this.fValidator = validator;
    }

    @Override
    public boolean hasChildren(Object element) {
        IResource resource;
        if (element instanceof IEGLElement) {
            IEGLElement eglElement = (IEGLElement)element;
            if (!this.fValidator.canChildrenBeDestinations(eglElement)) {
                return false;
            }
            if (eglElement.getElementType() == 3 && ((IPackageFragmentRoot)eglElement).isArchive()) {
                return false;
            }
        } else if (element instanceof IResource && !this.fValidator.canChildrenBeDestinations(resource = (IResource)element)) {
            return false;
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IEGLModel) {
                return DestinationContentProvider.concatenate(this.getEGLProjects((IEGLModel)parentElement), DestinationContentProvider.getOpenNonEGLProjects((IEGLModel)parentElement));
            }
            Object[] children = super.getChildren(parentElement);
            ArrayList<Object> result = new ArrayList<Object>(children.length);
            int i = 0;
            while (i < children.length) {
                IResource resource;
                if (children[i] instanceof IEGLElement) {
                    IEGLElement eglElement = (IEGLElement)children[i];
                    if (this.fValidator.canElementBeDestination(eglElement) || this.fValidator.canChildrenBeDestinations(eglElement)) {
                        result.add(eglElement);
                    }
                } else if (children[i] instanceof IResource && (this.fValidator.canElementBeDestination(resource = (IResource)children[i]) || this.fValidator.canChildrenBeDestinations(resource))) {
                    result.add(resource);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (EGLModelException e) {
            EDTUIPlugin.log(e);
            return new Object[0];
        }
    }

    private static Object[] getOpenNonEGLProjects(IEGLModel model) throws EGLModelException {
        Object[] nonEGLProjects = model.getNonEGLResources();
        ArrayList<IProject> result = new ArrayList<IProject>(nonEGLProjects.length);
        int i = 0;
        while (i < nonEGLProjects.length) {
            IProject project = (IProject)nonEGLProjects[i];
            if (project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }
}

