/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.util.List;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.dialogs.InterfaceSelectionDialog;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public abstract class InterfaceSelectionListWizardPage
extends EGLPartWizardPage {
    protected ListDialogField fSuperInterfacesDialogField;

    protected abstract InterfaceSelectionDialog getInterfaceSelectionDialog(IEGLProject var1);

    protected InterfaceSelectionListWizardPage(String pageName) {
        super(pageName);
    }

    protected void initSuperInterfacesControl(IListAdapter listadapter) {
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPageInterfacesAdd;
        stringArray[2] = NewWizardMessages.NewTypeWizardPageInterfacesRemove;
        String[] addButtons = stringArray;
        this.fSuperInterfacesDialogField = new ListDialogField(listadapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
    }

    protected void createEGLInterfacesControls(Composite composite, int nColumns, String InterfaceLabel) {
        this.fSuperInterfacesDialogField.setLabelText(InterfaceLabel);
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    protected void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSuperInterfacesDialogField) {
            this.chooseSuperInterfaces();
        }
    }

    private void chooseSuperInterfaces() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IEGLProject project = root.getEGLProject();
        InterfaceSelectionDialog dialog = this.getInterfaceSelectionDialog(project);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPageInterfacesDialogMessage);
        dialog.open();
    }

    public List getSuperInterfaces() {
        return this.fSuperInterfacesDialogField.getElements();
    }

    public void setSuperInterfaces(List interfacesNames, boolean canBeModified) {
        this.fSuperInterfacesDialogField.setElements(interfacesNames);
        this.fSuperInterfacesDialogField.setEnabled(canBeModified);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.exit();
        }
    }

    protected class InterfaceListFieldAdapter
    implements IListAdapter {
        protected InterfaceListFieldAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            InterfaceSelectionListWizardPage.this.typePageCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
        }

        @Override
        public void doubleClicked(ListDialogField field) {
        }
    }

    private class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = PluginImages.DESC_OBJS_INTERFACE.createImage();

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }
}

