/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core.java.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.filters.ClasspathEntryFilter;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class WorkspaceProjectClassFilter
extends ClasspathEntryFilter
implements IElementChangedListener {
    public WorkspaceProjectClassFilter() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
    }

    @Override
    public void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        super.dispose();
    }

    @Override
    protected IClasspathEntry[] getCommonClasspathEntries() {
        String[] projects = this.getProjectNames();
        if (projects != null && projects.length > 0) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            String[] stringArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                String project = stringArray[n2];
                IProject proj = root.getProject(project);
                try {
                    if (proj.isAccessible() && proj.hasNature("org.eclipse.jdt.core.javanature")) {
                        IClasspathEntry[] iClasspathEntryArray = JavaCore.create((IProject)proj).getResolvedClasspath(true);
                        int n3 = iClasspathEntryArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IClasspathEntry entry = iClasspathEntryArray[n4];
                            switch (entry.getEntryKind()) {
                                case 1: {
                                    if (!this.includeLibraries()) break;
                                    list.add(entry);
                                    break;
                                }
                                case 2: {
                                    if (!this.includeReferencedProjects()) break;
                                    list.add(entry);
                                    break;
                                }
                                case 5: {
                                    if (!this.includeContainers()) break;
                                    list.add(entry);
                                    break;
                                }
                                case 3: {
                                    if (!this.includeSource()) break;
                                    list.add(entry);
                                }
                            }
                            ++n4;
                        }
                    }
                }
                catch (CoreException ce) {
                    EDTDebugCorePlugin.log(ce);
                }
                ++n2;
            }
            return list.toArray(new IClasspathEntry[list.size()]);
        }
        return null;
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getDelta() != null) {
            String[] projectNames = this.getProjectNames();
            IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta kid = iJavaElementDeltaArray[n2];
                if (kid.getElement() != null && kid.getElement().getElementType() == 2 && kid.getAffectedChildren() == null || kid.getAffectedChildren().length == 0) {
                    if (kid.getKind() == 1 || kid.getKind() == 2) {
                        int i = 0;
                        while (i < projectNames.length) {
                            if (projectNames[i].equals(kid.getElement().getElementName())) {
                                this.commonClassesToFilter = new HashMap(100);
                                try {
                                    this.processEntries(this.getCommonClasspathEntries(), (IJavaProject)kid.getElement(), this.commonClassesToFilter);
                                }
                                catch (CoreException ce) {
                                    EDTDebugCorePlugin.log(ce);
                                }
                                return;
                            }
                            ++i;
                        }
                    }
                } else {
                    IResource resource = kid.getElement().getResource();
                    if (resource != null) {
                        int i = 0;
                        while (i < projectNames.length) {
                            if (projectNames[i].equals(resource.getProject().getName())) {
                                this.processDelta(kid);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    protected void processDelta(IJavaElementDelta delta) {
        block16: {
            IJavaElementDelta[] kids;
            block14: {
                IJavaElement element;
                block15: {
                    kids = delta.getAffectedChildren();
                    if (kids != null && kids.length != 0) break block14;
                    element = delta.getElement();
                    if (element == null || element.getElementType() != 5) break block15;
                    try {
                        switch (delta.getKind()) {
                            case 1: {
                                this.compilationUnitAdded(delta, (ICompilationUnit)delta.getElement());
                                break;
                            }
                            case 2: {
                                this.compilationUnitRemoved(delta, (ICompilationUnit)delta.getElement());
                                break;
                            }
                            case 4: {
                                this.compilationUnitChanged(delta, (ICompilationUnit)delta.getElement());
                            }
                        }
                    }
                    catch (JavaModelException jme) {
                        EDTDebugCorePlugin.log(jme);
                    }
                    break block16;
                }
                if (element == null || element.getElementType() != 4) break block16;
                try {
                    switch (delta.getKind()) {
                        case 1: {
                            this.packageFragmentAdded(delta, (IPackageFragment)element);
                            break;
                        }
                        case 2: {
                            this.packageFragmentRemoved(delta, (IPackageFragment)element);
                        }
                    }
                }
                catch (JavaModelException jme) {
                    EDTDebugCorePlugin.log(jme);
                }
                break block16;
            }
            int i = 0;
            while (i < kids.length) {
                this.processDelta(kids[i]);
                ++i;
            }
        }
    }

    protected void compilationUnitAdded(IJavaElementDelta delta, ICompilationUnit cu) throws JavaModelException {
        IType[] iTypeArray = cu.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            this.commonClassesToFilter.put(type.getFullyQualifiedName(), null);
            ++n2;
        }
    }

    protected void compilationUnitRemoved(IJavaElementDelta delta, ICompilationUnit cu) throws JavaModelException {
        if (cu.exists()) {
            IType[] iTypeArray = cu.getAllTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                this.commonClassesToFilter.remove(type.getFullyQualifiedName());
                ++n2;
            }
        } else {
            StringBuilder buf = new StringBuilder(50);
            IJavaElement current = cu.getParent();
            while (current != null && current.getElementType() == 4) {
                if (buf.length() > 0) {
                    buf.insert(0, '.');
                }
                buf.insert(0, current.getElementName());
                current = current.getParent();
            }
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(cu.getElementName().substring(0, cu.getElementName().length() - 5));
            this.commonClassesToFilter.remove(buf.toString());
            buf.append('$');
            String keyPrefix = buf.toString();
            Iterator it = this.commonClassesToFilter.keySet().iterator();
            while (it.hasNext()) {
                if (!((String)it.next()).startsWith(keyPrefix)) continue;
                it.remove();
            }
        }
    }

    protected void compilationUnitChanged(IJavaElementDelta delta, ICompilationUnit cu) throws JavaModelException {
        if ((delta.getFlags() & 0x40000) != 0) {
            this.compilationUnitRemoved(delta, cu);
            this.compilationUnitAdded(delta, cu);
        }
    }

    protected void packageFragmentAdded(IJavaElementDelta delta, IPackageFragment fragment) throws JavaModelException {
        ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
        int n = iCompilationUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            this.compilationUnitAdded(delta, cu);
            ++n2;
        }
    }

    protected void packageFragmentRemoved(IJavaElementDelta delta, IPackageFragment fragment) throws JavaModelException {
        block5: {
            block4: {
                if (!fragment.exists()) break block4;
                ICompilationUnit[] iCompilationUnitArray = fragment.getCompilationUnits();
                int n = iCompilationUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit cu = iCompilationUnitArray[n2];
                    this.compilationUnitRemoved(delta, cu);
                    ++n2;
                }
                break block5;
            }
            StringBuilder buf = new StringBuilder(50);
            IPackageFragment current = fragment;
            while (current != null && current.getElementType() == 4) {
                if (buf.length() > 0) {
                    buf.insert(0, '.');
                }
                buf.insert(0, current.getElementName());
                current = current.getParent();
            }
            if (buf.length() <= 0) break block5;
            buf.append('.');
            String keyPrefix = buf.toString();
            Iterator it = this.commonClassesToFilter.keySet().iterator();
            while (it.hasNext()) {
                if (!((String)it.next()).startsWith(keyPrefix)) continue;
                it.remove();
            }
        }
    }

    protected boolean includeReferencedProjects() {
        return false;
    }

    protected boolean includeLibraries() {
        return false;
    }

    protected boolean includeContainers() {
        return false;
    }

    protected boolean includeSource() {
        return true;
    }

    public abstract String[] getProjectNames();
}

