/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java.filters;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.filters.ClasspathEntryFilter;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;

public class JREFilter
extends ClasspathEntryFilter {
    @Override
    public synchronized void initialize(IEGLJavaDebugTarget target) {
        Object targetKey = this.getTargetClassmapKey(target);
        if (targetKey == null || this.targetClassMap.containsKey(targetKey)) {
            return;
        }
        try {
            LibraryLocation[] libraries;
            this.targetClassMap.put(targetKey, null);
            IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
            if (vm != null && (libraries = JavaRuntime.getLibraryLocations((IVMInstall)vm)).length > 0) {
                HashMap<String, Object> targetClasses = new HashMap<String, Object>(100);
                this.targetClassMap.put(targetKey, targetClasses);
                LibraryLocation[] libraryLocationArray = libraries;
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    LibraryLocation library = libraryLocationArray[n2];
                    this.processJar(library.getSystemLibraryPath().toFile(), library.getPackageRootPath().toString(), targetClasses);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            EDTDebugCorePlugin.log(e);
        }
    }

    @Override
    protected Object getTargetClassmapKey(IEGLJavaDebugTarget target) {
        try {
            IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)target.getJavaDebugTarget().getLaunch().getLaunchConfiguration());
            if (vm != null) {
                return vm.getId();
            }
        }
        catch (CoreException ce) {
            EDTDebugCorePlugin.log(ce);
        }
        return null;
    }
}

