/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlay;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPainter;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayoutRegistry;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class EvDesignOverlayPainter {
    protected static final Rectangle NOT_SHOWN_REC = new Rectangle(0, 0, 16, 16);
    protected boolean _bPatternSelection = false;
    protected boolean _bPatternDropLocationSelected = false;
    protected Image _imageTransparencyFixed = null;
    protected Image _imageTransparencyVariable = null;
    protected EvDesignOverlay _overlay = null;
    protected WidgetPainter _widgetPainter = null;
    protected Point _mouseDownPoint = null;
    protected static final Color COLOR_BLACK = Display.getCurrent().getSystemColor(2);
    protected static final Color COLOR_WHITE = Display.getCurrent().getSystemColor(1);
    protected static final Color COLOR_DARK_GRAY = Display.getCurrent().getSystemColor(16);
    protected static final Color COLOR_GRAY = Display.getCurrent().getSystemColor(15);

    public EvDesignOverlayPainter(EvDesignOverlay overlay) {
        this._overlay = overlay;
        this._widgetPainter = new WidgetPainter(this._overlay);
        this._imageTransparencyFixed = Activator.getImage("obj16/transparencymaskfixed.gif");
        this._imageTransparencyVariable = Activator.getImage("obj16/transparencymaskvariable.jpg");
    }

    public void setMouseDownPoint(Point mouseDownPoint) {
        this._mouseDownPoint = mouseDownPoint;
    }

    protected void paintBlank(GC gc) {
        Rectangle rectBounds = this._overlay.getBounds();
        gc.fillRectangle(rectBounds);
    }

    protected void paintDropLocationPotential(GC gc, Rectangle rectDrop, int iLocation, int transparent, int lineStyle, int lineWidth) {
        if (!gc.getClipping().intersects(rectDrop)) {
            return;
        }
        gc.setAlpha(transparent);
        gc.setBackground(this._overlay._colorDropTargetPotential);
        gc.fillRectangle(rectDrop);
        gc.setLineStyle(lineStyle);
        gc.setLineWidth(lineWidth);
        gc.setForeground(COLOR_BLACK);
        this.paintRectangle(gc, rectDrop, iLocation);
        gc.setAlpha(255);
    }

    protected void paintDropLocations(GC gc) {
        if (this._overlay._listDropLocations == null) {
            return;
        }
        Object[] objArray = this._overlay._listDropLocations.toArray();
        int i = objArray.length - 1;
        while (i >= 0) {
            if (objArray[i] != this._overlay._dropLocation) {
                this.paintDropLocationPotential(gc, ((EvDesignOverlayDropLocation)objArray[i]).rectDrop, ((EvDesignOverlayDropLocation)objArray[i]).iLocation, ((EvDesignOverlayDropLocation)objArray[i]).selectedTransparent, ((EvDesignOverlayDropLocation)objArray[i]).lineStyle, ((EvDesignOverlayDropLocation)objArray[i]).lineWidth);
            }
            --i;
        }
        if (this._overlay._dropLocation != null) {
            Rectangle rectDrop = this._overlay._dropLocation.rectDrop;
            gc.setAlpha(this._overlay._dropLocation.selectedTransparent);
            gc.setBackground(this._overlay._colorDropTargetSelected);
            gc.fillRectangle(rectDrop);
            if (this._bPatternDropLocationSelected) {
                int i2;
                int iBlu;
                int iGrn;
                int iRed = this._overlay._colorDropTargetSelected.getRed();
                double dLuminance = 0.3 * (double)iRed + 0.59 * (double)(iGrn = this._overlay._colorDropTargetSelected.getGreen()) + 0.11 * (double)(iBlu = this._overlay._colorDropTargetSelected.getBlue());
                boolean bWhite = dLuminance < 150.0;
                gc.setLineStyle(1);
                gc.setLineWidth(1);
                gc.setForeground(bWhite ? COLOR_WHITE : COLOR_BLACK);
                if (rectDrop.width > 8) {
                    i2 = 1;
                    while (i2 < rectDrop.width) {
                        gc.drawLine(rectDrop.x + i2, rectDrop.y + 1, rectDrop.x + i2, rectDrop.y + rectDrop.height - 2);
                        i2 += 4;
                    }
                }
                if (rectDrop.height > 8) {
                    i2 = 1;
                    while (i2 < rectDrop.height) {
                        gc.drawLine(rectDrop.x + 1, rectDrop.y + i2, rectDrop.x + rectDrop.width - 2, rectDrop.y + i2);
                        i2 += 4;
                    }
                }
            }
            gc.setLineStyle(this._overlay._dropLocation.lineStyle);
            gc.setLineWidth(2);
            gc.setForeground(COLOR_BLACK);
            this.paintRectangle(gc, rectDrop, this._overlay._dropLocation.iLocation);
            gc.setAlpha(255);
        }
    }

    protected void paintHierarchy(GC gc) {
        int i;
        if (this._overlay._dropLocation == null || this._overlay._listDropLocations == null) {
            return;
        }
        if (this._overlay._dropLocation.widgetParent == null || this._overlay._dropLocation.widgetLayoutData != null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        WidgetPart widgetRoot = this._overlay._pageDesign.getWidgetManager().getWidgetRoot();
        Image image = Activator.getDefault().getWidgetImage(widgetRoot);
        int iFontImageHeight = gc.getFontMetrics().getHeight();
        iFontImageHeight = Math.max(iFontImageHeight, image.getBounds().height);
        int iOffset = iFontImageHeight + 8;
        ScrolledComposite scroll = (ScrolledComposite)this._overlay.getParent().getParent();
        Rectangle rectClient = scroll.getClientArea();
        ArrayList<WidgetPart> listParents = new ArrayList<WidgetPart>();
        WidgetPart widgetParent = this._overlay._dropLocation.widgetParent;
        while (widgetParent != widgetRoot) {
            listParents.add(0, widgetParent);
            widgetParent = widgetParent.getParent();
        }
        int iMaxTextWidth = 16;
        List listChildren = this._overlay._dropLocation.widgetParent.getChildren();
        int i2 = 0;
        while (i2 < listChildren.size()) {
            WidgetPart widgetChild = (WidgetPart)listChildren.get(i2);
            iMaxTextWidth = Math.max(iMaxTextWidth, gc.stringExtent((String)widgetChild.getLabel()).x);
            ++i2;
        }
        iMaxTextWidth = Math.max(iMaxTextWidth, gc.stringExtent((String)this._overlay._dropLocation.widgetParent.getLabel()).x);
        String strWidgetTypeDragging = null;
        Dimension dimHeading = new Dimension(0, 0);
        if (this._overlay._widgetDragging != null) {
            strWidgetTypeDragging = this._overlay._widgetDragging.getLabel();
            Point ptWidgetTypeSize = gc.stringExtent(strWidgetTypeDragging);
            dimHeading.width = iOffset + ptWidgetTypeSize.x + 8;
            dimHeading.height = ptWidgetTypeSize.y + 8;
        }
        Rectangle rectBounds = new Rectangle(0, 0, 0, 0);
        Point ptOrigin = scroll.getOrigin();
        rectBounds.y = ptOrigin.y + 16;
        rectBounds.width = 4 + listParents.size() * 16 + iOffset + iMaxTextWidth + 8;
        rectBounds.width = Math.max(rectBounds.width, dimHeading.width);
        rectBounds.height = dimHeading.height + (listParents.size() + listChildren.size()) * iOffset + 16;
        boolean bLeft = this._overlay._ptMouse.x > ptOrigin.x + rectClient.width / 2;
        rectBounds.x = ptOrigin.x + rectClient.width / 2 + 16;
        if (bLeft) {
            rectBounds.x -= rectBounds.width + 32;
        }
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setBackground(COLOR_WHITE);
        gc.fillRectangle(rectBounds);
        gc.setForeground(COLOR_GRAY);
        gc.drawRectangle(rectBounds);
        --rectBounds.x;
        --rectBounds.y;
        rectBounds.width += 2;
        rectBounds.height += 2;
        gc.setForeground(COLOR_DARK_GRAY);
        gc.drawRectangle(rectBounds);
        ++rectBounds.x;
        ++rectBounds.y;
        rectBounds.width -= 2;
        rectBounds.height -= 2;
        if (strWidgetTypeDragging != null) {
            gc.setForeground(COLOR_GRAY);
            gc.drawLine(rectBounds.x + 1, rectBounds.y + dimHeading.height + 2, rectBounds.x + rectBounds.width - 1, rectBounds.y + dimHeading.height + 2);
            gc.drawLine(rectBounds.x + 1, rectBounds.y + dimHeading.height + 4, rectBounds.x + rectBounds.width - 1, rectBounds.y + dimHeading.height + 4);
            image = Activator.getDefault().getWidgetImage(this._overlay._widgetDragging);
            gc.drawImage(image, rectBounds.x + 4, rectBounds.y + 4);
            gc.setForeground(COLOR_BLACK);
            gc.drawString(strWidgetTypeDragging, rectBounds.x + 4 + iOffset, rectBounds.y + 4, true);
        }
        gc.setLineStyle(1);
        gc.setBackground(this._overlay._colorDropTargetSelected);
        gc.setForeground(COLOR_BLACK);
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        rect.x = rectBounds.x + listParents.size() * 16 + 4;
        rect.y = rectBounds.y + dimHeading.height + 10 + (listParents.size() + this._overlay._dropLocation.iIndex) * iOffset;
        rect.width = rectBounds.x + rectBounds.width - rect.x - 8;
        rect.height = 4;
        gc.fillRectangle(rect);
        gc.drawRectangle(rect);
        this._bPatternDropLocationSelected = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected");
        if (this._bPatternDropLocationSelected) {
            i = 4;
            while (i < rect.width) {
                gc.drawLine(rect.x + i, rect.y, rect.x + i, rect.y + rect.height - 1);
                i += 4;
            }
        }
        gc.setForeground(COLOR_GRAY);
        if (this._overlay._dropLocation.widgetParent != widgetRoot) {
            gc.drawLine(rect.x - 8, rect.y + rect.height / 2 - iFontImageHeight, rect.x - 8, rect.y + rect.height / 2);
            gc.drawLine(rect.x - 8, rect.y + rect.height / 2, rect.x - 1, rect.y + rect.height / 2);
        }
        rect = new Rectangle(rectBounds.x + 4, rectBounds.y + dimHeading.height + 16, image.getBounds().width, iFontImageHeight);
        i = 0;
        while (i < listParents.size()) {
            widgetParent = (WidgetPart)listParents.get(i);
            if (i > 0) {
                gc.setForeground(COLOR_GRAY);
                gc.drawLine(4 + rect.x - iOffset / 2, rect.y - (iOffset - iFontImageHeight), 4 + rect.x - iOffset / 2, rect.y + iFontImageHeight / 2);
                gc.drawLine(4 + rect.x - iOffset / 2, rect.y + iFontImageHeight / 2, 4 + rect.x - iOffset / 2 + iFontImageHeight / 2, rect.y + iFontImageHeight / 2);
            }
            image = Activator.getDefault().getWidgetImage(widgetParent);
            gc.drawImage(image, rect.x, rect.y);
            gc.setBackground(COLOR_WHITE);
            gc.setForeground(COLOR_BLACK);
            gc.drawString(widgetParent.getLabel(), rect.x + iOffset, rect.y, true);
            rect.x += 16;
            rect.y += iOffset;
            ++i;
        }
        i = 0;
        while (i < listChildren.size()) {
            gc.setBackground(COLOR_WHITE);
            gc.setForeground(COLOR_GRAY);
            WidgetPart widgetChild = (WidgetPart)listChildren.get(i);
            if (widgetChild.getParent() != widgetRoot) {
                if (i < listChildren.size() - 1) {
                    gc.drawLine(4 + rect.x - iOffset / 2, rect.y - (iOffset - iFontImageHeight), 4 + rect.x - iOffset / 2, rect.y + iOffset);
                } else {
                    gc.drawLine(4 + rect.x - iOffset / 2, rect.y - (iOffset - iFontImageHeight), 4 + rect.x - iOffset / 2, rect.y + iFontImageHeight / 2);
                }
                gc.drawLine(4 + rect.x - iOffset / 2, rect.y + iFontImageHeight / 2, 4 + rect.x - iOffset / 2 + iFontImageHeight / 2, rect.y + iFontImageHeight / 2);
            }
            image = Activator.getDefault().getWidgetImage(widgetChild);
            gc.drawImage(image, rect.x, rect.y);
            gc.setForeground(COLOR_BLACK);
            gc.drawString(widgetChild.getLabel(), rect.x + iOffset, rect.y, true);
            if (widgetChild == this._overlay._widgetDragging) {
                Rectangle rectBorder = new Rectangle(rect.x - 1, rect.y - 1, iOffset + iMaxTextWidth + 3, rect.height + 3);
                gc.setLineWidth(2);
                gc.setLineStyle(1);
                gc.setForeground(COLOR_GRAY);
                gc.drawRectangle(rectBorder);
                gc.setLineStyle(3);
                gc.setForeground(this._overlay._colorWidgetSelected);
                gc.drawRectangle(rectBorder);
                gc.setLineStyle(1);
                gc.setLineWidth(1);
            }
            rect.y += iOffset;
            ++i;
        }
    }

    protected void paintInstructions(GC gc) {
    }

    protected void paintOpaque(GC gc) {
        boolean bUseAlpha;
        boolean bSemiTransparentWhileDragging;
        int iTransparencyMode = this._overlay._iTransparencyMode;
        if (this._overlay._listDropLocations != null && (bSemiTransparentWhileDragging = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyWhileDragging"))) {
            iTransparencyMode = 1;
        }
        if (iTransparencyMode == 0) {
            return;
        }
        int iImageW = this._imageTransparencyFixed.getBounds().width;
        int iImageH = this._imageTransparencyVariable.getBounds().height;
        ScrolledComposite compositeParent = (ScrolledComposite)this._overlay.getParent().getParent();
        Rectangle rectClient = compositeParent.getClientArea();
        Rectangle rectParent = this._overlay.getParent().getBounds();
        Rectangle rectBounds = new Rectangle(-rectParent.x - iImageW, -rectParent.y - iImageH, rectClient.width + iImageW, rectClient.height + iImageH);
        rectBounds.x = rectBounds.x / 2 * 2;
        rectBounds.y = rectBounds.y / 2 * 2;
        if (!rectBounds.intersects(gc.getClipping())) {
            return;
        }
        boolean bl = bUseAlpha = iTransparencyMode == 2;
        if (bUseAlpha) {
            gc.setAlpha(255 - this._overlay._iTransparencyAmount);
            gc.drawImage(this._imageTransparencyVariable, 0, 0, iImageW, iImageH, rectBounds.x, rectBounds.y, rectBounds.width, rectBounds.height);
            gc.setAlpha(255);
        } else {
            int y = rectBounds.y;
            while (y < rectBounds.y + rectBounds.height) {
                int x = rectBounds.x;
                while (x < rectBounds.x + rectBounds.width) {
                    gc.drawImage(this._imageTransparencyFixed, x, y);
                    x += iImageW;
                }
                y += iImageH;
            }
        }
    }

    protected void paintRectangle(GC gc, Rectangle rect, int iLocation) {
        switch (iLocation) {
            case 16384: {
                gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
                gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
                gc.setLineStyle(2);
                gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
                break;
            }
            case 131072: {
                gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
                gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
                gc.setLineStyle(2);
                gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
                break;
            }
            case 128: {
                gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
                gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
                gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
                gc.setLineStyle(2);
                gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                break;
            }
            case 1024: {
                gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height);
                gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
                gc.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
                gc.setLineStyle(2);
                gc.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
                break;
            }
            default: {
                gc.drawRectangle(rect);
            }
        }
    }

    protected void paintWidgets(GC gc) {
        Iterator iterWidgets = this._overlay.getWidgets();
        boolean bDrawOutline = this._overlay._listDropLocations != null && this._overlay._listDropLocations.size() > 0;
        try {
            while (iterWidgets.hasNext()) {
                WidgetPart widget = (WidgetPart)iterWidgets.next();
                if (!widget.getBounds().intersects(gc.getClipping()) || widget.getBounds().equals((Object)NOT_SHOWN_REC)) continue;
                boolean isContainer = this._overlay.isContainer(widget);
                this._widgetPainter.setBounds(widget.getBounds());
                this._widgetPainter.setDragging(this._overlay._widgetDragging == widget);
                this._widgetPainter.setMouseOver(widget.getMouseOver());
                this._widgetPainter.setSelected(widget.getSelected());
                this._widgetPainter.setFocus(this._overlay.isFocusControl());
                this._widgetPainter.setDrawOutline(bDrawOutline);
                this._widgetPainter.setIsContainer(isContainer);
                WidgetLayout layout = WidgetLayoutRegistry.getInstance().getWidgetLayout(WidgetLayoutRegistry.getLayoutName(widget), isContainer);
                if (layout != null) {
                    if (widget.getSelected()) {
                        this._widgetPainter.setMouseDownPoint(this._mouseDownPoint);
                        this._widgetPainter.setIsSelectedWidget(true);
                    } else {
                        this._widgetPainter.setIsSelectedWidget(false);
                    }
                    this._widgetPainter.setInnerRectangles(layout.getInnerRectanglesForPaintingWidget(widget));
                } else {
                    this._widgetPainter.setInnerRectangles(null);
                }
                this._widgetPainter.paintWidget(gc);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
    }

    protected void paintWidgetDragging(GC gc) {
        if (this._overlay._widgetDragging == null) {
            return;
        }
        Iterator iterWidgets = this._overlay.getWidgets();
        while (iterWidgets.hasNext()) {
            WidgetPart widget = (WidgetPart)iterWidgets.next();
            if (widget.getBoundsDragging().isEmpty()) continue;
            this._widgetPainter.setBoundsDragging(widget.getBoundsDragging());
            this._widgetPainter.paintWidgetDragging(gc);
        }
    }

    public void updateColors() {
        this._bPatternDropLocationSelected = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternDropLocationSelected");
        this._bPatternSelection = EvPreferences.getBoolean("org.eclipse.edt.ide.rui.visualeditor.PatternSelection");
        this._widgetPainter.updateColors();
    }
}

