/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.java.JavaObjectException;
import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.NullValueException;
import eglx.lang.TypeCastException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBigint;
import org.eclipse.edt.runtime.java.eglx.lang.EBytes;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;

public class EFloat
extends AnyBoxedObject<Double>
implements ENumber {
    private static final long serialVersionUID = 10L;
    public static final double Infinity = Double.POSITIVE_INFINITY;
    public static final double NegativeInfinity = Double.NEGATIVE_INFINITY;
    public static final double NaN = Double.NaN;
    public static final double NegativeZero = Double.longBitsToDouble(Long.MIN_VALUE);

    private EFloat(Double value) {
        super(value);
    }

    public static EFloat ezeBox(Double value) {
        return new EFloat(value);
    }

    public static Double ezeCast(Object value) throws AnyException {
        return (Double)EAny.ezeCast(value, "asFloat", EFloat.class, null, null);
    }

    public String toString() {
        return EString.asString((Double)this.object, new Integer[0]);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof EFloat && ((EFloat)value).ezeUnbox() != null || value instanceof Double;
    }

    public static Double asFloat(Short value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(ESmallint value) {
        if (value == null) {
            return null;
        }
        return (double)((Short)value.ezeUnbox());
    }

    public static Double asFloat(Integer value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(EInt value) {
        if (value == null) {
            return null;
        }
        return (double)((Integer)value.ezeUnbox());
    }

    public static Double asFloat(Long value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(EBigint value) {
        if (value == null) {
            return null;
        }
        return (double)((Long)value.ezeUnbox());
    }

    public static Double asFloat(Float value) {
        if (value == null) {
            return null;
        }
        return value.floatValue();
    }

    public static Double asFloat(ESmallfloat value) {
        if (value == null) {
            return null;
        }
        return ((Float)value.ezeUnbox()).floatValue();
    }

    public static Double asFloat(Double value) {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    public static Double asFloat(EFloat value) {
        if (value == null) {
            return null;
        }
        return (double)((Double)value.ezeUnbox());
    }

    public static Double asFloat(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static Double asFloat(EDecimal value) {
        if (value == null) {
            return null;
        }
        return ((BigDecimal)value.ezeUnbox()).doubleValue();
    }

    public static Double asFloat(BigInteger value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static Double asFloat(Number value) {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    public static Double asFloat(ENumber value) {
        if (value == null) {
            return null;
        }
        return value.ezeUnbox().doubleValue();
    }

    public static Double asFloat(String value) throws AnyException {
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (Exception exception) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "float";
            throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
        }
    }

    public static Double asFloat(EString value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EFloat.asFloat((String)value.ezeUnbox());
    }

    public static Double asFloat(byte[] value) throws AnyException {
        if (value == null) {
            return null;
        }
        if (value.length != 8) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "bytes(" + value.length + ')';
            tcx.castToName = "float";
            throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
        }
        long bits = ((long)value[0] & 0xFFL) << 56 | ((long)value[1] & 0xFFL) << 48 | ((long)value[2] & 0xFFL) << 40 | ((long)value[3] & 0xFFL) << 32 | ((long)value[4] & 0xFFL) << 24 | ((long)value[5] & 0xFFL) << 16 | ((long)value[6] & 0xFFL) << 8 | (long)value[7] & 0xFFL;
        return Double.longBitsToDouble(bits);
    }

    public static Double asFloat(EBytes value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EFloat.asFloat((byte[])value.ezeUnbox());
    }

    public static EFloat asNumber(Double value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EFloat.ezeBox(value);
    }

    public static EFloat asNumber(EFloat value) throws AnyException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static double negate(Double op) throws AnyException {
        if (op == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        return -op.doubleValue();
    }

    public static double plus(double op1, double op2) throws AnyException {
        return op1 + op2;
    }

    public static double minus(double op1, double op2) throws AnyException {
        return op1 - op2;
    }

    public static double divide(double op1, double op2) throws AnyException {
        if (op2 == 0.0) {
            JavaObjectException jox = new JavaObjectException();
            jox.exceptionType = EFloat.class.getCanonicalName();
            throw jox;
        }
        return op1 / op2;
    }

    public static double multiply(double op1, double op2) throws AnyException {
        return op1 * op2;
    }

    public static double remainder(double op1, double op2) throws AnyException {
        return op1 % op2;
    }

    public static double power(double op1, double op2) throws AnyException {
        return StrictMath.pow(op1, op2);
    }

    public static int compareTo(double op1, double op2) throws AnyException {
        return Double.valueOf(op1).compareTo(op2);
    }

    public static boolean equals(Double op1, Double op2) {
        if (op1 == op2) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.compareTo(op2) == 0;
    }

    public static boolean notEquals(Double op1, Double op2) {
        return !EFloat.equals(op1, op2);
    }
}

