/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.egl.templates;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.eclipse.edt.gen.egl.Context;
import org.eclipse.edt.gen.egl.templates.CommonUtilities;
import org.eclipse.edt.gen.egl.templates.EglTemplate;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class TypeTemplate
extends EglTemplate {
    public void genType(java.lang.reflect.Type type, Context ctx, Member member) throws MofObjectNotFoundException, DeserializationException {
        member.setType(this.convertToEglType(ctx, type));
        member.setIsNullable(CommonUtilities.isNullable(type));
    }

    private Type convertToEglType(Context ctx, java.lang.reflect.Type type) throws MofObjectNotFoundException, DeserializationException {
        ArrayType eType = null;
        if (type instanceof Class && ((Class)type).isArray() || type instanceof ParameterizedType || type instanceof GenericArrayType) {
            eType = ctx.getFactory().createArrayType();
            Type elementType = null;
            if (type instanceof Class) {
                type = ((Class)type).getComponentType();
                elementType = this.convertToEglType(ctx, type);
            } else if (type instanceof java.lang.reflect.Type) {
                type = this.getJavaType(type);
                elementType = this.convertToEglType(ctx, type);
            }
            eType.setClassifier((Classifier)Environment.getCurrentEnv().find("egl:eglx.lang.EList"));
            eType.setElementType(elementType);
            eType.setElementsNullable(CommonUtilities.isNullable(type));
        } else {
            String className = "";
            if (type instanceof Class) {
                className = ((Class)type).getName();
            }
            eType = CommonUtilities.findType(ctx, className);
        }
        return eType;
    }

    private java.lang.reflect.Type getJavaType(java.lang.reflect.Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (!(type instanceof TypeVariable)) {
            if (type instanceof GenericArrayType) {
                return ((GenericArrayType)type).getGenericComponentType();
            }
            if (!(type instanceof WildcardType) && type instanceof Class) {
                return (Class)type;
            }
        }
        return null;
    }
}

