/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.java;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.breakpoints.EGLBreakpoint;
import org.eclipse.edt.debug.core.breakpoints.EGLLineBreakpoint;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugElement;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugTarget;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaStackFrame;
import org.eclipse.edt.debug.internal.core.java.EGLJavaThread;
import org.eclipse.edt.debug.internal.ui.EDTDebugUIPlugin;
import org.eclipse.edt.debug.internal.ui.actions.BreakpointUtils;
import org.eclipse.edt.debug.internal.ui.java.EGLJavaMessages;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class EGLJavaModelPresentation
extends JDIModelPresentation {
    public String getText(Object element) {
        IMarker marker;
        EGLLineBreakpoint bp;
        IBreakpoint[] bps;
        EGLJavaDebugTarget target;
        if (element instanceof EGLBreakpoint) {
            return this.getBreakpointText((EGLBreakpoint)element);
        }
        if (element instanceof IEGLJavaVariable) {
            try {
                String type;
                IEGLJavaVariable var = (IEGLJavaVariable)element;
                StringBuilder buf = new StringBuilder(100);
                if (this.isShowVariableTypeNames() && (type = var.getReferenceTypeName()) != null && (type = type.trim()).length() != 0) {
                    buf.append(type);
                    buf.append(" ");
                }
                buf.append(var.getName());
                String value = var.getValue().getValueString();
                if (value != null) {
                    buf.append(" = ");
                    buf.append(value);
                }
                return buf.toString();
            }
            catch (DebugException debugException) {}
        }
        if (element instanceof EGLJavaStackFrame) {
            try {
                EGLJavaStackFrame frame = (EGLJavaStackFrame)element;
                if (frame.isEGLStratum()) {
                    return frame.getLabel();
                }
            }
            catch (DebugException debugException) {}
        } else if (element instanceof EGLJavaThread && !(target = ((EGLJavaThread)element).getEGLJavaDebugTarget()).supportsSourceDebugExtension() && (bps = ((EGLJavaThread)element).getJavaThread().getBreakpoints()) != null && bps.length > 0 && bps[0] instanceof IJavaLineBreakpoint && (bp = target.findCorrespondingBreakpoint((IJavaLineBreakpoint)bps[0])) != null && (marker = bp.getMarker()) != null && marker.exists()) {
            try {
                return NLS.bind((String)EGLJavaMessages.ThreadLabelSuspendedAtBreakpoint, (Object[])new Object[]{((EGLJavaThread)element).getJavaThread().getName(), String.valueOf(bp.getLineNumber()), marker.getResource().getName()});
            }
            catch (CoreException ce) {
                EDTDebugUIPlugin.log(ce);
            }
        }
        if (element instanceof IEGLJavaDebugElement) {
            element = ((IEGLJavaDebugElement)element).getJavaDebugElement();
        }
        return super.getText(element);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        if (value instanceof IEGLJavaValue) {
            IEGLJavaValue eglValue = (IEGLJavaValue)value;
            String detail = eglValue.computeDetail();
            if (detail != null) {
                listener.detailComputed(value, detail);
                return;
            }
            if (eglValue.getJavaValue() != null) {
                value = eglValue.getJavaValue();
            }
        }
        super.computeDetail(value, listener);
    }

    public Image getImage(Object item) {
        IEGLJavaVariable var;
        IBreakpoint bp;
        if (item instanceof EGLJavaFunctionVariable) {
            return EGLJavaModelPresentation.getJavaElementImageRegistry().get(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.localvariable_obj.gif"));
        }
        if (item instanceof EGLBreakpoint) {
            return this.getBreakpointImage((EGLBreakpoint)item);
        }
        if (item instanceof IMarker && (bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)item)) instanceof EGLBreakpoint) {
            return this.getBreakpointImage((EGLBreakpoint)bp);
        }
        if (item instanceof IAdaptable && (var = (IEGLJavaVariable)((IAdaptable)item).getAdapter(IEGLJavaVariable.class)) != null) {
            if (var.isLocal()) {
                return EGLJavaModelPresentation.getJavaElementImageRegistry().get(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.localvariable_obj.gif"));
            }
            return EGLJavaModelPresentation.getJavaElementImageRegistry().get(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpub_obj.gif"));
        }
        if (item instanceof IEGLJavaDebugElement) {
            item = ((IEGLJavaDebugElement)item).getJavaDebugElement();
        }
        return super.getImage(item);
    }

    private Image getBreakpointImage(EGLBreakpoint bp) {
        try {
            if (bp instanceof EGLLineBreakpoint && ((EGLLineBreakpoint)bp).isRunToLine()) {
                return null;
            }
        }
        catch (CoreException e) {
            EDTDebugUIPlugin.log(e);
        }
        boolean enabled = true;
        try {
            enabled = bp.isEnabled();
        }
        catch (CoreException coreException) {}
        if (enabled) {
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
        }
        return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT_DISABLED");
    }

    private String getBreakpointText(EGLBreakpoint bp) {
        if (bp instanceof EGLLineBreakpoint) {
            EGLLineBreakpoint lineBP = (EGLLineBreakpoint)bp;
            try {
                String name = bp.getTypeName();
                if (name == null) {
                    return EGLJavaMessages.LineBreakpointUnkown;
                }
                return NLS.bind((String)EGLJavaMessages.LineBreakpointLabel, (Object[])new Object[]{name, lineBP.getLineNumber()});
            }
            catch (CoreException e) {
                EDTDebugCorePlugin.log((Throwable)e);
                return EGLJavaMessages.LineBreakpointUnkown;
            }
        }
        return null;
    }

    public IEditorInput getEditorInput(Object item) {
        IClassFile classFile = null;
        if (item instanceof IMarker) {
            item = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint((IMarker)item);
        }
        if (item instanceof EGLBreakpoint) {
            IEGLElement element = BreakpointUtils.getElement((EGLBreakpoint)item);
            if (element != null) {
                if (element.getElementType() == 7) {
                    classFile = (IClassFile)element;
                    String srcName = BreakpointUtils.getRelativeBreakpointPath((IBreakpoint)((EGLBreakpoint)item));
                    if (srcName != null) {
                        item = EditorUtility.getBinaryReadonlyFile((IProject)element.getEGLProject().getProject(), (String)element.getPath().toString(), (String)srcName, (IClassFile)classFile);
                    }
                } else {
                    item = element.getResource();
                }
            } else {
                item = ((EGLBreakpoint)item).getMarker().getResource();
            }
        }
        if (item instanceof BinaryReadOnlyFile) {
            return new BinaryEditorInput((BinaryReadOnlyFile)item, classFile);
        }
        return super.getEditorInput(item);
    }
}

