/*******************************************************************************
 * Copyright © 2008, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
// NLS_ENCODING=UTF-8
// NLS_MESSAGEFORMAT_VAR
//
// Guidelines for defining Rich UI messages:  
// (1) DO NOT change the variable, "egl.eze$$rscBundles["RuiMessages"]"
// (2) The general format of a message is:
//          'MessageId'  :   'Message Text: {n}'
// (3) 'MessageId' (eg: CRRUI2007E) is composed of 4 parts:
//        - the first 5 characters is product identification, must be 'CRRUI'  
//        - the sixth character is a digit which identifies the component:
//                '0' -  Others       ( used to be 'E' )
//                '1' -  Widget       ( used to be 'I' )
//                '2' -  Runtime      ( used to be 'R' )
//                '3' -  Service      ( used to be 'S' )
//        - the 7th to 9th characters identifies message number, eg: '001'
//        - the 10th character identifies the message type:
//                'E' - error message
//                'I' - informational message
//                'W' - warning message
// (5)The message text may contain 1 or more message inserts, 
//         eg: {n},  where n is a 0 based number
// (6)Insert the message in alphabetical and numeric sort order  
//    against the MessageId to avoid conflicts which can be 
//    difficult to track at runtime            
//
egl.eze$$rscBundles["RuiMessages"] =
{
		'CRRUI0001E' : 'Il nome InitalUI[{0}]InitialUI \u00e8 vuoto. Non \u00e8 possibile utilizzare la funzione per inizializzare il nome.',		
		'CRRUI0006E' : 'Il gruppo {0} RadioGroup contiene un argomento non valido.',
					
		'CRRUI1001E' : 'Per la variabile {0}, {1} non pu\u00f2 essere impostato su {2}',
		'CRRUI1010E' : 'Le funzioni di trascinamento e rilascio sono riferimenti a funzioni, non array: {0}',
		'CRRUI1020E' : 'Runtime.asDictionary: pu\u00f2 convertire solo gestori o record in dizionari, non in {0}',
		'CRRUI1030E' : 'Impossibile trovare una definizione per {0}.{1}',
		'CRRUI1050E' : 'La variabile {0} deve includere la parola \"null\".',
		'CRRUI1051E' : 'Impossibile aggiungere il widget alla variabile {0}.',
		'CRRUI1055E' : 'Il figlio {1} non pu\u00f2 essere aggiunto alla variabile {2}.',		
		'CRRUI1057E' : 'Il widget {0} non pu\u00f2 essere aggiunto a se stesso.',	
		'CRRUI1058E' : 'Il predecessore {1} non pu\u00f2 essere aggiunto alla variabile {0}. {2} \u00e8 il predecessore corrente.',
		'CRRUI1060E' : 'Tentativo di impostare elemento padre per widget \"{0}\" su {1}:{2}; elemento padre deve essere un widget',
		'CRRUI1070E' : 'Si \u00e8 verificata una eccezione {0} durante la elaborazione della funzione di call back. Utilizzare try...OnException.',
		'CRRUI1071E' : 'Nessun gestore eccezioni rilevato per la chiamata di servizio. Aggiungere un gestore eccezioni per la chiamata di servizio.',
		'CRRUI1072E' : 'Si \u00e8 verificata una eccezione {0} nella funzione di call back di errore, codificare con try...OnException',		
		'CRRUI1080E' : 'Il widget non ha un elemento DOM (document object model) e non \u00e8 contenuto nel documento.<br>Gli attributi correnti per questo widget sono:<P>{0}',
		'CRRUI1083E' : 'Si \u00e8 verificato un errore durante la gestione evento browser {0}.',
		'CRRUI1150E' : 'Tentativo di rimozione di \"null\" da una variabile {0} non riuscito.',		
		'CRRUI1151E' : 'Tentativo di rimozione di un widget senza elemento DOM (document object model) da una variabile {0} non riuscito.',		
		'CRRUI1155E' : 'Il figlio del tipo {1} non pu\u00f2 essere rimosso da {0}: variabile {2}.',
		'CRRUI1157E' : 'Impossibile rimuovere un widget da se stesso. Il tipo di widget \u00e8 {0}.',
			
		'CRRUI2002E' : '{1}<br>Si \u00e8 verificato un errore in {0}: {2}',
		'CRRUI2004E' : 'La cronologia {0} contiene un argomento non valido.',
		'CRRUI2005E' : 'Impossibile utilizzare un riferimento null.',
		'CRRUI2006E' : '{0}', // The text of this message comes from some other error message.
		'CRRUI2007E' : 'Argomento non valido:',
		'CRRUI2009E' : 'Impossibile creare istanza evento da un gestore RUI.',
		'CRRUI2010E' : 'Funzione obsoleta: {0}.',
		
		'CRRUI2015E' : 'Il file {0} per RUIPropertiesLibrary {1} manca',
		'CRRUI2016E' : 'Il programma EGL sta impiegando troppo tempo',
		'CRRUI2017E' : 'Il valore \"{0}\" di tipo {1} non pu\u00f2 essere convertito nel tipo {2}',
		'CRRUI2018E' : 'Overflow durante assegnazione di {0} al tipo {1}',
		'CRRUI2019E' : 'Impossibile aggiungere elemento {0} ad array. La dimensione massima \u00e8 {1}',
		'CRRUI2020E' : 'Argomento non valido {0} per la funzione array, setMaxSize()',
		'CRRUI2021E' : 'Impossibile richiamare il token successivo dalla stringa che inizia a indice {0}',
		'CRRUI2022E' : 'Indice {0} fuori limite per questo. Dimensione array \u00e8 {1}',
		'CRRUI2023E' : '\u00c8 stato utilizzato un riferimento null: {0}',
		'CRRUI2024E' : 'Accesso dinamico alla chiave \"{0}\" non valido su un oggetto di tipo {1}',
		'CRRUI2025E' : 'Accesso dinamico non riuscito: non esiste nessuna chiave \"{0}\"',
		'CRRUI2030E' : 'Argomento non valido per XMLLib.convertFromXML. Era prevista una stringa. \u00c8 stato ricevuto \"{0}\"',
		'CRRUI2031E' : 'Si \u00e8 verificato un errore durante il parsing di XML: {0}',
		'CRRUI2032E' : 'Il pattern di data/ora {0} non \u00e8 valido',
		'CRRUI2033E' : 'Il valore {0} specificato per la funzione array, resize(), \u00e8 maggiore della dimensione massima di array {1}',
		'CRRUI2034E' : 'Tipo, {0}, per elemento array non valido',
		'CRRUI2035E' : 'Il numero di dimensioni modificate \u00e8 maggiore del numero di dimensioni di array',
		'CRRUI2036E' : 'Errore di dominio nella chiamata a {0}: argomento deve essere compreso tra {1} e {2}',
		'CRRUI2037E' : 'Errore matematico: impossibile dividere un numero per 0',
		'CRRUI2038E' : 'Errore di dominio nella chiamata a {0}: argomento deve essere maggiore di zero',
		'CRRUI2039E' : 'Errore di dominio nella chiamata a {0}: argomento deve essere maggiore o uguale a zero',
		'CRRUI2040E' : 'Errore di dominio nella chiamata a {0}: esponente per la base zero deve essere maggiore di zero',
		'CRRUI2041E' : 'Errore di dominio nella chiamata a {0}: esponente per una base negativa deve essere un numero intero',
		'CRRUI2042E' : 'Indici di stringa secondaria non validi {0}:{1}.',
		'CRRUI2050E' : 'Errore matematico: abs() - sono stati specificati {0} argomenti. Previsto 0 o 1',
		'CRRUI2051E' : 'Errore matematico: add() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2052E' : 'Errore matematico: compareTo() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2053E' : 'Errore matematico: divide() - scala negativa, {0}, non \u00e8 valido',
		'CRRUI2054E' : 'Errore matematico: divide() - sono stati specificati {0} argomenti. Previsti tra 1 e 3',
		'CRRUI2055E' : 'Errore matematico: divideInteger() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2056E' : 'Errore matematico: max() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2057E' : 'Errore matematico: min() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2058E' : 'Errore matematico: multiply() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2059E' : 'Errore matematico: negate() - sono stati specificati {0} argomenti. Previsto 0 o 1',
		'CRRUI2060E' : 'Errore matematico: plus() - sono stati specificati {0} argomenti. Previsto 0 o 1',
		'CRRUI2061E' : 'Errore matematico: pow() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2062E' : 'Errore matematico: pow() - potenza negativa {0}',
		'CRRUI2063E' : 'Errore matematico: pow() - troppe cifre, {0}',
		'CRRUI2064E' : 'Errore matematico: remainder() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2065E' : 'Errore matematico: subtract() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2066E' : 'Errore matematico: format() - sono stati specificati {0} argomenti. Previsto 2 o 6',
		'CRRUI2067E' : 'Errore matematico: format() - overflow di esponenti, {0}',
		'CRRUI2068E' : 'Errore matematico: intValueExact() - parte decimale diversa da zero, {0}',
		'CRRUI2069E' : 'Errore matematico: intValueExact() - overflow di conversione, {0}',
		'CRRUI2070E' : 'Errore matematico: setScale() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2071E' : 'Errore matematico: setScale() - scala negativa {0}',
		'CRRUI2072E' : 'Errore matematico: intCheck() - errore di conversione, {0}',
		'CRRUI2073E' : 'Errore matematico: dodivide() - overflow di interi',
		'CRRUI2074E' : 'Errore matematico: impossibile convertire la stringa \"{1}\" in un numero',
		'CRRUI2075E' : 'Errore matematico: il numero di argomento {0} del metodo {1} non \u00e8 valido. Argomento {2}',
		'CRRUI2076E' : 'Errore matematico: troppe cifre - {0}',
		'CRRUI2077E' : 'Errore matematico: round() - sono stati specificati {0} argomenti. Previsto 1 o 2',
		'CRRUI2078E' : 'Errore matematico: round() - arrotondamento necessario',
		'CRRUI2079E' : 'Errore matematico: round() - valore di arrotondamento non valido, {0}',
		'CRRUI2080E' : 'Errore matematico: round() - esponente, {0}, overflow',
		'CRRUI2081E' : 'Errore matematico: finish() - esponente, {0}, overflow',
		'CRRUI2082E' : 'Errore interno: durante la chiamata al costruttore per {0}',
		'CRRUI2083E' : 'Errore intero: si \u00e8 verificato un problema durante la definizione della classe {0}',
		'CRRUI2084E' : 'Errore interno: durante la definizione del widget {0}.{1} come sottoclasse di egl.ui.rui.RUIPropertiesLibrary',
		'CRRUI2085E' : 'Errore interno: durante la definizione del widget {0}.{1} come sottoclasse di {2}.{3}',
		'CRRUI2086E' : 'Errore intero: si \u00e8 verificato un problema durante la definizione del gestore RUI {0}',
		'CRRUI2087E' : 'Errore intero: si \u00e8 verificato un problema durante la definizione del widget RUI {0}',
		'CRRUI2088E' : 'Questo browser non \u00e8 supportato da EGL Rich UI',
		'CRRUI2089E' : 'Impossibile convertire dal formato JSON: "{0}", a causa di {1}',
		'CRRUI2090E' : 'Impossibile chiamare il servizio: {0}',
		'CRRUI2091E' : 'Impossibile inviare eventi a IDE Eclipse: {0}',
		'CRRUI2092E' : 'Errore interno: si \u00e8 verificato un problema durante la gestione di un evento IDE {0}',
		'CRRUI2093E' : 'Errore interno: impossibile attivare la funzione {0}',
		'CRRUI2094E' : 'Queste sono le chiamate alla funzione EGL che portano a questo errore:',
		'CRRUI2095E' : 'Impossibile trovare le chiamate alla funzione EGL che portano a questo errore',
		'CRRUI2097E' : 'Valore stile CSS non valido "{1}" per attributo {0}',
		'CRRUI2097E' : 'Impossibile analizzare correttamente lo stile CSS {0}. Verificare la sintassi o utilizzare un foglio di stile esterno.',
		'CRRUI2098E' : 'Si \u00e8 verificato un errore durante il supporto di trascinamento e rilascio: {0}',
		'CRRUI2099E' : 'Nella Rich UI, operazione "set" di EGL non \u00e8 supportata per il tipo {0}',
		'CRRUI2100E' : 'Argomento non valido per RuiLib.convertFromXML. Era prevista una stringa. \u00c8 stato ricevuto un oggetto di tipo {0}',
		'CRRUI2101E' : 'Impossibile individuare indexOf "{1}" in "{0}" a causa di {2}',
		'CRRUI2102E' : 'Impossibile ordinare array',
		'CRRUI2103E' : 'Accesso non valido a "{0}" in oggetto di tipo "{1}" a causa di {2}',
		'CRRUI2104E' : 'Impossibile analizzare la stringa JSON "{0}"',
		'CRRUI2105E' : 'Si \u00e8 verificato un errore di analisi JSON durante il tentativo di impostare {0}. Il campo non esiste in ubicazione prevista nella stringa JSON.',
		'CRRUI2106E' : 'Tentativo di impostazione di {0} su nullo non riuscito durante analisi di JSON perch\u00e9 non era dichiarato come campo che consente valori nulli.',
		'CRRUI2107E' : 'Le funzioni di conversione della libreria di servizi JSON operano su un Record o un Dizionario. {0} non \u00e8 un tipo supportato.',
		'CRRUI2108E' : 'Le funzioni di conversione XML della libreria XML operano su un Record. {0} non \u00e8 un tipo supportato.',
		
		'CRRUI2111E' : 'Errore MathContext(): il numero di argomenti specificato, {0}, non \u00e8 valido; previsti da 1 a 4.',
		'CRRUI2112E' : 'Errore MathContext(): il numero di cifre specificato, {0}, \u00e8 troppo piccolo.',
		'CRRUI2113E' : 'Errore MathContext(): il numero di cifre specificato, {0}, \u00e8 troppo elevato.',
		'CRRUI2114E' : 'Errore MathContext(): il valore modulo specificato, {0}, non \u00e8 valido.',
		'CRRUI2115E' : 'Errore MathContext(): il valore della modalit\u00e0 di arrotondamento specificato, {0}, non \u00e8 valido.',
		
	    'CRRUI2700E' : 'Non \u00e8 stato ricevuto alcun input per il campo obbligatorio: riprovare.',
		'CRRUI2702E' : 'Errore di tipo dati in input: riprovare.',
		'CRRUI2703E' : 'Numero di cifre consentite superato: riprovare.',
		'CRRUI2704E' : 'Input non \u00e8 compreso in intervallo definito da {0} a {1} - immettere nuovamente.',
		'CRRUI2705E' : 'Errore nella lunghezza minima di input: riprovare.',
		'CRRUI2707E' : 'Errore nel controllo modulus in fase di input: riprovare.',
		'CRRUI2708E' : 'Iinput non valido per il formato data o ora definito {0}.',
		'CRRUI2710E' : 'Input non valido per campo booleano.',
		'CRRUI2712E' : 'Dati esadecimali non validi.',
		'CRRUI2713E' : 'Valore immesso non valido perch\u00e9 non riscontra il modello impostato.',		
		'CRRUI2716E' : 'Input non compreso in intervallo valido di valori: riprovare.',
		'CRRUI2717E' : 'Il formato data e ora di {0} specificato non \u00e8 valido.',	
		'CRRUI2719E' : 'Errore durante analisi del valore immesso.',

		'CRRUI3650E' : 'Impossibile trovare il file descrittore di distribuzione: \'{0}\'',
		'CRRUI3651E' : 'La chiave di binding di servizio: \'{0}\' non esiste nel descrittore di distribuzione \'{1}\'',
		'CRRUI3652E' : 'Tipo di binding di servizio \'{0}\' non corretto, \u00e8 previsto il tipo di binding \'{1}\'',
		'CRRUI3653E' : 'Si \u00e8 verificato un errore durante il tentativo di richiamo il servizio rest su \'{0}\'',
		'CRRUI3654E' : 'Si \u00e8 verificato un errore durante la generazione di oggetto di richiesta: \'{0}\'',
		'CRRUI3655E' : 'Si \u00e8 verificato un errore durante la elaborazione di oggetto di risposta: \'{0}\'',
		'CRRUI3656E' : '\'formdata\' non \u00e8 supportato come formato di risposta',
		'CRRUI3657E' : 'Impossibile trovare il proxy su \'{0}\' per effettuare chiamate di servizio',
		'CRRUI3658E' : 'Si \u00e8 verificato un errore sul proxy su \'{0}\' durante il tentativo di chiamata al servizio su \'{1}\'',
		'CRRUI3659E' : 'Analisi della risposta Json nulla, la risposta originale \u00e8: \'{0}\'',
		'CRRUI3660E' : 'Si \u00e8 verificata una eccezione, impossibile gestire la risposta per \'{0}\', motivo: \'{1}\'',
		'CRRUI3661E' : 'Informazioni sul binding di servizio per \'{0}\' mancanti durante il tentativo di richiamare la funzione di servizio \'{1}\'.'
};

