/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import java.util.Stack;
import org.eclipse.edt.ide.core.internal.errors.ErrorGrammar;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public abstract class AbstractRecoverer {
    public static final int SUCCESS_DISTANCE = 3;
    protected ErrorGrammar grammar = ErrorGrammar.getInstance();
    protected static int[] IMPORTANT_TERMINALS = new int[]{74, 77, 79, 56, 73};
    protected static int[] UNDELETABLE_TERMINALS;
    protected static int[] SCOPE_CLOSERS;

    static {
        int[] nArray = new int[4];
        nArray[0] = 74;
        nArray[1] = 77;
        nArray[2] = 79;
        UNDELETABLE_TERMINALS = nArray;
        SCOPE_CLOSERS = new int[]{56, 73};
    }

    public abstract int recoverDistance(ParseStack var1, TokenStream var2);

    public abstract void recover(ParseStack var1, TokenStream var2);

    public abstract void errorMessage(ParseStack var1, TokenStream var2, TerminalNode var3);

    public static boolean isUndeletableTerminal(TerminalNode terminalNode) {
        return AbstractRecoverer.isInList(terminalNode.terminalType, UNDELETABLE_TERMINALS);
    }

    private static boolean isInList(int number, int[] list) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == number) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isImportantTerminal(TerminalNode terminalNode) {
        return AbstractRecoverer.isInList(terminalNode.terminalType, IMPORTANT_TERMINALS);
    }

    protected static boolean isScopeCloser(TerminalNode terminalNode) {
        return AbstractRecoverer.isInList(terminalNode.terminalType, SCOPE_CLOSERS);
    }

    protected static boolean isScopeCloser(int terminalType) {
        return AbstractRecoverer.isInList(terminalType, SCOPE_CLOSERS);
    }

    protected int tryParseAhead(ParseStack stack, TokenStream tokenStream) {
        int shifted = 0;
        while (true) {
            int action;
            if ((action = this.grammar.getTerminalAction(stack.getCurrentState(), tokenStream.lookAhead())) > 0) {
                if (AbstractRecoverer.isImportantTerminal(tokenStream.lookAhead())) {
                    return Integer.MAX_VALUE;
                }
                stack.shift(tokenStream.lookAhead());
                tokenStream.shift();
                ++shifted;
                continue;
            }
            if (action >= 0) break;
            int ruleNumber = -action - 1;
            if (ruleNumber == 0) {
                return Integer.MAX_VALUE;
            }
            stack.reduce(ruleNumber);
        }
        return shifted;
    }

    protected boolean processTerminal(ParseStack stack, TerminalNode terminalNode) {
        if (terminalNode.terminalType == 0) {
            throw new IllegalArgumentException();
        }
        this.performAllReductions(stack, terminalNode);
        int action = this.grammar.getTerminalAction(stack.getCurrentState(), terminalNode);
        if (action > 0) {
            stack.shift(terminalNode);
            return true;
        }
        return false;
    }

    protected void performAllReductions(ParseStack stack, TerminalNode terminalNode) {
        int action;
        while ((action = this.grammar.getTerminalAction(stack.getCurrentState(), terminalNode)) < 0) {
            int ruleNumber = -action - 1;
            stack.reduce(ruleNumber);
        }
    }

    protected ParseNode getHighestSymbol(ParseStack stack, TerminalNode lookahead) {
        int ruleNumber;
        int handleSize;
        int action;
        int poppable = 1;
        while ((action = this.grammar.getTerminalAction(stack.getCurrentState(), lookahead)) <= 0 && action < 0 && (handleSize = this.grammar.getHandleSize(ruleNumber = -action - 1)) <= poppable) {
            stack.reduce(ruleNumber);
            poppable = poppable - handleSize + 1;
        }
        stack.deleteContext(poppable - 1);
        return stack.getTopOfStackNode();
    }

    protected String getHighestSymbolName(ParseStack stack, TerminalNode lookahead) {
        ParseNode highestNode = this.getHighestSymbol(stack, lookahead);
        if (highestNode.isTerminal()) {
            TerminalNode terminalNode = (TerminalNode)highestNode;
            return EGLNodeNameUtility.getTerminalName(terminalNode.terminalType);
        }
        NonTerminalNode nonTerminalNode = (NonTerminalNode)highestNode;
        return EGLNodeNameUtility.getNonterminalName(nonTerminalNode.nonTerminalType);
    }

    protected TerminalNode findFirstNonWSTerminal(ParseNode[] nodes) {
        Stack<ParseNode> nodeStack = new Stack<ParseNode>();
        int i = nodes.length - 1;
        while (i >= 0) {
            nodeStack.push(nodes[i]);
            --i;
        }
        while (!nodeStack.isEmpty()) {
            ParseNode parseNode = (ParseNode)nodeStack.pop();
            if (parseNode.isTerminal()) {
                if (parseNode.isWhiteSpace()) continue;
                return (TerminalNode)parseNode;
            }
            NonTerminalNode nonTerminalNode = (NonTerminalNode)parseNode;
            if (nonTerminalNode.children == null) continue;
            int i2 = nonTerminalNode.children.length - 1;
            while (i2 >= 0) {
                nodeStack.push(nonTerminalNode.children[i2]);
                --i2;
            }
        }
        return null;
    }

    protected ParseNode chainNodes(ParseNode[] nodes) {
        int size = nodes.length;
        while (size > 1) {
            int i = 0;
            while (i < size / 2) {
                nodes[i] = new NonTerminalNode(4, new ParseNode[]{nodes[i * 2], nodes[i * 2 + 1]});
                ++i;
            }
            if (size % 2 > 0) {
                nodes[size / 2] = nodes[size - 1];
                size = size / 2 + 1;
                continue;
            }
            size /= 2;
        }
        return size > 0 ? nodes[0] : null;
    }
}

