/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.builder.workingcopy.WorkingCopyDuplicatePartManager;
import org.eclipse.edt.ide.core.internal.builder.workingcopy.WorkingCopyDuplicatePartRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyASTManager;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.lookup.FileInfoDifferencer;
import org.eclipse.edt.ide.core.internal.lookup.IASTFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfo;
import org.eclipse.edt.ide.core.internal.lookup.IFileInfoDifferenceNotificationRequestor;
import org.eclipse.edt.ide.core.internal.lookup.ZipFileBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyModelUpdateListener;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyBuildNotifier;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyCompilerResourceFileInfoCreator;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyFileInfoManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntryManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfoManager;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.mof.utils.NameUtile;

public class WorkingCopyResourceChangeProcessor
implements IResourceChangeListener {
    private static final WorkingCopyResourceChangeProcessor INSTANCE = new WorkingCopyResourceChangeProcessor();
    protected List listeners = new ArrayList();
    public static final Object FAMILY_WORKING_COPY_JOB = new Object();
    public static final Object FAMILY_WORKING_COPY_RESOURCE_CHANGE_JOB = new Object();
    public static final Object FAMILY_WORKING_COPY_INITIALIZE_JOB = new Object();
    protected WorkingCopyResourceChangeJob resourceChangeJob = new WorkingCopyResourceChangeJob();
    protected WorkingCopyInitializeJob initializeJob = new WorkingCopyInitializeJob();

    private WorkingCopyResourceChangeProcessor() {
    }

    public static WorkingCopyResourceChangeProcessor getInstance() {
        return INSTANCE;
    }

    public void addListener(IWorkingCopyModelUpdateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IWorkingCopyModelUpdateListener listener) {
        this.listeners.remove(listener);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        boolean postChange;
        boolean projectDeleting = event.getType() == 4;
        boolean projectClosing = event.getType() == 2;
        boolean bl = postChange = event.getType() == 1;
        if (projectDeleting || projectClosing) {
            this.processProjectDelete((IProject)event.getResource());
        } else if (postChange) {
            this.processPostChange(event.getDelta());
        }
    }

    public void processPostChange(IResourceDelta delta) {
        if (delta == null || !WorkingCopyFileInfoManager.getInstance().hasValidState()) {
            this.initializeWorkingCopyIndex();
        } else {
            IResourceDelta[] affectedChildren = delta.getAffectedChildren();
            int i = 0;
            while (i < affectedChildren.length) {
                IResource child = affectedChildren[i].getResource();
                if (child.getType() == 4 && EGLProject.hasEGLNature((IProject)child)) {
                    ResourceChangeProcessor processor = new ResourceChangeProcessor((IProject)child);
                    processor.processDeltas(affectedChildren[i]);
                }
                ++i;
            }
        }
    }

    public void initializeWorkingCopyIndex() {
        WorkingCopyFileInfoManager.getInstance().setState(false);
        this.resourceChangeJob.cancel();
        this.initializeJob.schedule();
    }

    private void processProjectDelete(IProject project) {
        if (EGLProject.hasEGLNature(project)) {
            ArrayList<ProjectDelta> changes = new ArrayList<ProjectDelta>(1);
            changes.add(new ProjectDelta(project, 1));
            this.resourceChangeJob.addChanges(changes);
        }
    }

    private abstract class Delta {
        public static final int ADDED = 0;
        public static final int REMOVED = 1;
        public static final int CHANGED = 2;
        public static final int FILE = 0;
        public static final int PACKAGE = 1;
        public static final int PROJECT = 2;
        private IProject project;
        private int deltaType;

        public Delta(IProject project, int deltaType) {
            this.project = project;
            this.deltaType = deltaType;
        }

        public int getDeltaType() {
            return this.deltaType;
        }

        public IProject getProject() {
            return this.project;
        }

        public abstract int getResourceType();
    }

    private class FileDelta
    extends Delta {
        private IFile file;
        private String packageName;

        public FileDelta(IProject project, int deltaType, String packageName, IFile file) {
            super(project, deltaType);
            this.file = file;
            this.packageName = packageName;
        }

        @Override
        public int getResourceType() {
            return 0;
        }

        public IFile getFile() {
            return this.file;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }

    private class PackageDelta
    extends Delta {
        private IResource packageResource;
        private String packageName;
        private List removedFiles;

        public PackageDelta(IProject project, int deltaType, String packageName, List removedFiles, IResource packageResource) {
            super(project, deltaType);
            this.packageResource = packageResource;
            this.packageName = packageName;
            this.removedFiles = removedFiles;
        }

        @Override
        public int getResourceType() {
            return 1;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public List getRemovedFiles() {
            return this.removedFiles;
        }

        public IResource getPackage() {
            return this.packageResource;
        }
    }

    private class ProjectDelta
    extends Delta {
        public ProjectDelta(IProject project, int deltaType) {
            super(project, deltaType);
        }

        @Override
        public int getResourceType() {
            return 2;
        }
    }

    private class ResourceChangeProcessor {
        private IContainer[] sourceLocations;
        private IProject project;
        private List changes = new ArrayList();

        public ResourceChangeProcessor(IProject project) {
            this.project = project;
            this.sourceLocations = WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(project).getSourceLocations();
        }

        public boolean processDeltas(IResourceDelta delta) {
            int i = 0;
            int l = this.sourceLocations.length;
            while (i < l) {
                IContainer sourceLocation = this.sourceLocations[i];
                if (sourceLocation.equals((Object)this.project)) {
                    int segmentCount = delta.getFullPath().segmentCount();
                    IResourceDelta[] children = delta.getAffectedChildren();
                    int j = 0;
                    int m = children.length;
                    while (j < m) {
                        this.processDeltas(children[j], segmentCount);
                        ++j;
                    }
                } else {
                    IResourceDelta sourceDelta = delta.findMember(sourceLocation.getProjectRelativePath());
                    if (sourceDelta != null) {
                        if (sourceDelta.getKind() == 2) {
                            System.out.println("ABORTING incremental build... found removed source folder");
                            return false;
                        }
                        int segmentCount = sourceDelta.getFullPath().segmentCount();
                        IResourceDelta[] children = sourceDelta.getAffectedChildren();
                        int j = 0;
                        int m = children.length;
                        while (j < m) {
                            this.processDeltas(children[j], segmentCount);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            WorkingCopyResourceChangeProcessor.this.resourceChangeJob.addChanges(this.changes);
            return true;
        }

        private void processDeltas(IResourceDelta sourceDelta, int segmentCount) {
            IResource resource = sourceDelta.getResource();
            switch (resource.getType()) {
                case 2: {
                    switch (sourceDelta.getKind()) {
                        case 1: {
                            IPath addedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                            this.changes.add(new PackageDelta(this.project, 0, NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(addedPackagePath)), Collections.EMPTY_LIST, resource));
                        }
                        case 4: {
                            IResourceDelta[] children = sourceDelta.getAffectedChildren();
                            int i = 0;
                            int l = children.length;
                            while (i < l) {
                                this.processDeltas(children[i], segmentCount);
                                ++i;
                            }
                            return;
                        }
                        case 2: {
                            IPath removedPackagePath = resource.getFullPath().removeFirstSegments(segmentCount);
                            if (this.sourceLocations.length > 1) {
                                int i = 0;
                                int l = this.sourceLocations.length;
                                while (i < l) {
                                    if (this.sourceLocations[i].getFolder(removedPackagePath).exists()) {
                                        IResourceDelta[] removedChildren = sourceDelta.getAffectedChildren();
                                        int j = 0;
                                        int m = removedChildren.length;
                                        while (j < m) {
                                            this.processDeltas(removedChildren[j], segmentCount);
                                            ++j;
                                        }
                                        return;
                                    }
                                    ++i;
                                }
                            }
                            ArrayList removedFiles = new ArrayList();
                            this.processRemovedPackageHelper(NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(removedPackagePath)), sourceDelta.getAffectedChildren(), removedFiles);
                            this.changes.add(new PackageDelta(this.project, 1, NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(removedPackagePath)), removedFiles, resource));
                            return;
                        }
                    }
                }
                case 1: {
                    String resourceName = resource.getName();
                    if (Util.isEGLFileName(resourceName)) {
                        IPath packagePath = resource.getFullPath().removeFirstSegments(segmentCount).removeLastSegments(1);
                        switch (sourceDelta.getKind()) {
                            case 1: {
                                this.changes.add(new FileDelta(this.project, 0, NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(packagePath)), (IFile)resource));
                                return;
                            }
                            case 2: {
                                this.changes.add(new FileDelta(this.project, 1, NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(packagePath)), (IFile)resource));
                                return;
                            }
                            case 4: {
                                if ((sourceDelta.getFlags() & 0x100) == 0) {
                                    return;
                                }
                                this.changes.add(new FileDelta(this.project, 2, NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(packagePath)), (IFile)resource));
                                return;
                            }
                        }
                        return;
                    }
                    return;
                }
            }
        }

        private void processRemovedPackageHelper(String packageName, IResourceDelta[] children, List removedFiles) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i].getResource();
                switch (resource.getType()) {
                    case 2: {
                        String subPackageName = org.eclipse.edt.ide.core.internal.utils.Util.appendToQualifiedName(packageName, resource.getName(), ".");
                        this.processRemovedPackageHelper(NameUtile.getAsName((String)subPackageName), children[i].getAffectedChildren(), removedFiles);
                        break;
                    }
                    case 1: {
                        removedFiles.add(new FileDelta(this.project, 1, packageName, (IFile)resource));
                    }
                }
                ++i;
            }
        }
    }

    private class WorkingCopyInitializeJob
    extends WorkingCopyJob {
        public WorkingCopyInitializeJob() {
            super(CoreIDEPluginStrings.WorkingCopyCompiler_InitializeJobName);
        }

        @Override
        public boolean belongsTo(Object family) {
            return family == FAMILY_WORKING_COPY_INITIALIZE_JOB || super.belongsTo(family);
        }

        public boolean shouldRun() {
            return super.shouldRun() && !WorkingCopyFileInfoManager.getInstance().hasValidState();
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                try {
                    try {
                        WorkingCopyCompiler.lock.acquire();
                        WorkingCopyResourceChangeProcessor.this.resourceChangeJob.clear();
                        WorkingCopyASTManager.getInstance().clear();
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int i = 0;
                        while (i < projects.length) {
                            IProject project = projects[i];
                            if (project.isOpen() && EGLProject.hasEGLNature(project)) {
                                WorkingCopyDuplicatePartManager.getInstance().clear(project);
                                WorkingCopyFileInfoManager.getInstance().clear(project);
                                WorkingCopyProjectInfoManager.getInstance().clear(project);
                                this.initialize(project);
                                WorkingCopyDuplicatePartManager.getInstance().saveDuplicatePartList(project);
                            }
                            ++i;
                        }
                        WorkingCopyFileInfoManager.getInstance().setState(true);
                    }
                    catch (RuntimeException e) {
                        WorkingCopyFileInfoManager.getInstance().setState(false);
                        EDTCoreIDEPlugin.getPlugin().log(String.valueOf(this.getName()) + " Failure", e);
                        WorkingCopyCompiler.lock.release();
                    }
                }
                finally {
                    WorkingCopyCompiler.lock.release();
                }
            }
            finally {
                WorkingCopyFileInfoManager.getInstance().hasValidState();
            }
            return Status.OK_STATUS;
        }

        public void initialize(final IProject project) {
            try {
                IContainer[] sourceLocations = WorkingCopyProjectBuildPathManager.getInstance().getProjectBuildPath(project).getSourceLocations();
                int i = 0;
                int l = sourceLocations.length;
                while (i < l) {
                    IContainer sourceLocation = sourceLocations[i];
                    final int segmentCount = sourceLocation.getFullPath().segmentCount();
                    IResource[] children = sourceLocation.members();
                    int j = 0;
                    while (j < children.length) {
                        children[j].accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy proxy) throws CoreException {
                                IResource resource = proxy.requestResource();
                                switch (proxy.getType()) {
                                    case 1: {
                                        if (Util.isEGLFileName(proxy.getName())) {
                                            IFile file = (IFile)resource;
                                            String packageName = NameUtile.getAsName((String)org.eclipse.edt.ide.core.internal.utils.Util.pathToQualifiedName(resource.getFullPath().removeFirstSegments(segmentCount).removeLastSegments(1)));
                                            try {
                                                String fileContents = org.eclipse.edt.ide.core.internal.utils.Util.getFileContents(file);
                                                File fileAST = WorkingCopyASTManager.getInstance().getFileAST(file, fileContents);
                                                IASTFileInfo info = new WorkingCopyCompilerResourceFileInfoCreator(WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project), packageName, file, fileAST, fileContents, new WorkingCopyDuplicatePartRequestor(project, packageName, file), true).getASTInfo();
                                                WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
                                                for (String partName : info.getPartNames()) {
                                                    PackageAndPartName ppName = new PackageAndPartName(info.getCaseSensitivePackageName(), info.getCaseSensitivePartName(partName));
                                                    projectInfo.partAdded(packageName, partName, info.getPartType(partName), file, ppName);
                                                }
                                                WorkingCopyFileInfoManager.getInstance().saveFileInfo(project, file.getProjectRelativePath(), info);
                                            }
                                            catch (Exception e) {
                                                throw new RuntimeException("Error initializing file: " + file.getProjectRelativePath(), e);
                                            }
                                        }
                                        return false;
                                    }
                                }
                                return true;
                            }
                        }, 0);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    public abstract class WorkingCopyJob
    extends WorkspaceJob {
        public WorkingCopyJob(String jobName) {
            super(jobName);
            this.setSystem(false);
            this.setPriority(30);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_WORKING_COPY_JOB;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            WorkingCopyBuildNotifier.getInstance().setCanceled(true);
            return this.doRun(monitor);
        }

        protected abstract IStatus doRun(IProgressMonitor var1);
    }

    private class WorkingCopyResourceChangeJob
    extends WorkingCopyJob {
        private List asyncChanges;

        public WorkingCopyResourceChangeJob() {
            super(CoreIDEPluginStrings.WorkingCopyCompiler_ResourceChangeJobName);
            this.asyncChanges = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChanges(List newChanges) {
            if (newChanges.isEmpty()) {
                return;
            }
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(newChanges);
                this.asyncChanges.notify();
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Delta getNextChange() {
            List list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : (Delta)this.asyncChanges.remove(0);
            }
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                try {
                    try {
                        Delta delta;
                        WorkingCopyCompiler.lock.acquire();
                        WorkingCopyASTManager.getInstance().clear();
                        ArrayList<IProject> changedProjects = new ArrayList<IProject>();
                        while ((delta = this.getNextChange()) != null) {
                            IProject project = delta.getProject();
                            int resourceType = delta.getResourceType();
                            int deltaType = delta.getDeltaType();
                            if (resourceType == 0 || resourceType == 1) {
                                if (!project.exists() || !project.isOpen()) continue;
                                changedProjects.add(project);
                                if (resourceType == 0) {
                                    switch (deltaType) {
                                        case 0: {
                                            this.processAddedFile(delta.getProject(), ((FileDelta)delta).getPackageName(), ((FileDelta)delta).getFile());
                                            break;
                                        }
                                        case 1: {
                                            this.processRemovedFile(delta.getProject(), ((FileDelta)delta).getPackageName(), ((FileDelta)delta).getFile());
                                            break;
                                        }
                                        case 2: {
                                            this.processChangedFile(delta.getProject(), ((FileDelta)delta).getPackageName(), ((FileDelta)delta).getFile());
                                        }
                                    }
                                    continue;
                                }
                                switch (deltaType) {
                                    case 0: {
                                        this.processAddedPackage(delta.getProject(), ((PackageDelta)delta).getPackageName(), ((PackageDelta)delta).getPackage());
                                        break;
                                    }
                                    case 1: {
                                        this.processRemovedPackage(delta.getProject(), ((PackageDelta)delta).getPackageName(), ((PackageDelta)delta).getPackage(), ((PackageDelta)delta).getRemovedFiles());
                                    }
                                }
                                continue;
                            }
                            if (resourceType != 2) continue;
                            switch (deltaType) {
                                case 1: {
                                    this.processRemovedProject(delta.getProject());
                                }
                            }
                        }
                        for (IProject project : changedProjects) {
                            WorkingCopyDuplicatePartManager.getInstance().saveDuplicatePartList(project);
                        }
                        changedProjects.clear();
                    }
                    catch (RuntimeException e) {
                        WorkingCopyFileInfoManager.getInstance().setState(false);
                        EDTCoreIDEPlugin.getPlugin().log(String.valueOf(this.getName()) + " Failure", e);
                        WorkingCopyCompiler.lock.release();
                    }
                }
                finally {
                    WorkingCopyCompiler.lock.release();
                }
            }
            finally {
                if (WorkingCopyFileInfoManager.getInstance().hasValidState()) {
                    this.notifyListeners();
                }
            }
            return Status.OK_STATUS;
        }

        private void notifyListeners() {
            for (IWorkingCopyModelUpdateListener listener : WorkingCopyResourceChangeProcessor.this.listeners) {
                listener.modelChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }

        @Override
        public boolean belongsTo(Object family) {
            return family == FAMILY_WORKING_COPY_RESOURCE_CHANGE_JOB || super.belongsTo(family);
        }

        private void processRemovedProject(IProject project) {
            ZipFileBuildPathEntryManager.getWCCInstance().clear(project);
            WorkingCopyFileInfoManager.getInstance().removeProject(project);
            WorkingCopyProjectEnvironmentManager.getInstance().remove(project);
            WorkingCopyProjectBuildPathEntryManager.getInstance().remove(project);
            WorkingCopyProjectInfoManager.getInstance().remove(project);
            WorkingCopyDuplicatePartManager.getInstance().remove(project);
            WorkingCopyProjectBuildPathManager.getInstance().remove(project);
        }

        private void processAddedPackage(IProject project, String packageName, IResource packageResource) {
            if (packageResource.exists()) {
                WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project).packageAdded(NameUtile.getAsName((String)packageName));
            }
        }

        private void processRemovedPackage(IProject project, String packageName, IResource packageResource, List removedFiles) {
            WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
            if (projectInfo.hasPackage(packageName)) {
                projectInfo.packageRemoved(packageName);
                this.processRemovedPackageHelper(project, removedFiles);
                WorkingCopyFileInfoManager.getInstance().removePackage(project, packageResource.getProjectRelativePath());
            }
        }

        private void processRemovedPackageHelper(IProject project, List removedFiles) {
            for (FileDelta fileDelta : removedFiles) {
                HashSet otherFilesToProcess = new HashSet();
                IPath filePath = fileDelta.getFile().getProjectRelativePath();
                if (!Util.isEGLFileName(filePath.lastSegment())) continue;
                IFileInfo fileInfo = WorkingCopyFileInfoManager.getInstance().getFileInfo(project, filePath);
                Set partNames = fileInfo.getPartNames();
                for (String partName : partNames) {
                    this.locateDuplicateFile(project, otherFilesToProcess, fileDelta.getPackageName(), partName);
                }
                this.processDuplicateFiles(project, fileDelta.getPackageName(), otherFilesToProcess);
                WorkingCopyFileInfoManager.getInstance().removeFile(project, filePath);
            }
        }

        private void processAddedFile(IProject project, String packageName, IFile addedFile) {
            if (addedFile.exists()) {
                try {
                    String fileContents = org.eclipse.edt.ide.core.internal.utils.Util.getFileContents(addedFile);
                    File fileAST = WorkingCopyASTManager.getInstance().getFileAST(addedFile, fileContents);
                    IASTFileInfo fileInfo = new WorkingCopyCompilerResourceFileInfoCreator(WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project), packageName, addedFile, fileAST, fileContents, new WorkingCopyDuplicatePartRequestor(project, packageName, addedFile), true).getASTInfo();
                    Set partNames = fileInfo.getPartNames();
                    for (String partName : partNames) {
                        PackageAndPartName ppName = new PackageAndPartName(fileInfo.getCaseSensitivePackageName(), fileInfo.getCaseSensitivePartName(partName), packageName);
                        WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project).partAdded(packageName, partName, fileInfo.getPartType(partName), addedFile, ppName);
                    }
                    WorkingCopyFileInfoManager.getInstance().saveFileInfo(project, addedFile.getProjectRelativePath(), fileInfo);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error processing added file: " + addedFile.getProjectRelativePath(), e);
                }
            }
        }

        private void processRemovedFile(IProject project, String packageName, IFile removedFile) {
            WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
            IFileInfo fileInfo = WorkingCopyFileInfoManager.getInstance().getFileInfo(project, removedFile.getProjectRelativePath());
            if (fileInfo != null) {
                HashSet otherFilesToProcess = new HashSet();
                Set partNames = fileInfo.getPartNames();
                for (String partName : partNames) {
                    projectInfo.partRemoved(packageName, partName, removedFile);
                    this.locateDuplicateFile(project, otherFilesToProcess, packageName, partName);
                }
                WorkingCopyFileInfoManager.getInstance().removeFile(project, removedFile.getProjectRelativePath());
                this.processDuplicateFiles(project, packageName, otherFilesToProcess);
                WorkingCopyDuplicatePartManager.getInstance().getDuplicatePartList(project).remove(removedFile);
            }
        }

        private void processChangedFile(final IProject project, final String packageName, final IFile changedFile) {
            if (changedFile.exists()) {
                try {
                    String fileContents = org.eclipse.edt.ide.core.internal.utils.Util.getFileContents(changedFile);
                    final HashSet duplicateFlies = new HashSet();
                    File fileAST = WorkingCopyASTManager.getInstance().getFileAST(changedFile, fileContents);
                    final IASTFileInfo newInfo = new WorkingCopyCompilerResourceFileInfoCreator(WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project), packageName, changedFile, fileAST, fileContents, new WorkingCopyDuplicatePartRequestor(project, packageName, changedFile), true).getASTInfo();
                    IFileInfo oldFileInfo = WorkingCopyFileInfoManager.getInstance().getFileInfo(project, changedFile.getProjectRelativePath());
                    final WorkingCopyProjectInfo projectInfo = WorkingCopyProjectInfoManager.getInstance().getProjectInfo(project);
                    IFileInfoDifferenceNotificationRequestor requestor = new IFileInfoDifferenceNotificationRequestor(){

                        @Override
                        public void partAdded(String partName) {
                            PackageAndPartName ppName = new PackageAndPartName(newInfo.getCaseSensitivePackageName(), newInfo.getCaseSensitivePartName(partName));
                            projectInfo.partAdded(packageName, partName, newInfo.getPartType(partName), changedFile, ppName);
                        }

                        @Override
                        public void partRemoved(String partName) {
                            projectInfo.partRemoved(packageName, partName, changedFile);
                            WorkingCopyResourceChangeJob.this.locateDuplicateFile(project, duplicateFlies, packageName, partName);
                        }

                        @Override
                        public void partChanged(String partName) {
                        }
                    };
                    FileInfoDifferencer differ = new FileInfoDifferencer(requestor);
                    differ.findDifferences(oldFileInfo, newInfo);
                    WorkingCopyFileInfoManager.getInstance().saveFileInfo(project, changedFile.getProjectRelativePath(), newInfo);
                    this.processDuplicateFiles(project, packageName, duplicateFlies);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error processing changed file: " + changedFile.getProjectRelativePath(), e);
                }
            }
        }

        private void processDuplicateFiles(IProject project, String packageName, HashSet otherFilesToProcess) {
            for (IFile file : otherFilesToProcess) {
                this.processChangedFile(project, packageName, file);
            }
        }

        protected void locateDuplicateFile(IProject project, HashSet otherFilesToProcess, String packageName, String partName) {
            Set filesForDuplicatePart = WorkingCopyDuplicatePartManager.getInstance().getDuplicatePartList(project).getFilesForDuplicatePart(packageName, partName);
            if (filesForDuplicatePart != null) {
                for (IFile file : filesForDuplicatePart) {
                    if (!file.exists()) continue;
                    otherFilesToProcess.add(file);
                    break;
                }
            }
        }
    }
}

