/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragment;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRootInfo;
import org.eclipse.edt.ide.core.internal.model.HashtableOfArrayToObject;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragment;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.mof.utils.NameUtile;

public class EglarPackageFragmentRoot
extends PackageFragmentRoot {
    protected final IPath jarPath;
    private boolean isBinaryProject = false;
    public static final String[] NO_STRINGS = new String[0];
    private static final ArrayList EMPTY_LIST = new ArrayList();

    protected EglarPackageFragmentRoot(IPath externalJarPath, IEGLProject project) {
        super(null, project, null);
        this.jarPath = externalJarPath;
    }

    protected EglarPackageFragmentRoot(IResource resource, IEGLProject project, String name) {
        super(resource, project, name);
        this.jarPath = resource.getFullPath();
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info) throws EGLModelException {
        IEGLElement[] children;
        HashtableOfArrayToObject rawPackageInfo;
        block10: {
            rawPackageInfo = new HashtableOfArrayToObject();
            ZipFile jar = null;
            try {
                try {
                    jar = this.getJar();
                    rawPackageInfo.put(NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
                    Enumeration<? extends ZipEntry> e = jar.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry member = e.nextElement();
                        this.initRawPackageInfo(rawPackageInfo, member.getName(), member.isDirectory());
                    }
                    children = new IEGLElement[rawPackageInfo.size()];
                    int index = 0;
                    int i = 0;
                    int length = rawPackageInfo.keyTable.length;
                    while (i < length) {
                        String[] pkgName = (String[])rawPackageInfo.keyTable[i];
                        if (pkgName != null) {
                            children[index++] = this.getPackageFragment(pkgName);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    if (!(e.getCause() instanceof ZipException)) {
                        if (e instanceof EGLModelException) {
                            throw (EGLModelException)e;
                        }
                        throw new EGLModelException(e);
                    }
                    Util.log(e, "Invalid ZIP archive: " + this.toStringWithAncestors());
                    children = NO_ELEMENTS;
                    EGLModelManager.getEGLModelManager().closeZipFile(jar);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                EGLModelManager.getEGLModelManager().closeZipFile(jar);
                throw throwable;
            }
            EGLModelManager.getEGLModelManager().closeZipFile(jar);
        }
        info.setChildren(children);
        ((EglarPackageFragmentRootInfo)info).rawPackageInfo = rawPackageInfo;
        return true;
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new EglarPackageFragmentRootInfo();
    }

    @Override
    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EglarPackageFragmentRoot) {
            EglarPackageFragmentRoot other = (EglarPackageFragmentRoot)o;
            return this.jarPath.equals((Object)other.jarPath) && this.getParent().equals(other.getParent());
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.jarPath.lastSegment();
    }

    public ZipFile getJar() throws CoreException {
        try {
            return EGLModelManager.getEGLModelManager().getZipFile(this.getPath());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getKind() {
        return 2;
    }

    int internalKind() throws EGLModelException {
        return 2;
    }

    public Object[] getNonJavaResources() throws EGLModelException {
        return null;
    }

    public IResource resource(PackageFragmentRoot root) {
        return null;
    }

    @Override
    public PackageFragment getPackageFragment(String[] pkgName) {
        return new EglarPackageFragment((PackageFragmentRoot)this, pkgName);
    }

    @Override
    public IResource getUnderlyingResource() throws EGLModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return this.jarPath.hashCode();
    }

    private void initRawPackageInfo(HashtableOfArrayToObject rawPackageInfo, String entryName, boolean isDirectory) {
        int length;
        int lastSeparator = isDirectory ? entryName.length() - 1 : entryName.lastIndexOf(47);
        Object[] pkgName = Util.splitOn('/', entryName, 0, lastSeparator);
        Object[] existing = null;
        int existingLength = length = pkgName.length;
        while (existingLength >= 0) {
            existing = (String[])rawPackageInfo.getKey(pkgName, existingLength);
            if (existing != null) break;
            --existingLength;
        }
        int i = existingLength;
        while (i < length) {
            if (!Util.isValidFolderNameForPackage((String)pkgName[i])) {
                if (!isDirectory) {
                    ArrayList[] children = (ArrayList[])rawPackageInfo.get(existing);
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(entryName);
                }
                return;
            }
            Object[] objectArray = existing;
            existing = new String[i + 1];
            System.arraycopy(objectArray, 0, existing, 0, i);
            existing[i] = NameUtile.getAsCaseSensitiveName((String)pkgName[i]);
            rawPackageInfo.put(existing, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            ++i;
        }
        if (isDirectory) {
            return;
        }
        ArrayList[] children = (ArrayList[])rawPackageInfo.get(pkgName);
        if (IRUtils.isEGLIRFileName((String)entryName)) {
            if (children[0] == EMPTY_LIST) {
                children[0] = new ArrayList();
            }
            String nameWithoutExtension = entryName.substring(lastSeparator + 1, entryName.length() - IRUtils.SUFFIX_eglxml.length);
            children[0].add(nameWithoutExtension);
        } else {
            if (children[1] == EMPTY_LIST) {
                children[1] = new ArrayList();
            }
            children[1].add(entryName);
        }
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.resource == null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public IPath getPath() {
        if (this.isExternal()) {
            return this.jarPath;
        }
        return super.getPath();
    }

    @Override
    protected boolean resourceExists() {
        if (this.resource == null) {
            return EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public boolean isBinaryProject() {
        return this.isBinaryProject;
    }

    public void setBinaryProject(boolean isBinaryProject) {
        this.isBinaryProject = isBinaryProject;
    }
}

