/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.internal.model.EGLModelResources;
import org.eclipse.edt.ide.core.internal.model.MoveResourceElementsOperation;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;

public class RenameResourceElementsOperation
extends MoveResourceElementsOperation {
    public RenameResourceElementsOperation(IEGLElement[] elements, IEGLElement[] destinations, String[] newNames, boolean force) {
        super(elements, destinations, force);
        this.setRenamings(newNames);
    }

    @Override
    protected String getMainTaskName() {
        return EGLModelResources.operationRenameResourceProgress;
    }

    @Override
    protected boolean isRename() {
        return true;
    }

    @Override
    protected void verify(IEGLElement element) throws EGLModelException {
        super.verify(element);
        int elementType = element.getElementType();
        if (elementType != 6 && elementType != 4) {
            this.error(967, element);
        }
        if (elementType == 6 && ((IEGLFile)element).isWorkingCopy()) {
            this.error(967, element);
        }
        this.verifyRenaming(element);
    }
}

