/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.index.impl.IFileDocument;
import org.eclipse.edt.ide.core.internal.model.indexing.AddFileToIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.SourceIndexer;
import org.eclipse.edt.ide.core.internal.model.util.Util;
import org.eclipse.edt.ide.core.model.EGLCore;

class AddEGLFileToIndex
extends AddFileToIndex {
    char[] contents;

    public AddEGLFileToIndex(IFile resource, IPath indexedContainer, IndexManager manager) {
        super(resource, indexedContainer, manager);
    }

    @Override
    protected boolean indexDocument(IIndex index) throws IOException {
        if (!this.initializeContents()) {
            return false;
        }
        index.add(new IFileDocument(this.resource, this.contents), new SourceIndexer(this.resource));
        return true;
    }

    public boolean initializeContents() {
        if (this.contents == null) {
            try {
                IPath location = this.resource.getLocation();
                if (location != null) {
                    try {
                        String encoding = this.resource.getCharset();
                        if (encoding == null) {
                            encoding = EGLCore.create(this.resource.getProject()).getOption(EGLCore.CORE_ENCODING, true);
                        }
                        this.contents = Util.getFileCharContent(location.toFile(), encoding);
                    }
                    catch (CoreException coreException) {}
                }
            }
            catch (IOException iOException) {}
        }
        return this.contents != null;
    }
}

