/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.ide.core.internal.model.SourceElementParser;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractIndexer;
import org.eclipse.edt.ide.core.internal.model.indexing.SourceIndexerRequestor;

public class SourceIndexer
extends AbstractIndexer {
    public static final String[] FILE_TYPES = new String[]{"egl"};
    IFile resourceFile;

    SourceIndexer(IFile resourceFile) {
        this.resourceFile = resourceFile;
    }

    @Override
    public String[] getFileTypes() {
        return FILE_TYPES;
    }

    @Override
    protected void indexFile(IDocument document) throws IOException {
        this.output.addDocument(document);
        SourceIndexerRequestor requestor = new SourceIndexerRequestor(this, document);
        SourceElementParser parser = new SourceElementParser(requestor);
        char[] source = null;
        char[] name = null;
        try {
            source = document.getCharContent();
            name = document.getName().toCharArray();
        }
        catch (Exception exception) {}
        if (source == null || name == null) {
            return;
        }
        try {
            parser.parseDocument(document, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setFileTypes(String[] fileTypes) {
    }
}

